// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

#ifndef POOMA_DOMAIN_DOMAIN_CALCULUS_H
#define POOMA_DOMAIN_DOMAIN_CALCULUS_H

//-----------------------------------------------------------------------------
// Function:
//   bool findLeftCommonEndpoint(a0,a1,s,b0,b1,t,endpoint)
//   bool findIntersectionEndpoints(a0,a1,s,b0,b1,t,i0,i1,is)
//-----------------------------------------------------------------------------

//////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
// Overview: 
// This file defines the prototypes for routines used in the domain
// calculus computations.  These routines are not part of the main user
// API, they are mainly for the domain calculus implementation.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Typedefs:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Forward Declarations:
//-----------------------------------------------------------------------------

// findLeftCommonEndpoint is used by the domain calculus routines to
// find the leftmost common endpoint for two domains defined by
// [a0:a1:s] and [b0:b1:t].  If an endpoint is possible, this returns
// true and the endpoint in the final argument.  If one is not possible,
// due to incompatible striding, this returns false and leaves the final
// argument unchanged.

extern
bool findLeftCommonEndpoint(int a0, int a1, int s, int b0, int b1, int t,
                            int &endpoint);

// findIntersectionEndpoints is used by the domain calculus routines to
// find the endpoints and stride of an intersection domain given
// two other strided domains defined by [a0:a1:s] and [b0:b1:t].  If
// this is possible, this return true and the min, max, stride of the
// resulting domain [i0,i1,is] in the final arguments.  If no intersection
// is possible, due to incompatible striding, this returns false and
// leaves the final arguments unchanged.  Note that if a domain is returned,
// it will always be true that i0 <= i1, is > 0.

extern
bool findIntersectionEndpoints(int a0, int a1, int s, int b0, int b1, int t,
                               int &i0, int &i1, int &is);

//////////////////////////////////////////////////////////////////////

#endif     // POOMA_DOMAIN_DOMAIN_CALCULUS_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: DomainCalculus.h,v $   $Author: swhaney $
// $Revision: 1.4 $   $Date: 2000/03/07 13:16:34 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
