# Build up the commands used to execute compilers, linkers, etc.
# ACL:license
#  ----------------------------------------------------------------------
#  This software and ancillary information (herein called "SOFTWARE")
#  called POOMA (Parallel Object-Oriented Methods and Applications) is
#  made available under the terms described here.  The SOFTWARE has been
#  approved for release with associated LA-CC Number LA-CC-98-65.
#  
#  Unless otherwise indicated, this SOFTWARE has been authored by an
#  employee or employees of the University of California, operator of the
#  Los Alamos National Laboratory under Contract No.  W-7405-ENG-36 with
#  the U.S. Department of Energy.  The U.S. Government has rights to use,
#  reproduce, and distribute this SOFTWARE, and to allow others to do so.
#  The public may copy and use this SOFTWARE, FOR NONCOMMERCIAL USE ONLY,
#  without charge, provided that this Notice and any statement of
#  authorship are reproduced on all copies.  Neither the Government nor
#  the University makes any warranty, express or implied, or assumes any
#  liability or responsibility for the use of this SOFTWARE.
#  
#  If SOFTWARE is modified to produce derivative works, such modified
#  SOFTWARE should be clearly marked, so as not to confuse it with the
#  version available from LANL.
#  
#  For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
#  or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
#  ----------------------------------------------------------------------
# ACL:license

# Do this here rather than in rules.mk, because multiple macros need access to them.

# Strip PROJECT_ROOT from include paths, since all compiles will be relative to it.
#RULE_INCLUDES       := $(subst $(PROJECT_ROOT)/,,$(SUITE_INCLUDES))
#RULE_INCLUDES       := $(subst $(PROJECT_ROOT),.,$(RULE_INCLUDES))
RULE_INCLUDES        = $(SUITE_INCLUDES)

# Select first- (or 'other-pass') flags with C++ compiler
RULE_CXXOPTS         = $(SUITE_CXXOPTS_$(PASS))

# Select first- (or 'other-pass') flags with C compiler
RULE_COPTS           = $(SUITE_COPTS_$(PASS))

# Select first- (or 'other-pass') flags with F77 compiler
RULE_F77OPTS         = $(SUITE_F77OPTS_$(PASS))

# Select first- (or 'other-pass') flags with archiver
RULE_AR_OPTS         = $(SUITE_AROPTS_$(PASS))

# Select first- (or 'other-pass') flags with prelinker
RULE_PRELINK_OPTS    = $(SUITE_PRELINKOPTS_$(PASS))

# Select first- (or 'other-pass') flags with linker
RULE_LD_OPTS         = $(SUITE_LDOPTS_$(PASS))



# Name of file to contain stderr & stdout
INFO_FILE            = $@_$(PASS).info

# This is prepended to compile, link, archive, preprocess, etc rules.
PRE_CMDLINE          = cd $(PROJECT_ROOT); TMPDIR=$(TMPDIR)/$(SUITE); $(TIME)

# This is prepended to compile, link, archive, preprocess, etc rules.
PDB_PRE_CMDLINE      = cd $(@D); TMPDIR=$(TMPDIR)/$(SUITE); $(TIME)

# Build command line for preprocessor
PREPROCESS_CMDLINE   = $(CXX) $< -E $(SUITE_DEFINES) $(RULE_CXXOPTS) $(RULE_INCLUDES) 

# Build command line for C++ compiler
CXX_COMPILE_CMDLINE  = $(CXX) -c $< -o $@ $(SUITE_DEFINES) $(RULE_CXXOPTS) $(RULE_INCLUDES) 

# Build command line for C++ compiler while profiling
CXX_PROFILE_COMPILE_CMDLINE  = $(CXX) -c $< -o $@ $(SUITE_DEFINES) $(RULE_CXXOPTS) $(RULE_INCLUDES) -I$(@D)/..

# Build command line for C compiler
C_COMPILE_CMDLINE  = $(CC) -c $< -o $@ $(SUITE_DEFINES) $(RULE_COPTS) $(RULE_INCLUDES)

# TAU instrumentation command line
INSTRUMENT_CMDLINE = $(TAUINSTR) $? -o $@

# Command line to generate .pdb file
PDB_CMDLINE = $(TAUPARSE) $< $(SUITE_INCLUDES) -I$(@D)/..

# Build command line for F77 compiler
F77_COMPILE_CMDLINE  = $(F77) -c $< -o $@ $(SUITE_DEFINES) $(RULE_F77OPTS) $(RULE_INCLUDES)

# touch command line 
TOUCH_CMDLINE        = $(TOUCH) $@

# Build command line for prelink step
PRELINK_CMDLINE = $(PRELINK) $(RULE_PRELINK_OPTS) $(filter %.o,$+)

# Build command line for archiver
ifeq ("$(INSTREPO)", "1") 
	AR_CMDLINE = $(AR) $(RULE_AR_OPTS) $@ $(filter %.o,$+) $(INSTANTIATION_DIR)/*.o
else
	AR_CMDLINE = $(AR) $(RULE_AR_OPTS) $@ $(filter %.o,$+)
endif

# Build command line for loader

ifeq ("$(LD)", "purify")
# Build Purify command line
	LD_LINK_CMDLINE = $(PURIFY) $(SUITE_PURIFY_OPTS) $(CXX) -o $@ $+ $(RULE_LD_OPTS)
else
# Build normal link command line.
	LD_LINK_CMDLINE = $(LD) -o $@ $+ $(RULE_LD_OPTS) 
endif

# rules and macros
include $(SHARED_ROOT)/rules.mk

# Include (if it exists) the dependency file.
#-include $(LIBRARY_ROOT)/depend.mk


# ACL:rcsinfo
#  ----------------------------------------------------------------------
#  $RCSfile: tail.mk,v $   $Author: julianc $
#  $Revision: 1.18 $   $Date: 2000/04/25 17:18:04 $
#  ----------------------------------------------------------------------
# ACL:rcsinfo
