// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// array_test23.cpp more tests to verify correctnes of stencil objects
//-----------------------------------------------------------------------------

// Include files

#include "Pooma/Pooma.h"
#include "Utilities/Tester.h"
#include "Domain/Loc.h"
#include "Domain/Interval.h"
#include "Engine/BrickEngine.h"
#include "Engine/Stencil.h"
#include "Array/Array.h"
#include "Pooma/FunctorResult.h"
#include "Pooma/Indices.h"

#include <iostream>
#include <math.h>

template<class Array>
bool isSmall(const Array &a)
{
  double epsilon = 0.000000001;
  return (sum(a*a) < epsilon);
}

class AsymDoof
{
public:
  AsymDoof() { }
  AsymDoof(const AsymDoof &) { }

  template <class A>
  inline
  typename A::Element_t
  operator()(const A& x, int i, int j) const
  {
    return ( (1.0/15.0) *
             ( x(i+1,j+1) + 2*x(i+1,j  ) + 3*x(i+1,j-1) +
               3*x(i  ,j+1) + x(i  ,j  ) + 2*x(i  ,j-1) +
               4*x(i-1,j+1) + 3*x(i-1,j  ) + 5*x(i-1,j-1) ) );
  }

  inline int lowerExtent(int) const { return 1; }
  inline int upperExtent(int) const { return 1; }  

private:
};

int main(int argc, char *argv[])
{
  // Initialize POOMA and output stream, using Tester class
  Pooma::initialize(argc, argv);
  Pooma::Tester tester(argc, argv);

  tester.out() << argv[0] << ": More stencil tests.."
	       << std::endl;
  tester.out() << "------------------------------------------------"
	       << std::endl;


  Stencil<AsymDoof> doof;

  Interval<1> inew(10);
  Interval<2> d2(inew,inew);
  Interval<2> inset = doof.insetDomain(d2);

  Array<2,double,Brick> init(d2),version1(d2),version2(d2);

  init = iota(d2).comp(0) + sin(iota(d2).comp(1) * 0.4);
  version1 = 0.0;

  Interval<1> d1(4);

  Array<1,double,Brick> g(d1), h(d1);
  Array<1,Loc<2>,Brick> ind(d1);

  ind(0) = Loc<2>(3,4);
  ind(1) = Loc<2>(7,4);
  ind(2) = Loc<2>(4,4);
  ind(3) = Loc<2>(5,6);

  version1(inset) = doof(init);

  g = version1(inset)(ind);
  h = doof(init)(ind);

  tester.out() << version1 << std::endl;
  tester.out() << g << std::endl;
  tester.out() << h << std::endl;
  tester.check("indirection of stencil", isSmall(g - h));

  tester.out() << "------------------------------------------------"
	       << std::endl;

  int retval = tester.results("array_test23");

  Pooma::finalize();

  return retval;  
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: array_test23.cpp,v $   $Author: sa_smith $
// $Revision: 1.5 $   $Date: 2000/07/04 05:06:54 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
