/*
 * $Id: xim_IC.c,v 1.4 1999/02/18 08:08:14 thhsieh Exp $
 */

/******************************************************************
 
  Copyright 1994, 1995 by Sun Microsystems, Inc.
  Copyright 1993, 1994 by Hewlett-Packard Company
 
Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Sun Microsystems, Inc.
and Hewlett-Packard not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.
Sun Microsystems, Inc. and Hewlett-Packard make no representations about
the suitability of this software for any purpose.  It is provided "as is"
without express or implied warranty.
 
SUN MICROSYSTEMS INC. AND HEWLETT-PACKARD COMPANY DISCLAIMS ALL
WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SUN MICROSYSTEMS, INC. AND HEWLETT-PACKARD COMPANY BE LIABLE FOR ANY
SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 
  Author: Hidetoshi Tajima(tajima@Eng.Sun.COM) Sun Microsystems, Inc.
 
******************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include "Ximd/IMdkit.h"
#include "Ximd/Xi18n.h"
#include "xim.h"
#include "xcintool.h"
#include "xcin_core.h"
#include "imodule.h"
#include "gui.h"

/* 
 * prototype:  match(char *attr, XICAttribute *attr_list);
 */
#define match(attr, attr_list) \
	( ( strcmp((attr), (attr_list)->name) == 0 ) ? 1 : 0 )

/*----------------------------------------------------------------------------

	Tool functions.

----------------------------------------------------------------------------*/

static IC *ic_list = (IC *)NULL;
static IC *free_list = (IC *)NULL;

static IC *
new_IC(void)
{
    static CARD16 icid = 0;
    IC *rec;

    if (free_list != NULL) {
        rec = free_list;
        free_list = free_list->next;
    } 
    else
        rec = (IC *)malloc(sizeof(IC));

    memset(rec, 0, sizeof(IC));
    rec->id = ++icid;
    rec->inpinfo.icid = (int)(rec->id);
    rec->sinmd_keystroke = calloc(10, sizeof(wch_t));
    rec->skey_size = 10;
    rec->cch = calloc(WCH_SIZE + 1, sizeof(char));
    rec->cch_size = WCH_SIZE + 1;

    rec->next = ic_list;
    ic_list = rec;
    return rec;
}

static void
free_IC(IC *rec)
{
    call_xim_end(rec);
    if (rec->resource_name)
	free(rec->resource_name);
    if (rec->resource_class)
	free(rec->resource_class);
    if (rec->cch)
	free(rec->cch);
    if (rec->sinmd_keystroke)
	free(rec->sinmd_keystroke);
}

static void
check_focus(IC *ic)
{
    Window focus_return;
    int revert_to_return;
    static char gotit=0;

    if (gotit)
        return;
    XGetInputFocus(gui_conf.display, &focus_return, &revert_to_return);
    if (focus_return == ic->client_win) {
        gotit = 1;
        call_switch_in(ic);
    }
}

static void
ic_set_value_by_name(IC *rec, IMChangeICStruct *call_data)
/*
 *  For details, see Xlib Ref, Chap 11.6
 */
{
    XICAttribute *ic_attr = call_data->ic_attr;
    XICAttribute *pre_attr = call_data->preedit_attr;
    XICAttribute *sts_attr = call_data->status_attr;
    register int i;

    for (i=0; i < (int)(call_data->ic_attr_num); i++, ic_attr++) {
        if (match (XNInputStyle, ic_attr)) {
            rec->input_style = *((INT32 *)ic_attr->value);
            if (rec->input_style != (XIMPreeditNothing|XIMStatusNothing)) {
                perr(XCINMSG_WARNING, 
		    _("XNInputStyle: only PreeditNothing|XIMStatusNothing mode implemented.\n"));
		rec->input_style = XIMPreeditNothing|XIMStatusNothing;
            }
        } 
	else if (match (XNClientWindow, ic_attr)) {
            rec->client_win = *(Window *)ic_attr->value;
	    check_focus(rec);
	}
        else if (match (XNFocusWindow, ic_attr))
            rec->focus_win = *(Window *)ic_attr->value;
	else if (match (XNResourceName, ic_attr))
	    rec->resource_name = strdup((char *)ic_attr->value);
	else if (match (XNResourceClass, ic_attr))
	    rec->resource_class = strdup((char *)ic_attr->value);
        else
            perr(XCINMSG_WARNING, 
		_("ic_set: unknown IC attr: %s\n"), ic_attr->name);
    }
        
    for (i=0; i < (int)(call_data->preedit_attr_num); i++, pre_attr++) {
        if (match (XNArea, pre_attr))
            rec->pre_attr.area = *(XRectangle *)pre_attr->value;
        else if (match (XNAreaNeeded, pre_attr))
            rec->pre_attr.area_needed = *(XRectangle *)pre_attr->value;
        else if (match (XNSpotLocation, pre_attr))
            rec->pre_attr.spot_location = *(XPoint *)pre_attr->value;
        else if (match (XNColormap, pre_attr))
            rec->pre_attr.cmap = *(Colormap *)pre_attr->value;
        else if (match (XNStdColormap, pre_attr))
            rec->pre_attr.cmap = *(Colormap *)pre_attr->value;
        else if (match (XNForeground, pre_attr))
            rec->pre_attr.foreground = *(CARD32 *)pre_attr->value;
        else if (match (XNBackground, pre_attr))
            rec->pre_attr.background = *(CARD32 *)pre_attr->value;
        else if (match (XNBackgroundPixmap, pre_attr))
            rec->pre_attr.bg_pixmap = *(Pixmap *)pre_attr->value;
        else if (match (XNFontSet, pre_attr)) {
            if (rec->pre_attr.base_font != NULL) {
                if (match (rec->pre_attr.base_font, pre_attr))
                    continue;
                XFree(rec->pre_attr.base_font);
            }
            rec->pre_attr.base_font = strdup(pre_attr->value);
        } 
        else if (match (XNLineSpace, pre_attr))
            rec->pre_attr.line_space = *(CARD32 *)pre_attr->value;
        else if (match (XNCursor, pre_attr))
            rec->pre_attr.cursor = *(Cursor *)pre_attr->value;
        else
            perr(XCINMSG_WARNING, 
		"ic_set: unknown IC pre_attr: %s\n", ic_attr->name);
    }
	
    for (i=0; i < (int)(call_data->status_attr_num); i++, sts_attr++) {
        if (match (XNArea, sts_attr))
            rec->sts_attr.area = *(XRectangle *)sts_attr->value;
        else if (match (XNAreaNeeded, sts_attr))
            rec->sts_attr.area_needed = *(XRectangle *)sts_attr->value;
        else if (match (XNColormap, sts_attr))
            rec->sts_attr.cmap = *(Colormap *)sts_attr->value;
        else if (match (XNStdColormap, sts_attr))
            rec->sts_attr.cmap = *(Colormap *)sts_attr->value;
        else if (match (XNForeground, sts_attr))
            rec->sts_attr.foreground = *(CARD32 *)sts_attr->value;
        else if (match (XNBackground, sts_attr))
            rec->sts_attr.background = *(CARD32 *)sts_attr->value;
        else if (match (XNBackgroundPixmap, sts_attr))
            rec->sts_attr.bg_pixmap = *(Pixmap *)sts_attr->value;
        else if (match (XNFontSet, sts_attr)) {
            if (rec->sts_attr.base_font != NULL) {
                if (match (rec->sts_attr.base_font, sts_attr))
                    continue;
                XFree(rec->sts_attr.base_font);
            }
            rec->sts_attr.base_font = strdup(sts_attr->value);

        } 
	else if (match (XNLineSpace, sts_attr))
            rec->sts_attr.line_space= *(CARD32 *)sts_attr->value;
        else if (match (XNCursor, sts_attr))
            rec->sts_attr.cursor = *(Cursor *)sts_attr->value;
        else
            perr(XCINMSG_WARNING, 
		"ic_set: unknown IC sts_attr: %s\n", ic_attr->name);
    }
}


/*----------------------------------------------------------------------------

	External functions.

----------------------------------------------------------------------------*/

IC *
ic_find(CARD16 icid)
{
    IC *rec = ic_list;

    while (rec != NULL) {
        if (rec->id == icid)
            return rec;
        rec = rec->next;
    }
    return NULL;
}

int 
ic_create(XIMS ims, IMChangeICStruct *call_data)
{
    IC *ic;
 
    if (! (ic = new_IC()))
        return False;

    ic->connect_id = call_data->connect_id;
    call_data->icid = ic->id;
    ic->inp_num = (inp_state_t)(xcin_conf.default_im);
    ic->inp_state |= IC_NEWIC;

    ic_set_value_by_name(ic, call_data);
    return True;
}

int 
ic_destroy(XIMS ims, IMDestroyICStruct *call_data)
{
    IC *rec, *last=NULL;

    for (rec=ic_list; rec!=NULL; last=rec, rec=rec->next) {
        if (rec->id == call_data->icid) {
            if (last != NULL)
                last->next = rec->next;
            else
                ic_list = rec->next;
            rec->next = free_list;
            free_list = rec;
	    free_IC(rec);
            return  True;
        }
    }
    return False;
}

int
ic_clean_all(CARD16 connect_id)
{
    IC *rec, *last=NULL;
    int clean_count=0;

    for (rec=ic_list; rec!=NULL; last=rec, rec=rec->next) {
        if (rec->connect_id == connect_id) {
            if (last != NULL)
                last->next = rec->next;
            else
                ic_list = rec->next;
            rec->next = free_list;
            free_list = rec;
	    free_IC(rec);
	    clean_count ++;
        }
    }
    return (clean_count) ? True : False;
}

int 
ic_set(XIMS ims, IMChangeICStruct *call_data)
{
    IC *rec;

    if (! (rec = ic_find(call_data->icid)))
        return False;
    ic_set_value_by_name(rec, call_data);
    return True;
}

int 
ic_get(XIMS ims, IMChangeICStruct *call_data)
{
    XICAttribute *ic_attr = call_data->ic_attr;
    XICAttribute *pre_attr = call_data->preedit_attr;
    XICAttribute *sts_attr = call_data->status_attr;
    IC *rec = ic_find(call_data->icid);
    register int i;

    if (rec == NULL)
        return False;

    for (i=0; i < (int)call_data->ic_attr_num; i++, ic_attr++) {
        if (match (XNFilterEvents, ic_attr)) { /* hardwired XNFilterEvents */
            ic_attr->value = (void *)malloc(sizeof(CARD32));
            ic_attr->value_length = sizeof(CARD32);
            *(CARD32*)ic_attr->value = KeyPressMask|KeyReleaseMask;
        }
	else if (match (XNInputStyle, ic_attr)) {
	    ic_attr->value = (void *)malloc(sizeof(INT32));
	    ic_attr->value_length = sizeof(INT32);
	    *(INT32*)ic_attr->value = XIMPreeditNothing|XIMStatusNothing;
	}
	else if (match (XNSeparatorofNestedList, ic_attr)) {
	    ic_attr->value = (void *)malloc(sizeof(CARD16));
	    ic_attr->value_length = sizeof(CARD16);
	    *(CARD16*)ic_attr->value = 0;
	}
	else {
            perr(XCINMSG_WARNING, 
		"ic_get: unknown IC attr: %s\n", ic_attr->name);
	    return False;
	}
    }

    /* preedit attributes */
    for (i=0; i < (int)call_data->preedit_attr_num; i++, pre_attr++) {
        if (match (XNArea, pre_attr)) {
            pre_attr->value = (void *)malloc(sizeof(XRectangle));
            *(XRectangle*)pre_attr->value = rec->pre_attr.area;
            pre_attr->value_length = sizeof(XRectangle);
        } 
	else if (match (XNAreaNeeded, pre_attr)) {
            pre_attr->value = (void *)malloc(sizeof(XRectangle));
            *(XRectangle*)pre_attr->value = rec->pre_attr.area_needed;
            pre_attr->value_length = sizeof(XRectangle);
        } 
	else if (match (XNSpotLocation, pre_attr)) {
            pre_attr->value = (void *)malloc(sizeof(XPoint));
            *(XPoint*)pre_attr->value = rec->pre_attr.spot_location;
            pre_attr->value_length = sizeof(XPoint);
        } 
	else if (match (XNFontSet, pre_attr)) {
            CARD16 base_len = (CARD16)strlen(rec->pre_attr.base_font);
            int total_len = sizeof(CARD16) + (CARD16)base_len;
            char *p;

            pre_attr->value = (void *)malloc(total_len);
            p = (char *)pre_attr->value;
            memmove(p, &base_len, sizeof(CARD16));
            p += sizeof(CARD16);
            strncpy(p, rec->pre_attr.base_font, base_len);
            pre_attr->value_length = total_len;
        } 
	else if (match (XNForeground, pre_attr)) {
            pre_attr->value = (void *)malloc(sizeof(long));
            *(long*)pre_attr->value = rec->pre_attr.foreground;
            pre_attr->value_length = sizeof(long);
        } 
	else if (match (XNBackground, pre_attr)) {
            pre_attr->value = (void *)malloc(sizeof(long));
            *(long*)pre_attr->value = rec->pre_attr.background;
            pre_attr->value_length = sizeof(long);
        } 
	else if (match (XNLineSpace, pre_attr)) {
            pre_attr->value = (void *)malloc(sizeof(long));
#if 0
            *(long*)pre_attr->value = rec->pre_attr.line_space;
#endif
            *(long*)pre_attr->value = 18;
            pre_attr->value_length = sizeof(long);
        }
	else {
            perr(XCINMSG_WARNING, 
		"ic_get: unknown IC pre_attr: %s\n", ic_attr->name);
	    return False;
	}
    }

    /* status attributes */
    for (i = 0; i < (int)call_data->status_attr_num; i++, sts_attr++) {
        if (match (XNArea, sts_attr)) {
            sts_attr->value = (void *)malloc(sizeof(XRectangle));
            *(XRectangle*)sts_attr->value = rec->sts_attr.area;
            sts_attr->value_length = sizeof(XRectangle);
        } 
	else if (match (XNAreaNeeded, sts_attr)) {
            sts_attr->value = (void *)malloc(sizeof(XRectangle));
            *(XRectangle*)sts_attr->value = rec->sts_attr.area_needed;
            sts_attr->value_length = sizeof(XRectangle);
        } 
	else if (match (XNFontSet, sts_attr)) {
            CARD16 base_len = (CARD16)strlen(rec->sts_attr.base_font);
            int total_len = sizeof(CARD16) + (CARD16)base_len;
            char *p;

            sts_attr->value = (void *)malloc(total_len);
            p = (char *)sts_attr->value;
            memmove(p, &base_len, sizeof(CARD16));
            p += sizeof(CARD16);
            strncpy(p, rec->sts_attr.base_font, base_len);
            sts_attr->value_length = total_len;
        } 
	else if (match (XNForeground, sts_attr)) {
            sts_attr->value = (void *)malloc(sizeof(long));
            *(long*)sts_attr->value = rec->sts_attr.foreground;
            sts_attr->value_length = sizeof(long);
        } 
	else if (match (XNBackground, sts_attr)) {
            sts_attr->value = (void *)malloc(sizeof(long));
            *(long*)sts_attr->value = rec->sts_attr.background;
            sts_attr->value_length = sizeof(long);
        } 
	else if (match (XNLineSpace, sts_attr)) {
            sts_attr->value = (void *)malloc(sizeof(long));
#if 0
            *(long*)sts_attr->value = rec->sts_attr.line_space;
#endif
            *(long*)sts_attr->value = 18;
            sts_attr->value_length = sizeof(long);
        }
	else {
            perr(XCINMSG_WARNING, 
		"ic_get: unknown IC sts_attr: %s\n", ic_attr->name);
	    return False;
	}
    }
    return True;
}

/*---------------------------------------------------------------------------

	Garbage Collection

---------------------------------------------------------------------------*/

#define TIMECHECK_STEP    300
#define IC_IDLE_TIME      600
#define BAD_LIST_INCREASE 100

static Window *bad_list;
static int n_bad_list, bad_list_size;

static int
destroy_ic_by_win(Window win)
{
    IC *rec, *last=NULL;

    for (rec=ic_list; rec!=NULL; last=rec, rec=rec->next) {
        if (rec->client_win == win) {
	    DebugLog("IC id=%d window=0x%x deleted.\n", 
			rec->id, rec->client_win);

            if (last != NULL)
                last->next = rec->next;
            else
                ic_list = rec->next;
            rec->next = free_list;
            free_list = rec;
	    free_IC(rec);
            return  True;
        }
    }
    return False;
}

static int
bad_window_handler(Display *disp, XErrorEvent *err)
{
    if (n_bad_list >= bad_list_size) {
	bad_list_size += BAD_LIST_INCREASE;
	bad_list = realloc(bad_list, bad_list_size * sizeof(Window));
    }
    bad_list[n_bad_list] = err->resourceid;
    n_bad_list ++;
    return 0;
}

void
check_ic_exist(int icid)
{
    static time_t last_check;

    IC *ic = ic_list;
    time_t current_time;
    int i;
    Window root;
    int x, y;
    unsigned width, height, bw, depth;
    int (*old_handler)();

    current_time = time(NULL);
    if (current_time - last_check <= TIMECHECK_STEP)
	return;

    if (! bad_list) {
	bad_list_size = BAD_LIST_INCREASE;
	bad_list = malloc(bad_list_size * sizeof(Window));
    }
    DebugLog("Begin check: current time = %d, last check = %d\n", 
		current_time, last_check);
    n_bad_list = 0;

    old_handler = XSetErrorHandler(bad_window_handler);
    while (ic) {
	if (ic->id == icid)
	    ic->exec_time = current_time;
	else if (ic->client_win && 
		 current_time - ic->exec_time > IC_IDLE_TIME) {
	    DebugLog("Check IC: id=%d, window=0x%x, exec_time=%d.\n", 
			ic->id, ic->client_win, ic->exec_time);
	    ic->exec_time = current_time;
	    XGetGeometry(gui_conf.display, ic->client_win, 
			&root, &x, &y, &width, &height, &bw, &depth);
	    XSync(gui_conf.display, False);
	}
	ic = ic->next;
    }
    (void) XSetErrorHandler(old_handler);

    for (i=0; i<n_bad_list; i++)
	destroy_ic_by_win(bad_list[i]);

    last_check = current_time;
}
