/*
 * $Id: module.c,v 1.3 1999/02/18 08:08:07 thhsieh Exp $
 */
/*
    Copyright (C) 1999 by  XCIN TEAM

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For any question or suggestion, please mail to xcin mailing-list:
    xcin@linux.org.tw, or the maintainer Tung-Han Hsieh: thhsieh@linux.org.tw
*/      


#include <stdio.h>
#include <stdlib.h>
#include <dlfcn.h>
#include <string.h>
#include "xcintool.h"
#include "imodule.h"
#include "xcin_core.h"

static tmodule_t *mod_templet;
imodule_t *imodules;            /* imodule: head of list;                  *
                                 * imodule->next: next to the head;        *
                                 * imodule->prev: end element of the list; */

/*---------------------------------------------------------------------------

        Load Module & Module Init.

---------------------------------------------------------------------------*/

static int
check_module(module_t *modp, char *ldso_name)
{
    char *str=NULL;

    if (! modp->name)
	str = "name";
    else if (! modp->version)
	str = "version";
    else if (! modp->init)
	str = "init";
    else if (! modp->xim_init)
	str = "xim_init";
    else if (! modp->xim_end)
	str = "xim_end";
    else if (! modp->keystroke)
	str = "keystroke";
    else if (! modp->show_keystroke)
	str = "show_keystroke";
    else if (modp->switch_in && ! modp->switch_out)
	str = "switch_out";
    else if (modp->switch_out && ! modp->switch_in)
	str = "switch_in";

    if (str) {
	perr(XCINMSG_IWARNING,
	    _("undefined symbol \"%s\" in module \"%s\", ignore.\n"),
	    str, ldso_name);
	return  0;
    }
    if (! check_version(MODULE_VERSION, modp->version, 0)) {
        perr(XCINMSG_IWARNING, 
	    _("not valid module \"%s\" with version \"%s\", ignore.\n"), 
            modp->name, (modp->version) ? modp->version : "(null)");
	return  False;
    }
    return  True;
}

static tmodule_t *
load_mod_ldso(char *modname, enum mtype mod_type)
{
    char ver_rule[128], ldso_fn[256];
    char *version;
    module_t *modp;
    tmodule_t *tmodp;
    void *ldso;
    
    sprintf(ldso_fn, "%s/%s.so", xcin_conf.user_dir, modname);
    if (! (ldso = dlopen(ldso_fn, RTLD_LAZY))) {
        sprintf(ldso_fn, "%s/%s.so", xcin_conf.default_dir, modname);
        if (! (ldso = dlopen(ldso_fn, RTLD_LAZY))) {
	    perr(XCINMSG_IWARNING, "dlerror: %s\n", dlerror());
	    perr(XCINMSG_WARNING, 
		_("module \"%s.so\" not found, ignore.\n"), modname);
	    return  NULL;
	}
    }
    modp = (module_t *)dlsym(ldso, "module_ptr");
    if (! check_module(modp, ldso_fn)) {
	dlclose(ldso);
	return  NULL;
    }

    tmodp = calloc(1, sizeof(tmodule_t));
    tmodp->ldso = ldso;
    tmodp->name = modp->name;
    tmodp->version = modp->version;
    tmodp->comments = modp->comments;
    tmodp->valid_objname = modp->valid_objname;
    tmodp->module_type = modp->module_type;
    tmodp->conf_size = modp->conf_size;
    tmodp->init = modp->init;
    tmodp->xim_init = modp->xim_init;
    tmodp->xim_end = modp->xim_end;
    tmodp->switch_in = modp->switch_in;
    tmodp->switch_out = modp->switch_out;
    tmodp->keystroke = modp->keystroke;
    tmodp->show_keystroke = modp->show_keystroke;

    if (! mod_templet)
        mod_templet = tmodp;
    else {
        mod_templet->prev->next = tmodp;
        tmodp->prev = mod_templet->prev;
    }
    mod_templet->prev = tmodp;

    return  tmodp;
}

static imodule_t * 
creat_module(tmodule_t *templet, char *objname)
{
    imodule_t *imodp;

    if (! templet)
	return  NULL;

    imodp = calloc(1, sizeof(imodule_t));
    imodp->name = templet->name;
    imodp->version = templet->version;
    imodp->comments = templet->comments;
    imodp->module_type = templet->module_type;
    imodp->conf = calloc(1, templet->conf_size);
    imodp->init = templet->init;
    imodp->xim_init = templet->xim_init;
    imodp->xim_end = templet->xim_end;
    imodp->switch_in = templet->switch_in;
    imodp->switch_out = templet->switch_out;
    imodp->keystroke = templet->keystroke;
    imodp->show_keystroke = templet->show_keystroke;

    imodp->objname = (objname) ? strdup(objname) : imodp->name; 

    return  imodp;
}

imodule_t *
load_module(char *modname, char *objname, int mod_type)
{
    imodule_t *imodp=imodules;
    tmodule_t *tmodp=mod_templet;
    char **objn;
    int i;
/*
 *  See that if the desired module with obj_name has been created.
 */
    while (imodp) {
	if (imodp->module_type == mod_type && !strcmp(imodp->name, modname) && 
	    !strcmp(imodp->objname, objname))
	    return  imodp;
	imodp = imodp->next;
    }

/*
 *  Search the templet.
 */
    while (tmodp) {
	if (tmodp->module_type != mod_type || strcmp(modname, tmodp->name)) {
	    tmodp = tmodp->next;
	    continue;
	}
	objn = tmodp->valid_objname;
	if (! objn) {
	    if (! strcmp_wild(tmodp->name, objname))
		break;
	}
	else {
	    while (*objn) {
	        if(! strcmp_wild(*objn, objname))
		    break;
	        objn ++;
	    }
	    if (*objn)
		break;
	}
	tmodp = tmodp->next;
    }

/*
 *  Load modules from ldso and run module init.
 */
    if (! tmodp)
	tmodp = load_mod_ldso(modname, mod_type);
    imodp = creat_module(tmodp, objname);

    if (! imodp)
	return NULL;
    if (imodp->init(imodp->conf, objname, &xcin_conf) != True) {
	free(imodp->conf);
	free(imodp);
	return NULL;
    }

/*
 *  Load module OK. Now put the module into link list.
 */
    if (! imodules)
        imodules = imodp;
    else {
        imodules->prev->next = imodp;
        imodp->prev = imodules->prev;
    }
    imodules->prev = imodp;
    return imodp;
}

void 
free_module(cinput_t *cp)
{
    if (cp->modname) {
	free(cp->modname);
	cp->modname = NULL;
    }
    if (cp->objname) {
	free(cp->objname);
	cp->objname = NULL;
    }
    if (cp->inpmod) {
	free(cp->inpmod->conf);
	free(cp->inpmod);
	cp->inpmod = NULL;
    }
}
