/*
 * Copyright 1999, TaBE Project, All Rights Reserved.
 * Copyright 1999, Pai-Hsiang Hsiao, All Rights Reserved.
 *
 * $Id: tsiyindump.c,v 1.3 1999/05/12 16:09:56 shawn Exp $
 *
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include <tabe.h>

void
usage()
{
  printf("Usage: tsidump -d <TsiDB> -y <TsiYinDB>\n");
  exit(0);
}

void
dump(db, ydb)
struct TsiDB    *db;
struct TsiYinDB *ydb;
{
  struct TsiInfo *tsi;
  struct TsiYinInfo *tsiyin;
  int rval, i, j, len;

  rval = db->RecordNumber(db);
  if (rval < 0) {
    fprintf(stderr, "tsidump: wrong DB format.\n");
    usage();
  }

  tsi = (struct TsiInfo *)malloc(sizeof(struct TsiInfo));
  tsi->tsi = (ZhiStr)malloc(sizeof(unsigned char)*80);
  memset(tsi->tsi, 0, 80);
  tsi->refcount = -1;
  tsi->yinnum = -1;

  tsiyin = (struct TsiYinInfo *)malloc(sizeof(struct TsiYinInfo));
  memset(tsiyin, 0, sizeof(struct TsiYinInfo));

  i = 0;
  while (1) {
    if (i == 0) {
      db->CursorSet(db, tsi);
    }
    else {
      rval = db->CursorNext(db, tsi);
      if (rval < 0) {
        break;
      }
    }
    i++;
    if (!tsi->yinnum) {
      tabeTsiInfoLookupPossibleTsiYin(tsi);
    }
    len = strlen(tsi->tsi)/2;
    for (j = 0; j < tsi->yinnum; j++) {
      tsiyin->yinlen = len;
      tsiyin->yin = (Yin *)malloc(sizeof(Yin)*len);
      memcpy(tsiyin->yin, tsi->yindata+j*len, sizeof(Yin)*len);
      rval = ydb->Get(ydb, tsiyin);
      if (rval < 0) { /* no such tsiyin */
        tsiyin->tsinum = 1;
        tsiyin->tsidata = (ZhiStr)malloc(sizeof(unsigned char)*len*2);
        memcpy(tsiyin->tsidata, tsi->tsi, sizeof(unsigned char)*len*2);
        ydb->Put(ydb, tsiyin);
      }
      else {
        tsiyin->tsidata =
          (ZhiStr)realloc(tsiyin->tsidata,
                          sizeof(unsigned char)*((tsiyin->tsinum+1)*len*2));
        memcpy(tsiyin->tsidata+(tsiyin->tsinum*len*2), tsi->tsi,
               sizeof(unsigned char)*len*2);
        tsiyin->tsinum++;
        ydb->Put(ydb, tsiyin);
      }
    }
  }
}

int
main(argc, argv)
int argc;
char **argv;
{
  char ch;
  int ref;
  struct TsiDB *db;
  struct TsiYinDB *ydb;

  char *db_name, *op_name;

  db_name = op_name = (char *)NULL;
  ref = 0;

  while ((ch = getopt(argc, argv, "d:y:")) != -1) {
    switch(ch) {
      case 'd':
        db_name = strdup(optarg);
        break;
      case 'y':
        op_name = strdup(optarg);
        break;
      case 'r':
        ref = 1;
        break;
      default:
        usage();
        break;
    }
  }
  argc -= optind;
  argv += optind;

  if (!db_name) {
    usage();
  }

  db = tabeTsiDBOpen(DB_TYPE_DB, db_name, 0);
  if (!db) {
    usage();
  }

  if (!op_name) {
    usage();
  }

  ydb = tabeTsiYinDBOpen(DB_TYPE_DB, op_name,
                         DB_FLAG_CREATEDB | DB_FLAG_OVERWRITE);
  if (!ydb) {
    usage();
  }

  dump(db, ydb);

  db->Close(db);
  ydb->Close(ydb);

  return(0);
}
