/*
 * Copyright 1999, TaBE Project, All Rights Reserved.
 * Copyright 1999, Pai-Hsiang Hsiao, All Rights Reserved.
 *
 * $Id: tsidump.c,v 1.4 1999/05/13 09:50:31 shawn Exp $
 *
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include <tabe.h>

void
usage()
{
  printf("Usage: tsidump -d <TsiDB> [-f output file -ry]\n");
  printf("       -r	output includes reference count.\n");
  printf("       -y     output includes tsiyin.\n");
  exit(0);
}

void
dump(db, fp, ref, tsiyin)
struct TsiDB *db;
FILE *fp;
int ref, tsiyin;
{
  struct TsiInfo *tsi;
  int rval, i, j, k, len;

  rval = db->RecordNumber(db);
  if (rval < 0) {
    fprintf(stderr, "tsidump: wrong DB format.\n");
    usage();
  }

  tsi = (struct TsiInfo *)malloc(sizeof(struct TsiInfo));
  tsi->tsi = (ZhiStr)malloc(sizeof(unsigned char)*80);
  memset(tsi->tsi, 0, 80);
  tsi->refcount = -1;
  tsi->yinnum = -1;

  i = 0;
  while (1) {
    if (i == 0) {
      db->CursorSet(db, tsi);
    }
    else {
      rval = db->CursorNext(db, tsi);
      if (rval < 0) {
        break;
      }
    }
    i++;
    len = strlen(tsi->tsi)/2;
    fprintf(fp, "%s", tsi->tsi);
    if (ref) {
      fprintf(fp, " %ld", tsi->refcount);
    }
    if (tsiyin) {
      ZuYinSymbolSequence zs = NULL;
      int begin = 0;

      fprintf(fp, " ");
      for (j = 0; j < tsi->yinnum; j++) {
        for (k = 0; k < len; k++) {
          zs = tabeYinToZuYinSymbolSequence(tsi->yindata[j*len+k]);
          if (zs) {
            if (begin) {
              fprintf(fp, "@");
            }
            else {
              begin = 1;
            }
            fprintf(fp, "%s", zs);
            free(zs);
          }
        }
      }
    }
    fprintf(fp, "\n");
  }

  db->Close(db);
}

int
main(argc, argv)
int argc;
char **argv;
{
  char ch;
  int ref, tsiyin;
  FILE *fp;
  struct TsiDB *db;

  char *db_name, *op_name;

  db_name = op_name = (char *)NULL;
  ref = 0;
  tsiyin = 0;

  while ((ch = getopt(argc, argv, "d:f:ry")) != -1) {
    switch(ch) {
      case 'd':
        db_name = strdup(optarg);
        break;
      case 'f':
        op_name = strdup(optarg);
        break;
      case 'r':
        ref = 1;
        break;
      case 'y':
        tsiyin = 1;
        break;
      default:
        usage();
        break;
    }
  }
  argc -= optind;
  argv += optind;

  if (!db_name) {
    usage();
  }

  db = tabeTsiDBOpen(DB_TYPE_DB, db_name, 0);
  if (!db) {
    usage();
  }

  if (op_name) {
    fp = fopen(op_name, "w");
    dump(db, fp, ref, tsiyin);
    fclose(fp);
  }
  else {
    dump(db, stdout, ref, tsiyin);
  }

  return(0);
}
