/*
 * $Id: xim.h,v 1.3 1999/02/18 08:09:30 thhsieh Exp $
 */
/*
    Copyright (C) 1999 by  XCIN TEAM

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For any question or suggestion, please mail to xcin mailing-list:
    xcin@linux.org.tw, or the maintainer Tung-Han Hsieh: thhsieh@linux.org.tw
*/      


#ifndef _XCIN_XIM_H
#define _XCIN_XIM_H

#include <X11/Xlib.h>
#include <Ximd/IMdkit.h>
#include "IC.h"

#define DEFAULT_XIMNAME "xcin"
#define XIM_TCP_PORT 9010

enum trans_type {
    TRANSPORT_X, 
    TRANSPORT_LOCAL, 
    TRANSPORT_TCP
};

typedef struct {
    char *xim_name;
    XIMS ims;
    IC *ic;
    inp_state_t im_focus;
    unsigned int unset_focus_ret;
} xim_config_t;


extern void xim_init(void);
extern void xim_close(void);
extern void call_xim_init(IC *ic);
extern void call_xim_end(IC *ic);
extern void call_switch_in(IC *ic);
extern void call_switch_out(IC *ic);
extern int change_IM(IC *ic, int inp_num);

extern xim_config_t xim_conf;

#endif
