/*
 *  $Id: xcin_core.h,v 1.5 1999/02/18 08:09:27 thhsieh Exp $
 */
/*
    Copyright (C) 1999 by  XCIN TEAM

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For any question or suggestion, please mail to xcin mailing-list:
    xcin@linux.org.tw, or the maintainer Tung-Han Hsieh: thhsieh@linux.org.tw
*/      


#ifndef  _XCIN_H
#define  _XCIN_H

#include "constant.h"

/*
 *  Labels for rcfile keywords.
 */
#define RCKEY_XCIN_DEFAULT_DIR		"XCIN_DEFAULT_DIR"
#define RCKEY_XCIN_USER_DIR		"XCIN_USER_DIR"
#define RCKEY_FONTSET			"FONTSET"
#define RCKEY_INDEX_FONT		"INDEX_FONT"
#define RCKEY_FG_COLOR			"FG_COLOR"
#define RCKEY_BG_COLOR			"BG_COLOR"
#define RCKEY_M_FG_COLOR		"M_FG_COLOR"
#define RCKEY_M_BG_COLOR		"M_BG_COLOR"
#define RCKEY_XCIN_HIDE			"XCIN_HIDE"
#define RCKEY_X_GEOMETRY		"X_GEOMETRY"
#define RCKEY_XKILL_DISABLE		"XKILL_DISABLE"
#define RCKEY_IM_FOCUS_ON		"IM_FOCUS_ON"
#define RCKEY_DEFAULT_IM		"DEFAULT_IM"
#define RCKEY_DEFAULT_IM_MODULE		"DEFAULT_IM_MODULE"
#define RCKEY_DEFAULT_IM_SINMD		"DEFAULT_IM_SINMD"
#define RCKEY_PHRASE			"PHRASE"
#define RCKEY_CINPUT			"CINPUT"
#ifndef RCKEY_SETKEY
#   define RCKEY_SETKEY			"SETKEY"
#endif
#ifndef RCKEY_MODULE
#   define RCKEY_MODULE			"MODULE"
#endif
#ifndef RCKEY_LOCALE
#   define RCKEY_LOCALE			"LOCALE"
#endif

/*
 *  Flags for xcin_mode (for the global setting).
 */
#define XCIN_MODE_HIDE       	0x00000001	/* Hide xcin. */
#define XCIN_SHOW_CINPUT	0x00000002	/* sinmd is set to be default*/
#define XCIN_XKILL_OFF		0x00000004	/* disable xkill */
#define XCIN_IM_FOCUS		0x00000008	/* IM focus on */
#define XCIN_MODE_WORKING	0x00010000	/* xcin is working or not */
#define XCIN_RUN_IM_FOCUS	0x00020000	/* run time IM focus on */


typedef struct locale_s locale_t;
struct locale_s {
    char *lc_ctype;
    char *lc_messages;
};

typedef struct core_config_s core_config_t;
struct core_config_s {
    char *rcfile;		/* rcfile name. */
    char *default_dir;		/* Default module directory. */
    char *user_dir;		/* User data directory. */
    locale_t locale;		/* Locale name. */

    unsigned int xcin_mode;	/* Xcin modes. */
    char *default_im_name;	/* Default Cinput name. */
    char *default_im_mod_name;  /* Default CInput module name. */
    char *default_im_sinmd_name;/* Default Cinput name for show keystroke. */
    short default_im;		/* Index of default input method. */
    short default_im_sinmd;	/* Index of default show_cinput. */
    char *im_objname;		/* List of IM object names. */
    char *phrase_fn;		/* Phrase file name. */

    char *display_name;		/* X Display name. */
    char *fontset;		/* I18N fontset list */
    char *indexfont;		/* Index font name */
    char *fg_color, *bg_color, *mfg_color, *mbg_color;
    char *geometry;
    char *xim_name;

    char *inpn_english;
    char *inpn_sbyte;
    char *inpn_2bytes;
    char *inpn_zhhex;
};


extern core_config_t xcin_conf;

#endif
