/*
 * $Id: module.h,v 1.4 1999/02/18 08:09:26 thhsieh Exp $
 */
/*
    Copyright (C) 1999 by  XCIN TEAM

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For any question or suggestion, please mail to xcin mailing-list:
    xcin@linux.org.tw, or the maintainer Tung-Han Hsieh: thhsieh@linux.org.tw
*/      

#ifndef	_MODULE_H
#define	_MODULE_H

#include <X11/Xlib.h>
#include "constant.h"
#include "xcintool.h"
#include "xcin_core.h"


/*--------------------------------------------------------------------------

	IM and IC.

--------------------------------------------------------------------------*/

#ifndef True
#  define True  1
#  define False 0
#endif

/* Size of module ID in .tab file. */
#define MODULE_ID_SIZE		20

/* Returned value of keystroke() function. */
#define IMKEY_ABSORB    	0x0000
#define IMKEY_COMMIT    	0x0001
#define IMKEY_IGNORE    	0x0002
#define IMKEY_BELL      	0x0004
#define IMKEY_SHIFTESC  	0x0008

/* Represent Page State of multi-char selection. */
#define MCCH_ONEPG		0
#define MCCH_BEGIN		1
#define MCCH_MIDDLE		2
#define MCCH_END		3

/* Options to control the GUI mode. */
#define GUIMOD_SELKEYSPOT  	0x0001
#define GUIMOD_SINMDLINE1  	0x0002
#define GUIMOD_LISTCHAR    	0x0004


/*  Structer for IM in IC.  */
typedef struct {
    int icid;				/* ID of current Input Context */
    void *iccf;				/* Internal data of IM for each IC */

    char *inp_cname;			/* IM Chinese name */
    char *inp_ename;			/* IM English name */
    unsigned char area3_len;		/* Length of area 3 of window (n_char)*/
    unsigned short xcin_wlen;		/* xcin window length */
    unsigned short guimode;		/* GUI mode flag */

    unsigned char keystroke_len;	/* # chars of keystroke */
    wch_t *s_keystroke;			/* keystroke printed in area 3 */

    unsigned short n_selkey;		/* # of select keys */
    wch_t s_selkey[SELECT_KEY_LENGTH+2];/* the displayed select keys */
    unsigned short n_mcch;		/* # of chars with the same keystroke */
    wch_t mcch[SELECT_KEY_LENGTH];	/* multi-char list */
    char mcch_pgstate;			/* page state of multi-char */

    wch_t cch_publish;			/* A published cch. */
    unsigned short n_lcch;		/* # of composed cch list. */
    wch_t *lcch;			/* composed cch list. */
    unsigned short edit_pos;		/* editing position in lcch list. */
    char *cch;				/* the string for commit. */
} inpinfo_t;

typedef struct {
    int icid;				/* ID of current Input Context */
    unsigned short xcin_wlen;           /* xcin window length */
    unsigned short guimode;             /* GUI mode flag */
    wch_t cch_publish;                  /* A published cch. */
    wch_t *s_keystroke;			/* keystroke of cch_publish returned */
} simdinfo_t;

typedef struct {
    KeySym keysym;			/* X11 key code. */
    unsigned int keystate;		/* X11 key state/modifiers */
    char keystr[64];			/* X11 key name */
    int keystr_len;			/* key name length */
} keyinfo_t;


/*---------------------------------------------------------------------------

	General module definition

---------------------------------------------------------------------------*/

/*  Module type classification.  */
enum mtype {
    MOD_CINPUT
};

typedef struct module_s  module_t;
struct module_s {
    char *name;
    char *version;
    char *comments;
    char **valid_objname;
    enum mtype module_type;

    int conf_size;
    int (*init) (void *conf, char *objname, core_config_t *xc);
	/* called when IM first loaded & initialized. */
    int (*xim_init) (void *conf, inpinfo_t *inpinfo);
	/* called when trigger key occures to switch IM. */
    unsigned int (*xim_end) (void *conf, inpinfo_t *inpinfo);
	/* called just before xim_init() to leave IM, not necessary */
    int (*switch_in) (void *conf, inpinfo_t *inpinfo);
	/* called when set_focus_in, not necessary */
    int (*switch_out) (void *conf, inpinfo_t *inpinfo);
	/* called when set_focus_out, not necessary */
    unsigned int (*keystroke) (void *conf, inpinfo_t *inpinfo, keyinfo_t *keyinfo);
	/* called to input key code, and output chinese char. */
    int (*show_keystroke) (void *conf, simdinfo_t *simdinfo);
    	/* called to show the key stroke */
};


/*---------------------------------------------------------------------------

	IM Common Module.

---------------------------------------------------------------------------*/

/* For encoding check. */
typedef struct {
    short n;
    unsigned char begin[N_CCODE_RULE], end[N_CCODE_RULE];
} charcode_t;

typedef struct {
    unsigned int  total_char;
    unsigned char n_ch_encoding;
    charcode_t ccode[WCH_SIZE];
} ccode_info_t;

/* Key <-> Code convertion */
extern int key2code(int key);
extern int code2key(int code);
extern int keys2codes(unsigned int *klist, int klist_size, char *keystroke);
extern void codes2keys(unsigned int *klist, int n_klist, char *keystroke, int keystroke_len);

/* CharCode system */
extern void ccode_init(charcode_t *ccp, int n);
extern void ccode_info(ccode_info_t *info);
extern int match_encoding(wch_t *wch);
extern int ccode_to_idx(wch_t *wch);
extern int ccode_to_char(int idx, unsigned char *mbs, int mbs_size);

/* Wide char for ASCII */
extern void fullascii_init(wch_t *list);
extern char *fullchar_keystroke(inpinfo_t *inpinfo, KeySym keysym);
extern char *fullchar_ascii(inpinfo_t *inpinfo, int mode, keyinfo_t *keyinfo);
extern char *halfchar_ascii(inpinfo_t *inpinfo, int mode, keyinfo_t *keyinfo);

/* Quick key phrase: shift+alt+? */
extern void qphrase_init(void);
extern char *qphrase_str(int ch);


#endif
