/*
 * $Id: gui.h,v 1.5 1999/02/18 08:09:24 thhsieh Exp $
 */
/*
    Copyright (C) 1999 by  XCIN TEAM

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For any question or suggestion, please mail to xcin mailing-list:
    xcin@linux.org.tw, or the maintainer Tung-Han Hsieh: thhsieh@linux.org.tw
*/      


#ifndef _GUI_H
#define _GUI_H

#include <stdlib.h>
#include <X11/Xlib.h>
#include "module.h"

#define WIN_CHANGE_IM_CONTENT	0x01
#define WIN_RAISE		0x10
#define WIN_CHANGE_IM		0xff

typedef struct {
    int x, width;
} subw_conf_t;


typedef struct gui_config_s gui_config_t;
struct gui_config_s {
    Display *display;
    int      screen;
    int      display_width, display_height;
    Window   root, window;
    Atom     wm_del_win;

    Colormap colormap;
    unsigned long fg_color, bg_color, mfg_color, mbg_color;
    GC gc, gce, gcm, gcrm;

    int pos_x, pos_y;          
    unsigned int width, height, border;
    unsigned int c_width, c_height;

    XFontSet fontset;
    XFontStruct *indexfont;
    int ef_width, ef_height, ef_ascent, if_descent;

    unsigned char winchange;
    subw_conf_t inpname, coding, show_coding, e_inpname;
};


void gui_init(int argc, char **argv);
void win_draw_map(void);
void gui_loop(void);

extern gui_config_t gui_conf;

#endif
