/*
    Copyright (C) 1999 by  XCIN TEAM

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For any question or suggestion, please mail to xcin mailing-list:
    xcin@linux.org.tw, or the maintainer Tung-Han Hsieh: thhsieh@linux.org.tw
*/      

#include <string.h>
#include <ctype.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include "imodule.h"


typedef struct xkeymap_s {
    KeySym xkey;
    wch_t wch;
} xkeymap_t; 

static xkeymap_t fullchar[] = {		/* sorted by ascii code */
	{XK_space,		0x0},	/*     */
	{XK_exclam,		0x0},	/*  !  */
	{XK_quotedbl,		0x0},	/*  "  */
	{XK_numbersign,		0x0},	/*  #  */
	{XK_dollar,		0x0},	/*  $  */
	{XK_percent,		0x0},	/*  %  */
	{XK_ampersand,		0x0},	/*  &  */
	{XK_apostrophe,		0x0},	/*  '  */
	{XK_parenleft,		0x0},	/*  (  */
	{XK_parenright,		0x0},	/*  )  */
	{XK_asterisk,		0x0},	/*  *  */
	{XK_plus,		0x0},	/*  +  */
	{XK_comma,		0x0},	/*  ,  */
	{XK_minus,		0x0},	/*  -  */
	{XK_period,		0x0},	/*  .  */
	{XK_slash,		0x0},	/*  /  (undefined) */
	{XK_0,			0x0},	/*  0  */
	{XK_1,			0x0},	/*  1  */
	{XK_2,			0x0},	/*  2  */
	{XK_3,			0x0},	/*  3  */
	{XK_4,			0x0},	/*  4  */
	{XK_5,			0x0},	/*  5  */
	{XK_6,			0x0},	/*  6  */
	{XK_7,			0x0},	/*  7  */
	{XK_8,			0x0},	/*  8  */
	{XK_9,			0x0},	/*  9  */
	{XK_colon,		0x0},	/*  :  */
	{XK_semicolon,		0x0},	/*  ;  */
	{XK_less,		0x0},	/*  <  */
	{XK_equal,		0x0},	/*  =  */
	{XK_greater,		0x0},	/*  >  */
	{XK_question,		0x0},	/*  ?  */
	{XK_at,			0x0},	/*  @  */
	{XK_A,			0x0},	/*  A  */
	{XK_B,			0x0},	/*  B  */
	{XK_C,			0x0},	/*  C  */
	{XK_D,			0x0},	/*  D  */
	{XK_E,			0x0},	/*  E  */
	{XK_F,			0x0},	/*  F  */
	{XK_G,			0x0},	/*  G  */
	{XK_H,			0x0},	/*  H  */
	{XK_I,			0x0},	/*  I  */
	{XK_J,			0x0},	/*  J  */
	{XK_K,			0x0},	/*  K  */
	{XK_L,			0x0},	/*  L  */
	{XK_M,			0x0},	/*  M  */
	{XK_N,			0x0},	/*  N  */
	{XK_O,			0x0},	/*  O  */
	{XK_P,			0x0},	/*  P  */
	{XK_Q,			0x0},	/*  Q  */
	{XK_R,			0x0},	/*  R  */
	{XK_S,			0x0},	/*  S  */
	{XK_T,			0x0},	/*  T  */
	{XK_U,			0x0},	/*  U  */
	{XK_V,			0x0},	/*  V  */
	{XK_W,			0x0},	/*  W  */
	{XK_X,			0x0},	/*  X  */
	{XK_Y,			0x0},	/*  Y  */
	{XK_Z,			0x0},	/*  Z  */
	{XK_bracketleft,	0x0},	/*  [  */
	{XK_backslash,		0x0},	/*  \  (undefined) */
	{XK_bracketright,	0x0},	/*  ]  */
	{XK_asciicircum,	0x0},	/*  ^  */
	{XK_underscore,		0x0},	/*  _  (undefined) */
	{XK_grave,		0x0},	/*  `  */
	{XK_a,			0x0},	/*  a  */
	{XK_b,			0x0},	/*  b  */
	{XK_c,			0x0},	/*  c  */
	{XK_d,			0x0},	/*  d  */
	{XK_e,			0x0},	/*  e  */
	{XK_f,			0x0},	/*  f  */
	{XK_g,			0x0},	/*  g  */
	{XK_h,			0x0},	/*  h  */
	{XK_i,			0x0},	/*  i  */
	{XK_j,			0x0},	/*  j  */
	{XK_k,			0x0},	/*  k  */
	{XK_l,			0x0},	/*  l  */
	{XK_m,			0x0},	/*  m  */
	{XK_n,			0x0},	/*  n  */
	{XK_o,			0x0},	/*  o  */
	{XK_p,			0x0},	/*  p  */
	{XK_q,			0x0},	/*  q  */
	{XK_r,			0x0},	/*  r  */
	{XK_s,			0x0},	/*  s  */
	{XK_t,			0x0},	/*  t  */
	{XK_u,			0x0},	/*  u  */
	{XK_v,			0x0},	/*  v  */
	{XK_w,			0x0},	/*  w  */
	{XK_x,			0x0},	/*  x  */
	{XK_y,			0x0},	/*  y  */
	{XK_z,			0x0},	/*  z  */
	{XK_braceleft,		0x0},	/*  {  */
	{XK_bar,		0x0},	/*  |  */
	{XK_braceright,		0x0},	/*  }  */
	{XK_asciitilde,		0x0},	/*  ~  */
	{0L,			0x0}
};

static char cch[WCH_SIZE+1];

void
fullascii_init(wch_t *list)
{
    xkeymap_t *fc=fullchar;
    int i=0;

    for (; fc->xkey; fc++)
	fc->wch.wch = list[i++].wch;
}

char *
fullchar_keystroke(inpinfo_t *inpinfo, KeySym keysym)
{
    xkeymap_t *fc=fullchar;

    while (fc->xkey != 0) {
	if (keysym == fc->xkey) {
	    strncpy(cch, fc->wch.s, WCH_SIZE);
	    cch[WCH_SIZE] = '\0';
	    return cch;
	}
	fc ++;
    }
    return NULL;
}

char *
fullchar_ascii(inpinfo_t *inpinfo, int mode, keyinfo_t *keyinfo)
{
    int i;

    if (keyinfo->keystr_len != 1)
	return fullchar_keystroke(inpinfo, keyinfo->keysym);

    if ((i = (int)(keyinfo->keystr[0]-' ')) >= 95 || i < 0)
	return NULL;

    if (mode) {
	if ((keyinfo->keystate & LockMask))
	    i = toupper(keyinfo->keystr[0]) - ' ';
	else
	    i = tolower(keyinfo->keystr[0]) - ' ';
    }
    strncpy(cch, fullchar[i].wch.s, WCH_SIZE);
    cch[WCH_SIZE] = '\0';
    return cch;
}

char *
halfchar_ascii(inpinfo_t *inpinfo, int mode, keyinfo_t *keyinfo)
{
    int i;

    if (keyinfo->keystr_len != 1)
	return NULL;

    if ((i = (int)(keyinfo->keystr[0]-' ')) >= 95 || i < 0)
	return NULL;

    if (mode) {
	if ((keyinfo->keystate & LockMask))
	    i = toupper(keyinfo->keystr[0]);
	else
	    i = tolower(keyinfo->keystr[0]);

        cch[0] = (char)i;
        cch[1] = '\0';
        return cch;
    }
    else
	return NULL;
}
