/*
    Copyright (C) 1999 by  XCIN TEAM

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For any question or suggestion, please mail to xcin mailing-list:
    xcin@linux.org.tw, or the maintainer Tung-Han Hsieh: thhsieh@linux.org.tw
*/      

#ifndef _PHONE_H
#define _PHONE_H

#define N_KEYMAPS		3

#define PHONE_MODE_COMPOSEDOK	0x0001		/* bims has composed a char */

typedef struct phone_conf_s {
    char *inp_cname;            /* IM Chinese name */
    char *inp_ename;            /* IM English name */
    char setkey;                /* Set key number (for switch to this IM) */
    unsigned int mode;          /* IM mode flag */

    char *tsi_fname;		/* tsi db file name */
    char *yin_fname;		/* yin db file name */

    char keymap;		/* 0: zozy, 1: eten, 2: hsu */
} phone_conf_t;


typedef struct phone_iccf_s {
    unsigned short lcch_size;    	/* Buffer size of lcch list. */
    unsigned short lcch_max_len;	/* Allowed max length of lcch list. */
    unsigned short mode;
} phone_iccf_t;

#endif
