/*
	Copyright (C) 1994	Edward Der-Hua Liu, Hsin-Chu, Taiwan
*/

#include <X11/Xlib.h>
#include <stdio.h>
#include "xi.h"

static u_char *bf=0;
/*static int bfsize=0;*/

static struct keystruc {
	KeySym	ksym;
	int stridx;
} ktab[128]; 
static int ktabcount=0;
extern Display *display; 
extern Atom xcin_atom;
extern void bzero(void *s, int n);

void set_ktab()
{
KeySym /**ksymp,*/ ksym;
int ofs,idx;

bzero(ktab,sizeof(ktab));
for(idx=0,ktabcount=0,ofs=0;;) {
memcpy(&ksym, &bf[ofs], sizeof(KeySym));
ofs+=sizeof(KeySym);
/* printf("%d ksym:%x\n", ksym); */
if (!ksym) break;
ktab[ktabcount].ksym=ksym;
ktab[ktabcount].stridx=ofs;
while (bf[ofs]) ofs++;
ofs++;
ktabcount++;
} /* for */
}

char *phrfname=0;
extern char *strcat(char *dest, const char *src);
extern void *malloc(size_t size);


void init_phrase()
{
extern char TabDir[];
char fname[80];
FILE *fp;
int size;

if (phrfname) {
	strcpy(fname,phrfname);
} else {
	strcpy(fname,TabDir);
	strcat(fname,"sample.phs.out");
}
if ((fp=fopen(fname,"r"))==NULL) {
	error("%s", fname);
	return;
}
fread(&size,4,1,fp);
if ((bf=(u_char *)malloc(size))==NULL) {
	error("malloc");
	return;
}
fread(bf,1,size,fp);
fclose(fp);
set_ktab();
}

extern void free(void *ptr);

void load_phrase(Window cli_win, u_long bytes_after)
{
/*int slen, idx;*/
long ofs;
/*int *len;*/
Atom actual_type;
int actual_format;
u_long nitems;
u_char *ttt;
 
if (bf) free(bf);
if ((bf=(char *)malloc(bytes_after))==NULL) {
	error("phrase.c: 1");
	return;
}

ofs=4;
do {
if (XGetWindowProperty(display,cli_win,xcin_atom,ofs/4, (bytes_after+3)/4,
	True, AnyPropertyType, &actual_type,&actual_format,
       &nitems,&bytes_after,&ttt) != Success)
		error("phrase.c: 2");
	memcpy(bf-4+(ofs&(~0x3)), ttt, nitems);
	XFree(ttt);
	ofs=(ofs & (~0x3)) + nitems;
} while (bytes_after>0);

set_ktab();

}

extern void putstr(u_char *s);

int lookup_key(KeySym ksym)
{
int i;
for(i=0;i<ktabcount;i++)
if (ktab[i].ksym==ksym) {
	putstr(&bf[ktab[i].stridx]);
	return 1;
}
return 1;
}
