#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

FILE *fin, *fout;
char  fn_input[256];


FILE *OpenTIT(char *fn, char *fn_input)
{
    FILE *f;
    char *s=NULL, fnn[256];
    char  str[80], keystr[80];

    strcpy(fnn, fn);
    if((s=strrchr(fnn, '.')) == NULL) {
	strcpy(fn_input, fnn);
	strcat(fnn, ".tit");
    }
    else {
	strcpy(fn_input, fnn);
	fn_input[(int)(s-fnn)] = '\0';
    }

    if((f=fopen(fnn, "rt")) == NULL) {
	fprintf(stderr, "Cannot open file: %s.\n", fnn);
	exit(1);
    }

    sprintf(keystr, "# $Id: %s", fnn);
    fgets(str, 80, f);
    if( strncmp(keystr, str, strlen(keystr)) ) {
	fprintf(stderr, 
		"Error: The input file %s is not TIT format of CXTERM.\n",
		fnn);
	exit(1);
    }
    return  f;
}

FILE *OpenCIN(char *fn)
{
    char  fcin[256];
    FILE *f;

    strcpy(fcin, fn);
    strcat(fcin, ".cin");
    if((f=fopen(fcin, "wt")) == NULL) {
	fprintf(stderr, "Cannot open file: %s.\n", fcin);
	exit(1);
    }
    return  f;
}


/*--------------------------------------------------------------------------*/

void search_prompt(void)
{
    char  str[80], *s, prompt[80];
    int   c;

    prompt[0] = '\0';

    while(fgets(str, 80, fin) != NULL) {
	if(! strncmp("PROMPT:", str, 7)) {
	    s = strchr(str+7, ':');
	    s += 2;
	    strcpy(prompt, s);
	    s = strchr(prompt, ':');
	    *s = '\0';
	    if(strlen(prompt) <= 4)
	        fprintf(fout, "%%prompt i%sj\n", prompt);
	    else
	        fprintf(fout, "%%prompt [%s]\n", prompt);

	    break;
	}
	else if((s=strrchr(str, '\n')) == NULL)
	    while((c=fgetc(fin)) != '\0' && c != '\n');
    }
    if(prompt[0] == '\0') {
	fprintf(stderr, "Error: Prompt field not found.\n");
	exit(1);
    }
}

void search_selkey(char *buf)
{
    char  str[80], *s, select[20], *sel=select;
    char  select_start=0;
    int   select_num=0, c;

    while(fgets(str, 80, fin) != NULL) {
        if(! strncmp("SELECTKEY:", str, 10)) {
	    select_start = 1;
	    select_num ++;

	    s = str + 10;
	    while( isspace(*s) )    s++;
	    if(select_num < 20) {
	        *sel = *s;
		sel ++;
	    }
        }
        else if(select_start == 0) {
	    if((s=strrchr(str, '\n')) == NULL)
                while((c=fgetc(fin)) != '\0' && c != '\n');
	}
	else
	    break;
    }
    *sel = '\0';

    if(select[0] == '\0') {
	fprintf(stderr, "Error: Select Key field not found.\n");
	exit(1);
    }

    fprintf(fout, "%%selkey %s\n", select);
    fprintf(fout, "%%dupsel %d\n", select_num);
    strcpy(buf, str);
}

void search_keyname(char *buf)
{
    char  str[80], *s, c, key=0, keych[5];
    char  keyname_start=0;
    char *keyEn = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890,./;\'`=\\";

    fprintf(fout, "%%keyname begin\n");
    
    strncpy(str, buf, 80);
    do {
        if(! strncmp("KEYPROMPT(", str, 10)) {
	    keyname_start = 1;

	    s = str + 10;
	    key = *s;
	    s += 3;
	    while( isspace(*s) )    s++;
	    strncpy(keych, s, 2);
	    fprintf(fout, "%c %s\n", key, keych);
	}
        else if(keyname_start == 0) {
	    if((s=strrchr(str, '\n')) == NULL)
                while((c=fgetc(fin)) != '\0' && c != '\n');
	}
	else
	    break;

    } while(fgets(str, 80, fin) != NULL);

    if(key == 0) {
	s = keyEn;
	while(*s != '\0') {
	    fprintf(fout, "%c %c\n", *s, *s);
	    s++;
	}
    }
    fprintf(fout, "%%keyname end\n");

    fclose(fin);
    fin = OpenTIT(fn_input, fn_input);
}

void search_keycode()
{
    char  str[80], *s, keycode[20], *key, ch[5];

    while(fgets(str, 80, fin) != NULL) {
        if(! strncmp("BEGINDICTIONARY", str, 15))
	    break;
    }
    while(fgets(str, 80, fin) != NULL && str[0]=='#');
    
    do {
	s = str;
	key = keycode;
	while(! isspace(*s)) {
	    *key = *s;
	    key++;
	    s++;
	}
	*key = '\0';

	while( isspace(*s) )	s++;

	while(*s != '\0' && *s != '\n') {
	    ch[0] = *s;
	    s ++;
	    ch[1] = *s;
	    s ++;
	    fprintf(fout, "%s\t%c%c\n", keycode, ch[0], ch[1]);
	}

    } while(fgets(str, 80, fin) != NULL);
}


main(int argc, char **argv)
{
    char buf[256];

    if(argc == 0) {
	fprintf(stderr, 
"tit2cin: Simple Input Method Table Converter from TIT (CXTERM) to CIN (XCIN).\n"
"Usage: tit2cin <fname.tit>\n");
	exit(0);
    }

    fin = OpenTIT(argv[1], fn_input);
    fout= OpenCIN(fn_input);

    fprintf(fout, "# This is generated from %s.tit by tit2cin.\n", fn_input);
    fprintf(fout, "# Please modify it for your suit.\n#\n");
    fprintf(fout, "%%ename %s\n", fn_input);

    search_prompt();
    search_selkey(buf);
    search_keyname(buf);

    fprintf(fout, "%%quick begin\n");
    fprintf(fout, "%%quick end\n");
    fprintf(fout, "%%sel1st begin\n");
    fprintf(fout, "%%sel1st end\n");

    search_keycode();

    fclose(fout);
    fclose(fin);
}
