/***************************************************************************
                             rmcache.h
                             -------------------
    begin                : May 2001
    copyright            : (C) 2001 by Jorge Allyson Azevedo
                                       Milena Scanferla
                                       Magnos Martinello
                                       Daniel Sadoc
    email                : {allyson,milena,magnos,sadoc}@land.ufrj.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RMCACHE_H

#define RMCACHE_H

#include "rmstruct.h"

#define MEMBER_CACHE_SIZE 4000

void cacheInit(CACHE **cache);

int cacheAllocHeaderNode(CACHE **cache, MEMBER_ID *member);
int cacheAllocMessageNode(CACHE_NODE **cache_node, DATA_PACKET *node_info);

int cacheFreeMessageNode(CACHE_NODE **node);

int cacheInsertMessage(CACHE **cache, MEMBER_ID *member, DATA_PACKET *data_packet);
CACHE *cacheInsertMember(CACHE **cache, MEMBER_ID *member);

int cacheIsEmpty(CACHE **cache);

int cacheOfAnyMemberIsFull(CACHE *cache);

int memberIsEqual(MEMBER_ID *member1, MEMBER_ID *member2);

CACHE *cacheLookForMember(CACHE **cache, MEMBER_ID *member_id);

DATA_PACKET *cacheLookForMessage(CACHE **cache1, MEMBER_ID *member_id,int message_sn);      

int cacheDesactivateMember(CACHE *cache, MEMBER_ID *member);


void cacheGetSMInfo(CACHE *cache, SM_INFO **sm_info, int *nusers);

void cacheShow(CACHE *cache);

int cacheUpdateNakList(CACHE **cache, MEMBER_ID *member, int sn);

#ifdef DONT_SEND_NAK_AGAIN_IMMEDIATLY
void cacheUpdateNakListNakWasReceived(CACHE **cache1, MEMBER_ID *member, int sn);
#endif

#endif
