/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-1998, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /u/halfmoon/home/william/src/tgif/v3/RCS/version.c,v 3.27 1998/11/05 23:46:08 william Exp $
 */

#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#include "const.h"
#include "patchlvl.h"

#ifndef _NO_EXTERN
#include "version.e"
#endif

char *versionString="3.0";
char *authorEmailString="bill.cheng@acm.org";
char *copyrightString="Copyright (C) 1990-1998, William Chia-Wei Cheng";
char *homePageURL="http://bourbon.cs.umd.edu:8001/tgif/";
char *mailingList="kragen-tgif@gentle.dyn.ml.org";
char *joinMailingList="kragen-tgif-subscribe@gentle.dyn.ml.org";
char *currentReleaseURL="http://bourbon.cs.umd.edu:8001/tgif/current.html";
char *hyperGraphicsURL="http://bourbon.cs.umd.edu:8001/tgif/index.obj";

char fullVersionString[MAXSTRING];
char fullToolName[MAXSTRING];
char *specialBuild="";

void SetFullVersionString()
{
   if (TGIF_PATCHLEVEL == 0) {
      if (*specialBuild == '\0') {
         sprintf(fullVersionString, "%s", versionString);
      } else {
         sprintf(fullVersionString, "%s-%s", versionString, specialBuild);
      }
   } else {
      if (*specialBuild == '\0') {
         sprintf(fullVersionString, "%s.%1d", versionString, TGIF_PATCHLEVEL);
      } else {
         sprintf(fullVersionString, "%s.%1d-%s", versionString,
               TGIF_PATCHLEVEL, specialBuild);
      }
   }
   sprintf(fullToolName, "%s-%s", TOOL_NAME, fullVersionString);
}

