/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-1998, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /u/halfmoon/home/william/src/tgif/v3/RCS/help.c,v 3.28 1998/11/05 23:46:11 william Exp $
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "const.h"
#include "types.h"
#include "patchlvl.h"

#include "color.e"
#include "dialog.e"
#include "file.e"
#ifndef _NO_EXTERN
#include "help.e"
#endif
#include "menu.e"
#include "msg.e"
#include "navigate.e"
#include "remote.e"
#include "setup.e"
#include "util.e"
#include "version.e"

#define HELP_ABOUT 0
#define HELP_COPYRIGHT 1
#define HELP_CURRENT 2

#define MAXHELPS 3

int numHelp=MAXHELPS;

char *helpMenuStr[] = {
      "About             ",
      "Copyright         ",
      "LatestReleaseInfo ",
      NULL
};
static char *helpMenuDesc[] = {
      "Version information, where to send bug reports, etc.",
      "Copyright information",
      "Find out what is the version number of the most recently released tgif",
      NULL
};

/* ----------------------- About ----------------------- */

void About()
{
   char *c_ptr=gszMsgBox;

   if (TGIF_PATCHLEVEL == 0) {
      if (*specialBuild == '\0') {
         sprintf(c_ptr, "%s Version %s", TOOL_NAME, versionString);
      } else {
         sprintf(c_ptr, "%s Version %s (%s)", TOOL_NAME, versionString,
               specialBuild);
      }
   } else {
      if (*specialBuild == '\0') {
         sprintf(c_ptr, "%s Version %s (patchlevel %1d)", TOOL_NAME,
               versionString, TGIF_PATCHLEVEL);
      } else {
         sprintf(c_ptr, "%s Version %s (patchlevel %1d - %s)", TOOL_NAME,
               versionString, TGIF_PATCHLEVEL, specialBuild);
      }
   }
   c_ptr = (&c_ptr[strlen(c_ptr)]);
   sprintf(c_ptr, "\n\n%s", copyrightString);
   c_ptr = (&c_ptr[strlen(c_ptr)]);
   sprintf(c_ptr, "\n\nWWW Hypertext Home Page: %s", homePageURL);
   c_ptr = (&c_ptr[strlen(c_ptr)]);
   sprintf(c_ptr, "\n\nLatest Release Information: %s", currentReleaseURL);
   c_ptr = (&c_ptr[strlen(c_ptr)]);
   sprintf(c_ptr, "\n\nWWW Hyper-Graphics Home Page: %s", hyperGraphicsURL);
   c_ptr = (&c_ptr[strlen(c_ptr)]);
   sprintf(c_ptr, "\n\n%s %s.  %s %s.",
         "There is a tgif mailing maintained by Kragen at", mailingList,
         "To join, please send an empty message to", joinMailingList);
   c_ptr = (&c_ptr[strlen(c_ptr)]);
   sprintf(c_ptr, "\n\nPlease send bug reports to %s.", "bill.cheng@acm.org");
   c_ptr = (&c_ptr[strlen(c_ptr)]);
   MsgBox(gszMsgBox, TOOL_NAME, INFO_MB);

}

/* ----------------------- Copyright ----------------------- */

static char *gszCopyright[] = {
   "",
   "William Cheng (\"Author\") grants to the party hereby receiving \"tgif\"",
   "(\"Recipient\") a non-exclusive, royalty-free license limited to copy,",
   "display, and distribute without charging for a fee, and produce derivative",
   "works of \"tgif\", provided that the above copyright notice appears in",
   "all copies made of \"tgif\" and both the copyright notice and this license",
   "appear in supporting documentation, and that the name of Author not be",
   "used in advertising or publicity pertaining to \"tgif\".  All other rights",
   "(including, but not limited to, the right to sell \"tgif\", the right to",
   "sell or distribute derivative",
   "works of \"tgif\", the right to distribute \"tgif\" for a fee, and",
   "the right to include \"tgif\" or derivative workds of \"tgif\" in a",
   "for-sale product) are reserved by the Author.",
   "",
   "\"Tgif\" is provided \"as is\" without express or implied warranty. Author",
   "does not and cannot warrant the performance of \"tgif\" or the results",
   "that may be obtained by its use or its fitness for any specific use by",
   "Recipient or any third party.  In no event shall Author become liable",
   "to Recipient or any other party, for any loss or damages,",
   "consequential or otherwise, including but not limited to time, money,",
   "or goodwill, arising from use or possession, authorized or not, of",
   "\"tgif\" by Recipient or any other party.",
   NULL
};

void Copyright()
{
   char **s_ptr=gszCopyright, *c_ptr=gszMsgBox;

   sprintf(c_ptr, "%s ", copyrightString);
   c_ptr = (&gszMsgBox[strlen(c_ptr)]);
   for ( ; *s_ptr != NULL; s_ptr++) {
      if (**s_ptr == '\0') {
         strcpy(c_ptr, "\n\n");
      } else {
         sprintf(c_ptr, "%s ", *s_ptr);
      }
      c_ptr = (&c_ptr[strlen(c_ptr)]);
   }
   MsgBox(gszMsgBox, TOOL_NAME, INFO_MB);
}

void LatestReleaseInfo()
{
   char tmp_fname[MAXPATHLENGTH+1], final_url[MAXPATHLENGTH+1];
   char current_url[MAXPATHLENGTH<<1];
   char *content_type=NULL, *page_spec=NULL;
   int is_html=FALSE, rc=FALSE;

   *final_url = '\0';
   strcpy(current_url, currentReleaseURL);
   navigateRefresh = TRUE;
   rc = DownloadRemoteFile(current_url, &content_type, &page_spec,
         &is_html, tmp_fname, final_url, sizeof(final_url));  
   navigateRefresh = FALSE;
   if (content_type != NULL) FreeRemoteBuf(content_type);
   if (page_spec != NULL) UtilFree(page_spec);
   if (rc) {
      FILE *fp=fopen(tmp_fname, "r");
      char version_str[MAXPATHLENGTH<<1];

      *version_str = '\0';
      if (fp == NULL) {
         sprintf(gszMsgBox, "%s '%s' %s.\n\n%s %s %s.",
               "Fail to open", currentReleaseURL, "for reading",
               "Please view", currentReleaseURL, "with a web browser");
         MsgBox(gszMsgBox, TOOL_NAME, INFO_MB);
      } else {
         int len=strlen("The current release of tgif is"), scanning=TRUE;
         char *buf;

         while (scanning && (buf=UtilGetALine(fp)) != NULL) {
            if (strncmp(buf, "The current release of tgif is", len) == 0) {
               char *buf1=UtilGetALine(fp);

               scanning = FALSE;
               if (buf1 != NULL) {
                  char *version_ptr=strstr(buf1, "Version"), *c_ptr=NULL;

                  if (version_ptr != NULL &&
                        (c_ptr=strchr(version_ptr, '<')) != NULL) {
                     *c_ptr = '\0';
                     strcpy(version_str, version_ptr);
                     *c_ptr = '<';
                  }
                  UtilFree(buf1);
               }
            }
            UtilFree(buf);
         }
         fclose(fp);

         if (*version_str == '\0') {
            sprintf(gszMsgBox, "%s '%s'.\n\n%s %s %s.",
                  "Fail to find version information in", currentReleaseURL,
                  "Please view", currentReleaseURL, "with a web browser");
         } else if (TGIF_PATCHLEVEL == 0) {
            if (*specialBuild == '\0') {
               sprintf(gszMsgBox, "%s %s %s %s %s %s %s.\n\n%s %s %s.",
                     TOOL_NAME, "is currently at", version_str,
                     "and this", TOOL_NAME, "is Version", versionString,
                     "For download information, please visit",
                     (*final_url=='\0' ? currentReleaseURL : final_url),
                     "with a web browser");
            } else {
               sprintf(gszMsgBox, "%s %s %s %s %s %s %s (%s).\n\n%s %s %s.",
                     TOOL_NAME, "is currently at", version_str,
                     "and this", TOOL_NAME, "is Version", versionString,
                     specialBuild, "For download information, please visit",
                     (*final_url=='\0' ? currentReleaseURL : final_url),
                     "with a web browser");
            }
         } else {
            if (*specialBuild == '\0') {
               sprintf(gszMsgBox,
                     "%s %s %s %s %s %s %s %s %1d.\n\n%s %s %s.",
                     TOOL_NAME, "is currently at", version_str,
                     "and this", TOOL_NAME, "is Version", versionString,
                     "Patchlevel", TGIF_PATCHLEVEL,
                     "For download information, please visit",
                     (*final_url=='\0' ? currentReleaseURL : final_url),
                     "with a web browser");
            } else {
               sprintf(gszMsgBox,
                     "%s %s %s %s %s %s %s %s %1d (%s).\n\n%s %s %s.",
                     TOOL_NAME, "is currently at", version_str,
                     "and this", TOOL_NAME, "is Version", versionString,
                     "Patchlevel", TGIF_PATCHLEVEL, specialBuild,
                     "For download information, please visit",
                     (*final_url=='\0' ? currentReleaseURL : final_url),
                     "with a web browser");
            }
         }
         MsgBox(gszMsgBox, TOOL_NAME, INFO_MB);
      }
   } else {
      sprintf(gszMsgBox, "%s '%s' %s.\n\n%s %s %s.",
            "Cannot download", currentReleaseURL, "to get version information",
            "Please view", currentReleaseURL, "with a web browser");
      MsgBox(gszMsgBox, TOOL_NAME, INFO_MB);
   }
   if (*tmp_fname != '\0') unlink(tmp_fname);
}

/* ----------------------- Init and Clean Up ----------------------- */

void CleanUpHelp()
{
}

void InitHelp()
{
}

/* ----------------------- Menu Functions ----------------------- */

void HelpSubMenu(nIndex)
   int nIndex;
{
   switch (nIndex) {
   case HELP_ABOUT: About(); break;
   case HELP_COPYRIGHT: Copyright(); break;
   case HELP_CURRENT: LatestReleaseInfo(); break;
   }
}

int HelpMenu(X, Y, TrackMenubar)
   int X, Y, TrackMenubar;
{
   int index, *fore_colors, *valid, *init_rv;

   DefaultColorArrays(MAXHELPS, &fore_colors, &valid, &init_rv, NULL);

   activeMenu = MENU_HELP;
   index = TextMenuLoop(X, Y, helpMenuStr, MAXHELPS, fore_colors,
         valid, init_rv, helpMenuDesc, SINGLECOLOR, TrackMenubar);

   if (index >= 0) HelpSubMenu(index);
   return index;
}
