/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 * Original draft:	Kou1 Ma2da (matsuda@ccs.mt.nec.co.jp)
 *
 * Copyright (C) 1990-1994, William Cheng.
 *
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights (including the right to sell "tgif" and the right to sell derivative
 * works of tgif) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /amnt/maui/tangram/u/william/X11/TGIF2/RCS/copypaste.c,v 2.52 1994/03/21 04:53:52 william Exp $";
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "auxtext.e"
#include "box.e"
#include "choice.e"
#include "cmd.e"
#include "color.e"
#ifndef _NO_EXTERN
#include "copypaste.e"
#endif
#include "cursor.e"
#include "dialog.e"
#include "drawing.e"
#include "dup.e"
#include "file.e"
#include "font.e"
#include "grid.e"
#include "mark.e"
#include "move.e"
#include "msg.e"
#include "names.e"
#include "obj.e"
#include "page.e"
#include "pattern.e"
#include "select.e"
#include "setup.e"
#include "special.e"
#include "text.e"

#define TGIF_HEADER 0x80

extern char	* mktemp ARGS_DECL((char *Template));
#ifndef _NO_EXTERN
extern int	write ARGS_DECL((int fd, char *buf, int nbyte));
extern int	unlink ARGS_DECL((char *));
extern int	read ARGS_DECL((int fd, char *buf, int nbyte));
#endif

int	copyingToCutBuffer = FALSE;
int	pastingFile = FALSE;

static char * cutBuffer = NULL;

int CopyToCutBuffer ()
   /* returns FALSE if copying in text mode -- this is */
   /*	interpreted as an attempt to copy highlighted text */
{
   FILE				* fp;
   register struct SelRec 	* sel_ptr;
   struct ObjRec		* obj_ptr, * top_obj, * bot_obj;
   char 			tmpfile[MAXSTRING], msg[MAXSTRING];
   struct stat 			stat;
   unsigned char 		header = TGIF_HEADER;
    
   if (curChoice == DRAWTEXT)
   {
      XEvent	ev;

      copyInDrawTextMode = TRUE;
      ev.type = KeyPress;
      DrawText (&ev);
      return (FALSE);
   }
   if (topSel == NULL)
   {
      Msg ("No object selected for the COPY operation.");
      return (TRUE);
   }
   sprintf (tmpfile, "%sTgifXXXXXX", TMP_DIR);
   mktemp (tmpfile);
   if ((fp = fopen (tmpfile, "w+")) == NULL)
   {
      sprintf (msg, "Can not open %s.", tmpfile);
      Msg (msg);
      return (TRUE);
   }
   writeFileFailed = FALSE;
   if (write (fileno(fp), &header, 1) < 1) writeFileFailed = TRUE;

   top_obj = bot_obj = NULL;
   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      obj_ptr = DupObj (sel_ptr->obj);

      obj_ptr->prev = NULL;
      obj_ptr->next = top_obj;

      if (top_obj == NULL)
         bot_obj = obj_ptr;
      else
         top_obj->prev = obj_ptr;
      top_obj = obj_ptr;
   }
   Save (fp, bot_obj, 0, 1);
   if (writeFileFailed)
   {
      sprintf (msg, "Fail to write to '%s'.  File system may be full.",
            tmpfile);
      Dialog (msg, NULL, NULL);
      fclose (fp);
      unlink (tmpfile);
      writeFileFailed = FALSE;
      return (TRUE);
   }

   fflush (fp);
   if (fstat (fileno(fp), &stat) < 0)
   {
      fclose (fp);
      unlink (tmpfile);
      sprintf (msg, "FSTAT error in %s.  Copy aborted!", tmpfile);
      Msg (msg);
      return (TRUE);
   }

   if (cutBuffer != NULL) cfree (cutBuffer);
   cutBuffer = (char *) calloc (stat.st_size+1, sizeof(char));

   rewind(fp);
   if (read (fileno(fp), cutBuffer, stat.st_size) < stat.st_size)
   {
      sprintf (msg, "READ error in %s.  Copy aborted!", tmpfile);
      Msg (msg);
   }
   else
   {
      int	copy_failed = FALSE;

      copyingToCutBuffer = TRUE;
      XStoreBytes (mainDisplay, cutBuffer, stat.st_size);
      XSync (mainDisplay, False);
      if (copyingToCutBuffer == INVALID)
      {
         sprintf (msg, "%s  %s", "Copy to cut buffer fails.",
               "Selected object(s) may be too big.");
         copy_failed = TRUE;
      }
      else
         sprintf (msg, "Copy buffer updated.");
      copyingToCutBuffer = FALSE;
      Msg (msg);
      if (copy_failed)
      {
         *cutBuffer = '\0';
         XStoreBytes (mainDisplay, cutBuffer, 1);
      }
   }
   fclose (fp);
   unlink (tmpfile);
   return (TRUE);
}

void CutToCutBuffer ()
{
   if (curChoice == DRAWTEXT && textCursorShown)
   {
      CopyToCutBuffer ();
      DeleteHighLightedText ();
   }
   if (curChoice == NOTHING && topSel != NULL)
   {
      CopyToCutBuffer ();
      DelAllSelObj ();
   }
}

static
void PasteString (CutBuffer)
   char	* CutBuffer;
{
   register char	* c_ptr, * dest_c_ptr;
   int			x, y, w, num_lines, char_count, max_len = 0;
   int			root_x, root_y, grid_x, grid_y;
   unsigned int		status;
   char			msg[MAXSTRING];
   struct StrRec	* first_str, * last_str, *str_ptr;
   struct ObjRec	* obj_ptr;
   struct TextRec	* text_ptr;
   Window		root_win, child_win;

   if (*CutBuffer == '\0') { Msg ("Cut buffer is empty"); return; }

   TieLooseEnds ();
   SetCurChoice (NOTHING);
   if (topSel!=NULL) { HighLightReverse (); RemoveAllSel (); }

   XQueryPointer (mainDisplay, drawWindow, &root_win, &child_win,
         &root_x, &root_y, &x, &y, &status);
   GridXY (x, y, &grid_x, &grid_y);

   text_ptr = (struct TextRec *) calloc (1, sizeof(struct TextRec));
   text_ptr->font = curFont;
   text_ptr->style = curStyle;
   text_ptr->attr = NULL;
   text_ptr->size = curSize;
   text_ptr->just = textJust;
   text_ptr->v_space = textVSpace;
   text_ptr->rotate = curRotate;
   text_ptr->pen = penPat;
   text_ptr->fill = objFill;
   text_ptr->asc = canvasFontAsc;
   text_ptr->des = canvasFontDes;

   text_ptr->read_only = FALSE;
   text_ptr->orig_w = text_ptr->orig_h = 0;
   text_ptr->font_name = NULL;

   first_str = last_str = NULL;
   for (c_ptr = CutBuffer, num_lines = 0; *c_ptr != '\0'; num_lines++)
   {
      str_ptr = (struct StrRec *) calloc (1, sizeof(struct StrRec));

      char_count = 0;
      dest_c_ptr = str_ptr->s;
      while (*c_ptr != '\0' && *c_ptr != '\n' && *c_ptr != '\r')
      {
         *dest_c_ptr++ = *c_ptr++;
         if (++char_count == MAXSTRING)
         {
            sprintf (msg, "String length exceeds %1d.  String truncated.",
                  MAXSTRING);
            Msg (msg);
            while (*c_ptr != '\0' && *c_ptr != '\n' && *c_ptr != '\r') c_ptr++;
            break;
         }
      }
      *dest_c_ptr = '\0';

      str_ptr->prev = last_str;
      str_ptr->next = NULL;
      if (last_str == NULL)
         first_str = str_ptr;
      else
         last_str->next = str_ptr;
      last_str = str_ptr;

      w = XTextWidth (canvasFontPtr, str_ptr->s, strlen (str_ptr->s));
      if (w > max_len) max_len = w;

      if (*c_ptr == '\n' || *c_ptr == '\r') c_ptr++;
   }

   text_ptr->lines = num_lines;
   text_ptr->first = first_str;
   text_ptr->last = last_str;

   obj_ptr = (struct ObjRec *) calloc (1, sizeof(struct ObjRec));
   obj_ptr->x = grid_x;
   obj_ptr->y = grid_y;
   obj_ptr->type = OBJ_TEXT;
   obj_ptr->color = colorIndex;
   obj_ptr->id = objId++;;
   obj_ptr->dirty = FALSE;
   obj_ptr->rotation = 0;
   obj_ptr->detail.t = text_ptr;
   obj_ptr->fattr = obj_ptr->lattr = NULL;

   SetTextBBox (obj_ptr, textJust, max_len,
         num_lines*textCursorH+(num_lines-1)*textVSpace, curRotate);
   AdjObjBBox (obj_ptr);
   PlaceTopObj (obj_ptr);

   AddObj (NULL, topObj, obj_ptr);
   SelectTopObj ();
   RecordNewObjCmd ();
   SetFileModified (TRUE);
   justDupped = FALSE;
}

static
struct ObjRec * CreateTmpBoxObj (LtX, LtY, RbX, RbY)
   int	LtX, LtY, RbX, RbY;
{
   register struct BoxRec	* box_ptr;
   register struct ObjRec	* obj_ptr;

   box_ptr = (struct BoxRec *) calloc (1, sizeof(struct BoxRec));
   box_ptr->fill = NONEPAT;
   box_ptr->width = 0;
   box_ptr->pen = NONEPAT;
   box_ptr->dash = 0;

   obj_ptr = (struct ObjRec *) calloc (1, sizeof(struct ObjRec));

   obj_ptr->bbox.ltx = obj_ptr->obbox.ltx = obj_ptr->x = LtX;
   obj_ptr->bbox.lty = obj_ptr->obbox.lty = obj_ptr->y = LtY;
   obj_ptr->bbox.rbx = obj_ptr->obbox.rbx = RbX;
   obj_ptr->bbox.rby = obj_ptr->obbox.rby = RbY;
   obj_ptr->type = OBJ_BOX;
   obj_ptr->color = colorIndex;
   obj_ptr->id = 0;
   obj_ptr->dirty = FALSE;
   obj_ptr->rotation = 0;
   obj_ptr->detail.b = box_ptr;
   obj_ptr->fattr = obj_ptr->lattr = NULL;
   return (obj_ptr);
}

void AssignNewObjIds (ObjPtr)
   struct ObjRec	* ObjPtr;
{
   register struct ObjRec	* obj_ptr;
   register struct AttrRec	* attr_ptr;

   ObjPtr->id = objId++;
   switch (ObjPtr->type)
   {
      case OBJ_GROUP:
      case OBJ_SYM:
      case OBJ_ICON:
         for (obj_ptr = ObjPtr->detail.r->first; obj_ptr != NULL;
               obj_ptr = obj_ptr->next)
            AssignNewObjIds (obj_ptr);
         break;
      default: break;
   }
   for (attr_ptr = ObjPtr->fattr; attr_ptr != NULL; attr_ptr = attr_ptr->next)
      AssignNewObjIds (attr_ptr->obj);
}

int PasteFromCutBuffer ()
   /* returns FALSE if pasting in text mode and non-tgif bytes are */
   /*	in the cut buffer -- this is interpreted as an attempt to */
   /*	paste into the current text */
{
   FILE 		* fp;
   int 			len, ltx, lty, rbx, rby, dx, dy, read_status;
   char 		tmpfile[MAXSTRING], * cut_buffer, msg[MAXSTRING];
   unsigned char 	header = TGIF_HEADER;
   struct ObjRec	* obj_ptr, * saved_top_obj, * saved_bot_obj, * tmp_obj;
   struct ObjRec	* tmp_top_obj, * tmp_bot_obj;

   cut_buffer = (char *) XFetchBytes (mainDisplay, &len);
   if (len == 0)
   {
      Msg ("Cut buffer is empty");
      return (TRUE);
   }
   if (((unsigned char)(*cut_buffer)) != header)
   {
      if (curChoice == DRAWTEXT)
      {
         XEvent	ev;

         pasteInDrawTextMode = TRUE;
         ev.type = KeyPress;
         DrawText (&ev);
         return (FALSE);
      }
      Msg ("Paste from a non-tgif tool.");
      PasteString (cut_buffer);
      return (TRUE);
   }
   cut_buffer++;
   len--;

   sprintf (tmpfile, "%sTgifXXXXXX", TMP_DIR);
   mktemp (tmpfile);
   if ((fp = fopen (tmpfile, "w+")) == NULL)
   {
      sprintf (msg, "Can not open %s for write.", tmpfile);
      Msg (msg);
      return (TRUE);
   }
   writeFileFailed = FALSE;
   if (write (fileno(fp), cut_buffer, len) < len)
   {
      fclose (fp);
      unlink (tmpfile);
      sprintf (msg, "FWRITE error in writing to '%s'.  Paste aborted!",
            tmpfile);
      Msg (msg);
      return (TRUE);
   }
   fflush (fp);
   rewind (fp);

   SetWatchCursor (drawWindow);
   SetWatchCursor (mainWindow);

   TieLooseEnds ();
   SetCurChoice (NOTHING);
   if (topSel!=NULL) { HighLightReverse (); RemoveAllSel (); }

   saved_top_obj = topObj;
   saved_bot_obj = botObj;
   curPage->top = topObj = NULL;
   curPage->bot = botObj = NULL;
    
   importingFile = TRUE;
   pastingFile = TRUE;
   readingPageNum = 0;
   while ((read_status = ReadObj (fp, &obj_ptr)) == TRUE)
      if (obj_ptr != NULL)
      {
         AdjForOldVersion (obj_ptr);
         UnlockAnObj (obj_ptr);
         AssignNewObjIds (obj_ptr);
         AddObj (NULL, topObj, obj_ptr);
      }

   fclose (fp);
   importingFile = FALSE;
   pastingFile = FALSE;
   unlink (tmpfile);
   SetDefaultCursor (mainWindow);
   SetDefaultCursor (drawWindow);

   if (read_status == INVALID)
   {
      sprintf (msg, "File version too large (=%1d).  Paste aborted!",
            fileVersion);
      Msg (msg);
      return (TRUE);
   }
    
   if (topObj != NULL) SetFileModified (TRUE);

   ltx = topObj->obbox.ltx;
   lty = topObj->obbox.lty;
   rbx = topObj->obbox.rbx;
   rby = topObj->obbox.rby;
   for (obj_ptr = topObj->next; obj_ptr != NULL; obj_ptr = obj_ptr->next)
   {
      if (obj_ptr->obbox.ltx < ltx) ltx = obj_ptr->obbox.ltx;
      if (obj_ptr->obbox.lty < lty) lty = obj_ptr->obbox.lty;
      if (obj_ptr->obbox.rbx > rbx) rbx = obj_ptr->obbox.rbx;
      if (obj_ptr->obbox.rby > rby) rby = obj_ptr->obbox.rby;
   }
   tmp_obj = CreateTmpBoxObj (ltx, lty, rbx, rby);

   tmp_top_obj = topObj;
   tmp_bot_obj = botObj;
   curPage->top = topObj = NULL;
   curPage->bot = botObj = NULL;
   PlaceTopObj (tmp_obj);
   curPage->top = topObj = tmp_top_obj;
   curPage->bot = botObj = tmp_bot_obj;

   dx = tmp_obj->obbox.ltx - ltx;
   dy = tmp_obj->obbox.lty - lty;
   FreeBoxObj (tmp_obj);

   for (obj_ptr = topObj; obj_ptr != NULL; obj_ptr = obj_ptr->next)
      MoveObj (obj_ptr, dx, dy);
    
   SelAllObj (FALSE);
    
   if (botObj != NULL)
      botObj->next = saved_top_obj;
   else
      curPage->top = topObj = saved_top_obj;

   if (saved_top_obj != NULL)
   {
      saved_top_obj->prev = botObj;
      curPage->bot = botObj = saved_bot_obj;
   }
   RedrawDrawWindow (botObj);
   PrepareToRecord (CMD_NEW, NULL, NULL, 0);
   RecordCmd (CMD_NEW, NULL, topSel, botSel, numObjSelected);
   HighLightForward();

   Msg ("Objects pasted from tgif.");
   return (TRUE);
}        

int PasteFromFile ()
   /* returns FALSE if pasting in text mode and non-tgif bytes are */
   /*	in the cut buffer -- this is interpreted as an attempt to */
   /*	paste into the current text */
{
   char	file_name[MAXPATHLENGTH+1];

   if (SelectFileNameToPaste ("Please select a file to PASTE ...", file_name) !=
         INVALID)
   {
      FILE	* fp;
      char	msg[MAXSTRING+1], inbuf[MAXSTRING+1], * cut_buffer=NULL;
      int	size=0, pos=0;

      if (curChoice == DRAWTEXT)
      {
         XEvent	ev;

         pasteInDrawTextMode = TRUE;
         pasteFromFileInDrawTextMode = TRUE;
         strcpy (pasteFromFileName, file_name);
         ev.type = KeyPress;
         DrawText (&ev);
         return (FALSE);
      }
      if ((fp = fopen (file_name, "r")) == NULL)
      {
         sprintf (msg, "Can not open '%s' for read.", file_name);
         Dialog (msg, NULL, NULL);
         return (TRUE);
      }
      while (fgets (inbuf, MAXSTRING, fp) != NULL) size += strlen (inbuf);
      fclose (fp);
      if (size == 0)
      {
         sprintf (msg, "File '%s' is empty.", file_name);
         Dialog (msg, NULL, NULL);
         return (TRUE);
      }
      cut_buffer = (char *) calloc (size+2, sizeof(char));
      if (cut_buffer == NULL)
      {
         sprintf (msg, "Can not malloc %1d bytes.", size+2);
         Dialog (msg, NULL, NULL);
         return (TRUE);
      }
      if ((fp = fopen (file_name, "r")) == NULL)
      {
         sprintf (msg, "Can not open '%s' for read.", file_name);
         Dialog (msg, NULL, NULL);
         return (TRUE);
      }
      while (fgets (&cut_buffer[pos], MAXSTRING, fp) != NULL)
         pos += strlen (&cut_buffer[pos]);
      fclose (fp);
      PasteString (cut_buffer);
   }
   return (TRUE);
}

void CleanUpCutBuffer ()
{
   if (cutBuffer != NULL)
   {
      *cutBuffer = '\0';
      cfree (cutBuffer);
      cutBuffer = NULL;
   }
   copyingToCutBuffer = FALSE;
}
