/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2009, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm2/home/cvs/bc-src/tgif/tdgtbase.e,v 1.6 2009/06/10 18:52:44 cvsps Exp $
 */

#ifndef _TDGTBASE_E_
#define _TDGTBASE_E_

#include "tidget.h"

#include "list.e"

#define TDGTBASE_DEF_H_PAD 4
#define TDGTBASE_DEF_V_PAD 4

#define TDGTCMD_CAN_HANDLE_FOCUS_CHANGE 1
#define TDGTCMD_REMOVE_FOCUS            2

struct tagTdgtBase;

typedef int (TdgtBaseKeyPressEvHandlerCallbackFunc)ARGS_DECL((
		struct tagTdgtBase *, XEvent*));
typedef void (TdgtBaseWmDeleteEvHandlerCallbackFunc)ARGS_DECL((
		struct tagTdgtBase *));
typedef int (TdgtBaseFocusCallbackFunc)ARGS_DECL((
		struct tagTdgtBase *, int cmd_type, int cmd_arg,
		void *pv_cmd_userdata));

/*
 * A base tidget is a container of which other tidgets can sit on top.
 */
typedef struct tagTdgtBase {
   TidgetInfo *pti;

   /* callback functions */
   TdgtBaseKeyPressEvHandlerCallbackFunc *pf_key_press_ev_handler_callback;
   TdgtBaseWmDeleteEvHandlerCallbackFunc *pf_wm_delete_ev_handler_callback;
   TdgtBaseFocusCallbackFunc *pf_focus_callback;
} TdgtBase;

#ifdef _INCLUDE_FROM_TDGTBASE_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_TDGTBASE_C_*/

extern void	TdgtBaseReset ARGS_DECL((TdgtBase*));
extern TdgtBase	*CreateTdgtBase ARGS_DECL((Window parent_win,
				TidgetInfo *parent_tidgetinfo, int ctl_id,
				int x, int y, int w, int h, int h_pad,
				int v_pad, int state, char *caption));

extern int	TdgtBaseSetText ARGS_DECL((TdgtBase*, char *str));
extern char	*TdgtBaseGetText ARGS_DECL((TdgtBase*));
extern int	TdgtBaseSetState ARGS_DECL((TdgtBase*, int));
extern int	TdgtBaseGetState ARGS_DECL((TdgtBase*));

extern int	TdgtBaseAddChild ARGS_DECL((TdgtBase*, TidgetInfo*));

extern void	TdgtBaseWillHandleKeyPressEvents ARGS_DECL((TdgtBase*,
				TdgtBaseKeyPressEvHandlerCallbackFunc*));
extern void	TdgtBaseSetWmDeleteCallback ARGS_DECL((TdgtBase*,
				TdgtBaseWmDeleteEvHandlerCallbackFunc*));
extern void	TdgtBaseSetFocusCallback ARGS_DECL((TdgtBase*,
				TdgtBaseFocusCallbackFunc*));

extern int	InitTdgtBase ARGS_DECL((void));
extern void	CleanUpTdgtBase ARGS_DECL((void));

#ifdef _INCLUDE_FROM_TDGTBASE_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_TDGTBASE_C_*/

#endif /*_TDGTBASE_E_*/
