/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2009, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm2/home/cvs/bc-src/tgif/inmethod.e,v 1.6 2009/01/09 22:25:30 william Exp $
 */

#ifndef _INMETHOD_E_
#define _INMETHOD_E_

typedef char *(Tgim_stringprep_convert_Func)ARGS_DECL((const char *str,
		const char *to_codeset, const char *from_codeset));

extern int	gnInputMethod; /* one of TGIM_* */
extern int	gnOverTheSpot;

extern int	cmdLineHasInputMethod;
extern int	cmdLineDoubleByteInputMethod;
extern char	cmdLineInputMethod[];

#ifdef _INCLUDE_FROM_INMETHOD_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_INMETHOD_C_*/

extern int	Tgim_has_stringprep_convert ARGS_DECL((void));
extern char	*Tgim_stringprep_convert ARGS_DECL((const char *str,
		                                    const char *to_codeset,
		                                    const char *from_codeset));

extern void	CleanUpInputMethods ARGS_DECL((void));
extern int	InitInputMethods ARGS_DECL((void));

extern int	ResetInputMethod ARGS_DECL((void));
extern int	InputMethodTypeMatched ARGS_DECL((int DoubleByte));

extern int	tgIMFocusIn ARGS_DECL((Display *dpy, Window win));
extern int	tgIMFocusOut ARGS_DECL((Display *dpy, Window win));
extern int	tgIMTranslateKeyEvent ARGS_DECL((Display *dpy,
		                                 Window win,
		                                 XKeyEvent *key_ev,
		                                 char *buf));
extern int	tgIMConvertProperty ARGS_DECL((Display *dpy,
		                               Window win,
		                               XPropertyEvent *prop_ev,
		                               char **ppsz_buf));
extern int	tgIMExpectClientMessage ARGS_DECL((Display *dpy,
		                                   Window win));
extern int	tgIMHandleClientMessage ARGS_DECL((Display *dpy,
		                                   Window win,
		                                   XClientMessageEvent *cm_ev,
		                                   XKeyEvent *key_ev,
		                                   char *buf));
extern int	tgIMActiveOnCntrlSpace ARGS_DECL((Display *dpy,
		                                  Window win));
extern int	tgIMHandleCntrlSpace ARGS_DECL((Display *dpy,
		                                Window win));
extern int	tgIMDeactiveOnCreateText ARGS_DECL((Display *dpy,
		                                    Window win));
extern int	tgIMHandleCreateText ARGS_DECL((Display *dpy,
		                                Window win));
extern int	tgIMTellCursorPosition ARGS_DECL((Display *dpy,
		                                  Window win,
		                                  int cur_x,
		                                  int cur_y));
extern int	tgIMExpectNextEvent ARGS_DECL((Display *dpy,
		                               Window win));
extern int	tgIMHandleNextEvent ARGS_DECL((Display *dpy,
		                               Window win,
		                               XEvent *ev));
extern int	tgIMHandleNewCurText ARGS_DECL((Display *dpy,
		                                Window win));
extern int	tgIMExpectLookupString ARGS_DECL((Display *dpy,
		                                  Window win));
extern int	tgIMHandleLookupString ARGS_DECL((Display *dpy,
		                                  Window win,
		                                  XKeyEvent *key_ev,
		                                  char *psz_buf,
		                                  int buf_size,
		                                  KeySym *p_key_sym,
		                                  int *pn_has_ch));

#ifdef _INCLUDE_FROM_INMETHOD_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_INMETHOD_C_*/

#endif /*_INMETHOD_E_*/
