/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2009, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm2/home/cvs/bc-src/tgif/version.c,v 1.11 2009/09/28 22:20:44 william Exp $
 */

#define _INCLUDE_FROM_VERSION_C_

#include "tgifdefs.h"
#include "patchlvl.h"

#include "version.e"

char *versionString="4.2";
char *authorEmailString="bill.cheng@acm.org";
#ifdef QPL_LICENSE
char *copyrightString="Copyright (C) 2001-2009, William Chia-Wei Cheng";
#else /* ~QPL_LICENSE */
char *copyrightString="Copyright (C) 1990-2009, William Chia-Wei Cheng";
#endif /* QPL_LICENSE */
char *homePageURL="http://bourbon.usc.edu/tgif/";
char *oldMailingList="kragen-tgif@kragen.dnaco.net";
char *mailingList="tgif4-announce@yahoogroups.com";
char *joinMailingList="tgif4-announce-subscribe@yahoogroups.com";
char *mailingURL="http://bourbon.usc.edu/tgif/faq/mailings.html";
char *currentReleaseURL="http://bourbon.usc.edu/tgif/download.html";
char *hyperGraphicsURL="http://bourbon.usc.edu/tgif/index.obj";

char fullVersionString[MAXSTRING];
char fullToolName[MAXSTRING];
#ifdef QPL_LICENSE
char *specialBuild="QPL";
#else /* ~QPL_LICENSE */
char *specialBuild="";
#endif /* QPL_LICENSE */

void SetFullVersionString()
{
   if (*specialBuild == '\0') {
      sprintf(fullVersionString, "%s.%1d", versionString, TGIF_PATCHLEVEL);
   } else {
      sprintf(fullVersionString, "%s.%1d-%s", versionString, TGIF_PATCHLEVEL,
            specialBuild);
   }
   sprintf(fullToolName, "%s-%s", TOOL_NAME, fullVersionString);
}

void InitVersion()
{
}
