/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2009, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm2/home/cvs/bc-src/tgif/tdgtmsg.e,v 1.5 2009/01/09 22:25:32 william Exp $
 */

#ifndef _TDGTMSG_E_
#define _TDGTMSG_E_

#include "tidget.h"

#define TDGTMSG_DEF_H_PAD 4
#define TDGTMSG_DEF_V_PAD 2

/*
 * A message tidget displays a string.
 */
typedef struct tagTdgtMsg {
   TidgetInfo *pti;

   int just; /* JUST_L, JUST_C, or JUST_R */
} TdgtMsg;

#ifdef _INCLUDE_FROM_TDGTMSG_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_TDGTMSG_C_*/

extern void	TdgtMsgReset ARGS_DECL((TdgtMsg*));
extern TdgtMsg	*CreateTdgtMsg ARGS_DECL((Window parent_win,
				TidgetInfo *parent_tidgetinfo, int ctl_id,
				int x, int y, int h_pad, int v_pad, int state,
				char *caption, int just));

extern int	TdgtMsgSetText ARGS_DECL((TdgtMsg*, char *str));
extern char	*TdgtMsgGetText ARGS_DECL((TdgtMsg*));
extern int	TdgtMsgSetState ARGS_DECL((TdgtMsg*, int));
extern int	TdgtMsgGetState ARGS_DECL((TdgtMsg*));

extern int	InitTdgtMsg ARGS_DECL((void));
extern void	CleanUpTdgtMsg ARGS_DECL((void));

#ifdef _INCLUDE_FROM_TDGTMSG_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_TDGTMSG_C_*/

#endif /*_TDGTMSG_E_*/
