/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2003, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/tgtwb5xl.c,v 4.2 2003/08/01 18:23:55 william Exp $
 */

#ifndef _NO_TGTWB5

#define _INCLUDE_FROM_TGTWB5XL_C_

#include "tgifdefs.h"

#include "tgtwb5xl.e"

char *firstLargeTransTbl[] = {
   "5",   "",    "Punctuations",    "Symbols",
   "1",   "2",   "3",   "4",
   "Er",  "",    "",    "",
   "An",  "En",  "Ang", "Eng",
   "Ai",  "Ei",  "Ao",  "Ou",
   "A",   "O",   "E",   "Eh",
   "Y",   "W",   "Yu",  "",
   "Z",   "C",   "S",   "",
   "Zh",  "Ch",  "Sh",  "R",
   "J",   "Q",   "X",   "",
   "G",   "K",   "H",   "",
   "D",   "T",   "N",   "L",
   "B",   "P",   "M",   "F",
};

char *secondLargeTransTbl[] = {
   "5",   "",    "",    "",
   "1",   "2",   "3",   "4",
   "",    "",    "",    "",
   "an",  "en",  "ang", "eng",
   "ai",  "ei",  "ao",  "ou",
   "a",   "o",   "e",   "e",
   "i",   "u",   "u",   "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
};

char *thirdLargeTransTbl[] = {
   "5",   "",    "",    "",
   "1",   "2",   "3",   "4",
   "",    "",    "",    "",
   "an",  "n",   "ang", "ng",
   "ai",  "i",   "ao",  "u",
   "a",   "o",   "",    "e",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
};

char *fourthLargeTransTbl[] = {
   "5",   "",    "",    "",
   "1",   "2",   "3",   "4",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
};

char *singleExtention[] = {
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "i",   "u",   "",    "",
   "i",   "i",   "i",   "",
   "i",   "i",   "i",   "i",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
};

char *pinyin_et_big5[] = {
   "5",		"a3bb",
   "1",		"a3bc",
   "2",		"a3bd",
   "3",		"a3be",
   "4",		"a3bf",
   "A",		"a3ab",
   "A1",	"b0da",
   "A4",	"aafc",
   "Ai",	"a3af",
   "Ai1",	"ab73ab75adfcae4aaec1",
   "Ai2",	"b1babd4ae1f4ef63",
   "Ai3",	"b847c4a7c647ca64d4e4cef7d5d9cb48",
   "Ai4",	"bebcb752c0c7c0f5c3aaa6e3b969e4edeccde954ee49f957ef7ced54d2def4cfeeb8f669",
   "An",	"a3b3",
   "An1",	"a677b167aef2b5dabe62c44fcbc8d8c0cea6ceacea75df72dfd6bfdabbcfef56deca",
   "An2",	"d875cfcde0d8",
   "An3",	"adcdd47bd9a3",
   "An4",	"a9a4abf6b774aed7c566e8f8d1dbcf7dca43d3b0eeeed0eeebfe",
   "Ang",	"a3b5",
   "Ang1",	"bbeab5cb",
   "Ang2",	"a9f9c957",
   "Ang3",	"dc42e0d9",
   "Ang4",	"af73eecc",
   "Ao",	"a3b1",
   "Ao1",	"a557cbfccf62",
   "Ao2",	"b9c8b1cebcf5bfacc16dbe43c3efc652e1bce5ade2b0f26ae676e6a9eaa2e757ee67f0e6f36ce4bbf67df7b4",
   "Ao3",	"b6fea9edc3cdcdbdd844",
   "Ao4",	"b6c6b6f8bed2bf44e94dd8b4e96adbe4caf3",
   "B",		"a374",
   "Ba1",	"a44ba57aa761a4daaccdafb9aaddc954aec3c9f6d7d0d34a",
   "Ba2",	"a9deb65bb959c9a5d05ad06edb6edbfde8d9f1e4dbd9",
   "Ba3",	"a7e2b976dc6a",
   "Ba4",	"c5f2aaa8bd7dc551cad3c5f4d666",
   "Bai1",	"d954",
   "Bai2",	"a5d5",
   "Bai3",	"a8d5c25ca6cad579f478dae9daf7c4fc",
   "Bai4",	"abf4b1d1d0f9cad1defbe361",
   "Ban1",	"a7e6b768b4b3af5aafebb97bccc1ddbdbd49ee57eb78",
   "Ban3",	"aa4faaa9afeac1f3a8c1ccc6d349e3edb67a",
   "Ban4",	"a6f1a562a7eaa9d5c3a4b2ccbfeca972ccadd5e4e0c1e4bf",
   "Bang1",	"b3c4c0b0b1f5a8b9d157eadbf17d",
   "Bang3",	"ba5db86abb48e9e8e2c6",
   "Bang4",	"b4cebd53b046c1bdc2e9dcebeaf5",
   "Bao1",	"a55dad4dad63bdc7d6ddeb55",
   "Bao2",	"b972d2bdd2fc",
   "Bao3",	"ab4fb3f9c45fbdc8b9a1ccafb8b6e4d7e8e9e4e4",
   "Bao4",	"b3f8a9eabcc9c37ab05cb95ec06aecbcefbccc55de73f26fdbadeb58d7c2d3e5c5e1f97b",
   "Bei1",	"a8f5b464aa4dacd7b84fc9b8b4aed5b5d9c1e373db7cf3ed",
   "Bei3",	"a55f",
   "Bei4",	"adbfb3c6aeafbeceb548af56ad49bb5fb351a8a9bdfad453d0feefc0a7b8d5cbd674daaaeac7e7c8aaf5dc58be58e2c8d3f8",
   "Ben1",	"a962cd49d5ebebe6",
   "Ben3",	"a5bbaf63caacad66",
   "Ben4",	"b2c2ca5e",
   "Beng1",	"b159c15eca5bd54dcff4dc79",
   "Beng2",	"acc7",
   "Beng3",	"d4becd66da7ddb66e04f",
   "Beng4",	"c2dbe15ddd7baca6f7d7e067b06e",
   "Bi1",	"b947d44ddab7e3c9e344e7e6",
   "Bi2",	"b2f2bbf3",
   "Bi3",	"a450a7ada9bca4f1b5a7bbc0cc59c9f5cf44a85de65fcb70cff9bae8d3bce7e7",
   "Bi4",	"addabec0b141b9f4a7c8b9fab45da5b2b470b1cdc0c5c27ab2a6b7f4b844bad1c175bdaac1a3bb74b64eb940c1d7b3acb0a1ca5ab9cdcaafd8aacc4ce958d54be1bfcc7ad941cefcd5b2ddd0cf68d9f0e27de667d2a5e675cfc7cd71cfdddecde358bf7bedc3edd6eae1df74cdb6d06ce76edfe5c3cef4caeb7db647f653c2def4d9cdd3e857b963f15df372e0cde0e2e4d1e8c6f67ae8d2f1b9ec74f1d6f7c6f7c0f97ee67ed34b",
   "Bian1",	"afa2bd73bdbfc3e4c340da78e2d6e348e6dbf8fb",
   "Bian3",	"b0d0abf3b653d947e2f3d2f6bdca",
   "Bian4",	"ab4ba4cba5afc47cc5dcbfebc547b94dcad9cae7d971a858cb5ad9ede6ece74ba8bce0cfecaa",
   "Biao1",	"bcd0b343c3f0c5dfecb9e149e164e2a4efece664da6eea6cf4a2f2c2f0eaf348dcade4cdf674f9cdd449e8f0",
   "Biao3",	"b144aaedbff6d0cfed46e3f7ee74e7e0",
   "Biao4",	"c5c0",
   "Bie1",	"c5bee578f9bd",
   "Bie2",	"a74fcbdbe1c1ee76f144ee6f",
   "Bie3",	"c3a7d7a1",
   "Bie4",	"b9fb",
   "Bin1",	"beaab16cc262c0d8c378c47dbbabd979d9d7c9a2f040f279f4c4e452c1c7cbacf767f37ef8d3",
   "Bin4",	"c26cc2c1c64bece8f8d4",
   "Bing1",	"a74ca642d57cdaedd1d9",
   "Bing3",	"a4feac60acb1aac3b85bbbe6cc7dcef4d2f7d07ed7aecdd4bbd0cddcef40",
   "Bing4",	"a8c3a8d6a67db4acaf66d452d8d6ef78",
   "Bo1",	"ade9bcb7aa69acc1b2dab5d4e567cf59d2dcdeebd7b7f351f85bd471",
   "Bo2",	"a742ab6bb3d5a9adb769ac66aa79b4f1bae4c3afb2e4bb4bb2edbdb3c1a1b960bbe9e0fbefccd1b4d5c5f5ced24adeaacd6ef063f2aed063dfb4f0d4f64ae44feeace463e7f4e877f157f952e8c1f1aeec60ec61f566f1d0d3f6f2a1",
   "Bo3",	"b65fd7b0",
   "Bo4",	"bcbdc0bcc3b0c4f4adbdc0d0f2b7f342cee0",
   "Bu1",	"d16cd5aad7e3e8c2f1d1",
   "Bu3",	"a452adf7ae48aeb7b8c9e0eb",
   "Bu4",	"a4a3a747b0f0a5aca9c6a842b3a1b95ad1caedcbe74f",
   "C",		"a3a9",
   "Ca1",	"c0bf",
   "Ca3",	"f47d",
   "Ca4",	"f5c4",
   "Cai1",	"b271",
   "Cai2",	"a47ea7f7b5f4b05dc5d7",
   "Cai3",	"b16db1c4b842baf9bdf2aaf6e073d4f2d9bd",
   "Cai4",	"b5e6bdb2d4caedda",
   "Can1",	"b0d1c05cf67c",
   "Can2",	"ba46b4ddc5fae95b",
   "Can3",	"ba47e4fde5a3d9a9f876",
   "Can4",	"c0e9ea44c0f6df54",
   "Cang1",	"addcb3c9b7c9bfb5bb61d861dd56f6c1",
   "Cang2",	"c2c3",
   "Cao1",	"bedec157ebd6",
   "Cao2",	"b9cbb1e4bcd1baa8e1a6edf1ee5d",
   "Cao3",	"aff3e97bca4af55a",
   "Cao4",	"cdabf2f1",
   "Ce4",	"b0bca555b45ab46cb4fab5a6e5a8cee3d2c2dee3df49d6e1d37ce3d1",
   "Cen1",	"e1add5b7",
   "Cen2",	"a7c2d5baaf4bd348d158",
   "Ceng1",	"e4f8",
   "Ceng2",	"bc68e565e855def0",
   "Ceng4",	"f34f",
   "Ch",	"a3a5",
   "Cha1",	"a465b3e5ae74b4a1dcd8c9eacb43d068eaf6d458ea6a",
   "Cha2",	"b9eeb767ac64aff9ce51d2c6e2edcda4eed0e241",
   "Cha3",	"ebc1",
   "Cha4",	"ab62a7c3b8d2cbb2c9cdc9fcd04cd0ae",
   "Chai1",	"a9eeb3a6d85b",
   "Chai2",	"aee3b05bbeabd6c2dcd7",
   "Chai4",	"e6aff2e3d3d9",
   "Chan1",	"c465e96cd8f8d9c0e3f6f2eecba6e87e",
   "Chan2",	"bc60b447bcebc149c4f1c2cdc5fec661e0f7f1edf440c460e573d9cdf5d0c0d5da52bf47f464de78e2cceaa8f2b0f7efc3caf75ef4e2ebeef955efed",
   "Chan3",	"b6d0b2a3bdd4c3eac4c4cbb1e543f6d8e1aee56fcafce273f7e4ea4cedbaf073eb41f77cf341",
   "Chan4",	"c462c35fc4f3",
   "Chang1",	"adceb140a9f7b273c449d640daa8db75e3fbebf9ec4bf6d0",
   "Chang2",	"c076b9c1c07cb3f5b9dfb160b87aaaf8b175b5e7ebf8f95a",
   "Chang3",	"bc74b4afd55cceebbefbebf3",
   "Chang4",	"add2b0dbb1a3ba5aef43d44a",
   "Chao1",	"a7dbb657b672cc70cca2eae2d7cb",
   "Chao2",	"bc4ab15fbce9e5dcf148e471e6d3",
   "Chao3",	"a76eaaa3d2d8",
   "Chao4",	"d366",
   "Che1",	"a8aedacfd773",
   "Che3",	"a7e8f7d4e1e4",
   "Che4",	"a95cb9fdb477ba4dbaabc2e1c94bd65bdaced0b6",
   "Chen1",	"dcd2d9c7b560bd51e7e1eeafe7edd7eb",
   "Chen2",	"b9d0ae66a7d5b1e1a849a6daa8b0b3afd942e5e7de70d3b2d759e77dee6abfdbdc71f7bcf1de",
   "Chen3",	"e15ed577eaa7dad3f0f5ebbfeed1",
   "Chen4",	"c5a8c640b658efb8f1f0c468accff4c3efb5",
   "Cheng1",	"bcb5bf65bad9d457d4bfd9d1e9daecf7d261daa5edb8f2deebb9f4fee4cbf559",
   "Cheng2",	"a5e0adbca765abb0c367a6a8a9d3beedbce1b57bb8dbd14cdce6d4f6d5a3d957d1d4d9b3d9fee64ad66dd36fd749d775cdc7dff4d0bae473f55dd168",
   "Cheng3",	"b378c1fed547dcf0d1ad",
   "Cheng4",	"afafda67",
   "Chi1",	"a659b6e1b7f6b2c7b045b3f0dcf7e1dbdaabc3a8d6b2d6c3df5dee5ae7e2d3fbec6cc55ef875f5bdea77",
   "Chi2",	"b0cdbc55a6a2abf9a6c0bdf3bff0b9a3cbfbe577d1facb59aa7ce34ee357eac1d741d07ad3b3d7a8eea1dbe9e062d8f6d3a2",
   "Chi3",	"a8d7a760a4d8aea2bfc9b361bea6d85ece6acecacededdb6d9ddd3bfe04ee4a4",
   "Chi4",	"a577b3d7a5b8bf4bafcda8aab6bdd44bdcbfce47d0f4c94cefc7ccb8b1d5d1ded5eadecee6b7d2d5e06be460e853e0c9f555f57bf7c2e042",
   "Chong1",	"a552bca5a852b2eabdc4caddd245cfcff0fbd072",
   "Chong2",	"b152c2ced6a1cffad365d3b5e7c0dca3",
   "Chong3",	"c364",
   "Chong4",	"d96fe0b6",
   "Chou1",	"a9e2d4dbddb1f46cea6feac5",
   "Chou2",	"a4b3bea9b1a8b754c3a5b859c477baf7c543b953ecd4ece5d9d4effdd6e8daf6dbacf0aabb76e045f841ec50c357d1ee",
   "Chou3",	"a4a1c1e0ca7ccce4ccd8e2e4",
   "Chou4",	"afe4e268edc5",
   "Chu1",	"a558aaecf0f0",
   "Chu2",	"c078bc70c36fafecc3dcbe53b0a3c2fac4d5efc6de51e2c9eabedf71e3c1f2d0dfefe060f75de0bcf6bd",
   "Chu3",	"aa53b7a1c2a6bb75b4d8ed47e9ea",
   "Chu4",	"a9c5af62c5f7b2d2b342c4b2c24ac948d0d4e4f1dd7aecf0c0d3cd4dde47daa2edecdbdccdcbe462e0a4d1cd",
   "Chuai2",	"e744",
   "Chuai3",	"b4a2",
   "Chuai4",	"bfe5e544",
   "Chuan1",	"a474acefdeb8f4fbcb4a",
   "Chuan2",	"b6c7b2eee5c7dddcddf8ebafebcce0a1",
   "Chuan3",	"b3dda6df",
   "Chuan4",	"a6eab3a9ca40cb6bd3b6e455",
   "Chuang1",	"bd48b5a1e579e1d7e1ec",
   "Chuang2",	"bc6ca7c9e9bf",
   "Chuang3",	"c2f4e2b4",
   "Chuang4",	"b3d0b75bcbd4deaf",
   "Chui1",	"a76aaaa4",
   "Chui2",	"ababb4a8ba6cc1e8b6abd45bd87cddb4dddeda50bd69c2f1dfc8",
   "Chun1",	"ac4bd8c7ddc5ccd7ddcfda59ebcff573f5aa",
   "Chun2",	"b245afc2b2e5be4ac44cae42e9a3e27ae75debdef3d3",
   "Chun3",	"c4f8d462dd65dfd8ebbd",
   "Chuo1",	"c257d0eaf160f96a",
   "Chuo4",	"b0e3baefbdf9c5c6ca77d15cd4d8d8bdd55be9a8f259d675dec5eaabdb4de7efdc4ee85d",
   "Ci1",	"b2abbbdbceb8edf9dbeee05ef565f2db",
   "Ci2",	"b74fb2a1bacfafa8b5fcc3e3ce4de959cf5aed5baffde8bfe8c0",
   "Ci3",	"a6b9cbbdcf75d2afe06cd6a6",
   "Ci4",	"a8eba6b8cbb5c9f4daebdb6cd3ccdbb4",
   "Cong1",	"a55ea777bcd7c16fbdb5d9d9e6a6e6a7e776ee65eed8f36bf67be5c4ea7a",
   "Cong2",	"c24fb171b246d4ddd4f0d555e1c8e2a6e2acda7ae7ebebefd54f",
   "Cong4",	"f6e6f0a8f0e5",
   "Cou4",	"b4eaddcedf73bfea",
   "Cu1",	"b2cad7c8f9d2",
   "Cu2",	"cc75cf65",
   "Cu4",	"ab50c14cc2d9be4cc3ebe4f6d5c7bcd8d660ea6be754e7fec3e0e163e9e1f1e2e57b",
   "Cuan1",	"f5cdf94fe87d",
   "Cuan2",	"f5c3f6de",
   "Cuan4",	"c679c2abbf79",
   "Cui1",	"b6cab15aba52e151e167e1fceaa5f369",
   "Cui2",	"dcc5e1d0",
   "Cui3",	"e2a8bd41e7f1",
   "Cui4",	"b17cb7f1bae9bb41afdcb5d1d0c9d475d478d9e5b266da58edb9e363eaeceaef",
   "Cun1",	"a7f8b572",
   "Cun2",	"a673ced7dbc6",
   "Cun3",	"a6a4c96b",
   "Cun4",	"a654a46fd047",
   "Cuo1",	"b762bd52c1cee3b5e84f",
   "Cuo2",	"b744dab5dac4e768eecbf6c9",
   "Cuo3",	"e2cfeaccd74c",
   "Cuo4",	"adedaec0b1b9bcbcbe56bff9cde8cdf1d0e8d76be3c4f8a2",
   "D",		"a378",
   "Da1",	"b766e5bcd055d3afbfca",
   "Da2",	"b5aab946bbdec5b6d862cbe3e8fdcc48a9cdcfafd67bd6d4f2b8ee54eb7cf662",
   "Da3",	"a5b4",
   "Da4",	"a46a",
   "Da5",	"bd44cbde",
   "Dai1",	"a762e2ca",
   "Dai3",	"a4ef",
   "Dai4",	"a54ea9a7b161abddabe5c0b9ac70acc5b355b655b665c24cd4b4e1b7c9e0c9fbf467d6ededf2f7fbe06ff140dc4cada4f8cecf63",
   "Dan1",	"a4a6b3e6bee1c2b0afd4e4f5e145f1f4e9e3f048cfe0cff2d743f2c0f0d5e858d7f2ecb4",
   "Dan3",	"c178dcb3c9bfbcc2e5b8cd6caf6ed350d3dbf964e9fe",
   "Dan4",	"a6fdb0dcbc75bcaaa5b9b4e1b248bf46b34abdcfe0f8e4eeb0e8d878e4fccacce97ee9bbcf5ccd43e649cd63ed76f050df44e3abdb79e3f4dbd5e0baf548e4dceca5",
   "Dang1",	"beb4b7edc3cbc54cbbfddd4eea40ed68f2aaf2c4f2df",
   "Dang3",	"bed7c0c9c4d2d0def7dcf8acc66d",
   "Dang4",	"c0fabfbad8bbcc58d945e64ded66dec2e2eef05df061dba5e07ef66d",
   "Dao1",	"a44da56fdd5bc97bcdb1e0eac9f7",
   "Dao3",	"adcbbec9ae71b76fc3abeccbd572eceadef4",
   "Dao4",	"a8ecb1a5b573bd5fc1d0b944ecdbed43f941f4b1db71f6f2",
   "De2",	"b16fbc77d5fc",
   "De5",	"aaba",
   "Dei1",	"f2d3",
   "Deng1",	"bf4fb56eea66f068e053f4f1e55d",
   "Deng3",	"b5a5dd75",
   "Deng4",	"b9b9bc6ac0fcc145c3debe48e54cf549ebd3",
   "Di1",	"a743ba77e161cc77edadd6f4db7dd7beeed7f17a",
   "Di2",	"b9debcc4bab0a866b2c3bb43b2fdad7dc3e9ecc9d5d2e660edc1f740e77bf753f0f8dcabf95f",
   "Di3",	"a9b3a9e8a5c2acbbafa1b643aaf3cbeecc73ac6bd074db63dbd3dc45cddbe3a3",
   "Di4",	"a661ae58abd2a7ccb4d0b2c4bd6cb8a6bfcdbbbce15ae550cafacb41dde8e5cada4dd649cb6aea69dabbe2ebe2f8e760d0a9e3dfee61ebc2d3e8e850d7f9e0e6",
   "Dian1",	"c571b7bfc5f6c441d859d569cee7e25ce6b6eebaf968d865",
   "Dian3",	"a8e5b84bc249d4e8daa9ded1eb47",
   "Dian4",	"a6fab9d4b3fea9b1b17db7b5befdacbfa86cb971c051cbf5e94ed4deced2d5e0d2c4f04aedacf065b966cdd9",
   "Diao1",	"ade4a44ea570b16eb84db649c04ac9ebdaa4eaa1d7a2c44bf3e7e5f4cdc9e0ec",
   "Diao3",	"ce78d442",
   "Diao4",	"a651a4ddb1bcbdd5b3a8c9b9eab4e773f0afe4e0",
   "Die1",	"af52dcdd",
   "Die2",	"b3e3b7dec57cbad0bdbabfd2b65eada1ce53d8a2ce7be1a5cee4cef2d2bcd2d2b5bbb5c0db45d05ddb54e747d079e3d7e7c5dbdddbf7ebc0dc78f56b",
   "Die4",	"d944",
   "Ding1",	"a442a4b1a56da86eb076c978ceb5ca45cb6fd84d",
   "Ding2",	"d4e2",
   "Ding3",	"adaab3bbb9a9e1b1e9eeee43",
   "Ding4",	"a977ad71bff5d161d9ccdee4ef45d448e2f4d472",
   "Diu1",	"a5e1e4b7",
   "Dong1",	"a556a94eaa46c35dd4c0d4f8d5e8d0a4dbaae3d9f3f0",
   "Dong3",	"c0b4b8b3e551e95c",
   "Dong4",	"ade1b0caabf0b4c9ac7dafdbd1afcedcec69eef9",
   "Dou1",	"b0c2b3a3d3f2",
   "Dou3",	"a7dda4e6b042b07ed0f2aa55d977",
   "Dou4",	"b56bc475a8a7b372b0abd5c6d24db2e8d75ee865e8c3",
   "Du1",	"b9cab7feebdcec47",
   "Du2",	"c370ac72c270c37cc37dbf57c5aac675ecbaf25adeece7a6f9c8f75cf8d1f772c5eaf472f8d2",
   "Du3",	"b0f4b840bf77bde4e3feec45d545",
   "Du4",	"a7aaabd7a7f9b4e7a87bc5fbc1e1d868d6c4f2ab",
   "Duan1",	"baddd465d46bd8cd",
   "Duan3",	"b575",
   "Duan4",	"c25fac71bd76c1ebdde0e9e4e2f1f8b8df7cdfe0",
   "Dui1",	"b0efded4e8bd",
   "Dui4",	"a749b9efb6a4e976efc8ed55b850cff6f0b3f2f7f658f4e8f264",
   "Dun1",	"b4b0c3dbbc5bb1ace9aae3d5f7a3edab",
   "Dun3",	"acdac4bb",
   "Dun4",	"beb7a850bf4cacdeb950b677b979c9b6caadd8eccacecaf4e654e851f5a9",
   "Duo1",	"a668",
   "Duo2",	"b9dcc54dd469d573d5a7d974ddf2d9e4d76ae440f2ecf1c8",
   "Duo3",	"a6b7bd78b8faf3fece57d8a6d6a3f3c5e063",
   "Duo4",	"a8efa946bc5ab46bb2ebb8f6bfe2e54fe56dcefbcf4fd0c3d0c6",
   "E",		"a3ad",
   "E1",	"b0fed4f3cea3decbe0b3ebe8",
   "E2",	"ae40ae5aae6fb8bfb35fc342c35aca78caa7cce2d269d678dab8dac1dacbd76de8e2cdd2",
   "E4",	"ab58a4cca763beb5b0eeb463b46aa7e3b8b0b36db94bb66bc345be6ac673ce4bdce1d8a5d8aecac3d8dee968dd7edda6f459cfeed369d3c4e3e1b8e3eba7dc47c1eef8ccec46cbaee8b6ec5ff5a7f8eddbe5",
   "Eh",	"a3ae",
   "Eh4",	"e44d",
   "Ei",	"a3b0",
   "En",	"a3b4",
   "En1",	"b6e2aea6",
   "En4",	"ddae",
   "Eng",	"a3b6",
   "Er",	"a3b7",
   "Er2",	"a8e0a6d3cbcad4a2d1e6efdfcfa5d053db46d36bd3b4e077d0c4ef6cef7b",
   "Er3",	"ac7cbab8a6d5c2e2bbe7c974d1f0d2adf0b9ec62cea9",
   "Er4",	"a447b64ccbb9cbd0cdfbe9c2d1fdd6acdbc0e47a",
   "F",		"a377",
   "Fa1",	"a5efb56fccf7e2e5",
   "Fa2",	"a546af7cb5adbb40bbd6d2cad3abf0b2",
   "Fa3",	"aa6bbe76",
   "Fa4",	"b557",
   "Fan1",	"b566c2bde0fee560bc6eefd9cb47d6daf5e5c2baf35af85d",
   "Fan2",	"a45aa67cbcd4b7d0c473c163bfbbc3bfe144bc5ccf5fe9dcf463ea4fea64cda8f079eaeeedf8f5fcf645f353b3abf4f6f3abf873f268",
   "Fan3",	"a4cfaaf0e8e3d7e1",
   "Fan4",	"b1eba5c6aa78a5c7bd64ad53b363b6bac9d2e955a6c6e2b3cfdbd6cbd3e9dc4ae46f",
   "Fang1",	"a77ba4e8aa44aadac943cb4bd642cba8dc62",
   "Fang2",	"a7aba9d0aad5a8bee8db",
   "Fang3",	"a5e9adc0a7cfafbcafe9b358ccc4cfd7e4dbf6c4",
   "Fang4",	"a9f1",
   "Fei1",	"b0d8a66db476b5e1c050ab44adb8d4dae36ee3f2e3fdef57f1b4f3b9f3d6",
   "Fei2",	"aaced5f3b5ccdb78e3f3dc53f0bc",
   "Fei3",	"adeab4b4bb42d4cdd55ecef9d9c6e249eabdbddaef4b",
   "Fei4",	"a770bc6faa6db7f3aacdb64fd0d5d0ebd0efb151ceede9b6f24deff7cd61d2c8ed75d2e2d057aae8efb3",
   "Fen1",	"a4c0a768aa5eafc9aae2ccd0b4d9cfefd364d3d8d7f4dc77dca8f556e8ec",
   "Fen2",	"bc58a857b549cab7e56eccded5cfd9c8e9c3e5fdcd5acd6acffdd362e3cbeafdd3c7f346f356e8dff874f1e3efb4cad2",
   "Fen3",	"afbbf078ecb6",
   "Fen4",	"a5f7bec4a9c1bcabc154e0f3caaef45c",
   "Feng1",	"abcaae70b7acb26cbac6b8c1bfd8c2d7be57adb7a4a5d467cab2d8efd1cbd5d1ed4af5d3dea9dfb1f747f65af9b0f9cbda76",
   "Feng2",	"c15fb37bb6bed8b0cab0e1eada49dfa7",
   "Feng3",	"d477d7c5",
   "Feng4",	"adc4a95ebbf1ebb4da63",
   "Fo2",	"a6f2cbf3",
   "Fou2",	"dcc8d352",
   "Fou3",	"a75fa6ced9e1d26faae6e8ea",
   "Fu1",	"a5eda4d2b9e5bcc5bda7bea2d169cecdcf52cf53ccfdcfeadad8df66db40d760d3d1b36cdbfacbaae469b679e8e5cc54eaca",
   "Fu2",	"a5f1ab52b0cba7b7b454a5b1a9bba7dfa9d8aa41ac74af42bad6b2c5b2d1bfa3aadcbdbbb5f6bfe7ca6bca6ccbe0ce59cc66cc6da9ccccd5cf47d5bed9d2cf7bb265e651d64ecfd5d679d6cfe35bb2d9df5ad04ddfa6d758d070d07bd3acd767b5e8dfb6d77bd3badfecebbed3fae4cae0edeca7f3e8f57ad6fbebadd2ea",
   "Fu3",	"adc1a9b2bcbea9f2a86ab2e3b5c6bb47bbb2b079e546cc72ccb9ddc4de58f064b340dff0d3f4be66f1c4f3f5d3c5",
   "Fu4",	"a549b3c5b0c6a94ab0fcb449b45fa4f7b8a1bdc6c2d0ad72ad74bde1ad75aafaaafec34cbe74d45ecae4e246d2e6d6f0d062dfcaeb50d7a7dbbde7b9e7b8e7c4c1ccebcdeed9ec7bf56eefb0ce60",
   "G",		"a37c",
   "Ga1",	"b9c7",
   "Ga2",	"bebf",
   "Ga4",	"a7bc",
   "Gai1",	"b8d3b8f0abb2ce79dad2d36ad375e055d0c2e0d3",
   "Gai3",	"a7ef",
   "Gai4",	"a4a2b7a7b540bb5cb674dd76e05bf047",
   "Gan1",	"b0aea958c0aaa47aac61a5ccaf69acf1a878cbdda7fdccf4cb68cd7adf51d0a6e3e0e4e2d8f1",
   "Gan3",	"b750b4b1b1ecbef1b57abbb0e641f9a2cd75cd78d3e3",
   "Gan4",	"b746c642caf8ba6dd647b268f2a8d6e6dbe3e0e8",
   "Gang1",	"ade8a9a3baf5acfba87abffbd4b6dcefb15ea7fed9bbda6bdeefd2fed35cd069b3aa",
   "Gang3",	"b4e4",
   "Gang4",	"ba62",
   "Gao1",	"b841bf74bf7cafccbb49b0aae252f253af6fe2e9f6ce",
   "Gao3",	"b764ba60bd5ae1f7aa58efe2df52bfa5",
   "Gao4",	"a769bba2de7bdad5d3fce870",
   "Ge1",	"b3ceadf4a4e0c0c1ba71aab8afdec246d9fdde4fcfb7cb76c2f0e4e5",
   "Ge2",	"aee6bb4abbd5b96aadb2c066cbccdcd0dcedd943cedde1eeea5cd3a8e040ebcbf4ddada8e8b4be67ef75f87d",
   "Ge3",	"b8afd0f8e9a5d6cdd753",
   "Ge4",	"add3a655bbccbae7d0a8",
   "Gei3",	"b5b9",
   "Gen1",	"aedab8f2cbd3",
   "Gen2",	"cdfe",
   "Gen4",	"a5e5a6e1d3a3",
   "Geng1",	"a9b0b865c3bcafd1d958d24ee6e5dba9bde9f3da",
   "Geng3",	"ae47b1f0afd5ae43d1c4df58d3f3ef64f1c7",
   "Geng4",	"a7f3d87d",
   "Gong1",	"a8d1a4bda55cae63a475a47daea5a7f0aad0b047b060c5c7d863dce3dd70cd74eac2dffde4e1dd5a",
   "Gong3",	"abfda845be64a47bd1b1d1e2d2acf4a3dbbb",
   "Gong4",	"a640b05ed050",
   "Gou1",	"a4c4b7beb95fccdbeabae6edeae6cdc5f3a4",
   "Gou3",	"ac65aaafad65cc63d6d6d051d3add7ad",
   "Gou4",	"abafb0f7b6fcba63b8e1c1cabbb8d855d0e0ce6cdd62b770ee7ab96f",
   "Gu1",	"a6f4a942a968a974aa66b5ddb347b664b957c06cc95acf54e9c6cd40decce354e356d360dba3dbd4dc49dc5ee0ccec7ee555",
   "Gu2",	"f6bc",
   "Gu3",	"a56aacbac2a2bd5cafcbaad1c5dbb5fea8a6c1d4b0a9b9aad146e14cdd4cdd6bc9e8cb46e242d5eced58eff0cd60f053d361edeae3c3d7aaead3edfa",
   "Gu4",	"b9b5a954ac47b6b1c555d0e3d4c7d544d5c0d9cfe24cd65fc044defa",
   "Gua1",	"a8eda94bac41a5cabdbdbe68e141efcfd1ebe2dedae1e6eab5c1d067dfa2dfb2d3ecf3bcef7ee061",
   "Gua3",	"b9e8d46c",
   "Gua4",	"a8f6b1bebb6fac45daeed6f1df68e047ec6f",
   "Guai1",	"a8c4",
   "Guai3",	"a9e4ac62cf5e",
   "Guai4",	"a9c7c95be973f24af04d",
   "Guan1",	"adbea978b4c3c65bc3f6c560c960e6b2f8da",
   "Guan3",	"badec05db55fdec7df46d745ebdd",
   "Guan4",	"ab61ba44c4e9bf64c5f8b365c963d8f9d556e1e8d5e1f6edf6f0f7ebdef3f975f171c67cf9ca",
   "Guang1",	"a5faafd6ce5baca9cd59d27cd2aed3a4e4b4",
   "Guang3",	"bc73c278",
   "Guang4",	"b37dd1e9edefdb52",
   "Gui1",	"a663c26bbac0acd4b357bbd3c074d8b5e174e1f0e5e4e5e2d9ecaf5ed6cad0b8c244",
   "Gui3",	"acd1b8dead79b0adcbc1d46fe146ce56ce69c973d177b4bec9a3d6bfedc2dbb9e7a5dffe",
   "Gui4",	"aedbc264b651b8f7e4f3e56bcccbde60cd50dae4f2efe5c5",
   "Gun3",	"ba75b34fd5a5e36ce752c358",
   "Gun4",	"b4d2ed6b",
   "Guo1",	"c1b4b3a2c1e7e14fb3fae162d4f4e9f1",
   "Guo2",	"b0eab9f6ba51e1d5e2b6edc4e3a2e741e77eef55",
   "Guo3",	"aa47bccdb274bb71d55dd5fee35fe3e2e84bf665",
   "Guo4",	"b94c",
   "H",		"a37e",
   "Ha1",	"aba2",
   "Ha2",	"b5f0",
   "Hai1",	"b6d9cbe8",
   "Hai2",	"abc4c065e8b8",
   "Hai3",	"aefcd657eec6",
   "Hai4",	"a5e8ae60aef3c062dccde4cf",
   "Han1",	"b346b66fc24dd0fde977dec3e450dcaceca1e17b",
   "Han2",	"a8e7a774b448b25bc1fad5c2d672ca52cdd5e8a2cdad",
   "Han3",	"b3dbb26ba875c944e755f344f7a6",
   "Han4",	"aeabbed1bed9a7f2a6bdba7ec376bfabc058d141c9e4aec2f246d5a9e5c3d254d5f6e663dabedb72e3e7eb5ff2f9d3e0d7f7be5ad846f170ef46e0e4ef5fe875",
   "Hang1",	"c971",
   "Hang2",	"a75caa43afe8cdaccdb3d3b9cdcce0dee8daccc3d7d2",
   "Hang3",	"d3fecb5c",
   "Hang4",	"a859",
   "Hao1",	"bb55ecc3ee51",
   "Hao2",	"b6e7c07ac0a2b240c0dac4aebba8f4a9e7dacdf3f64d",
   "Hao3",	"a66eb071",
   "Hao4",	"af45b571afd3b8b9d144d1aea9fed5fdde45e650f8afe6b8e6bacffbedf3b952c2eec556f6aacef0",
   "He1",	"a8feb3dcceabb646",
   "He2",	"a6f3a8f0a658a94dac54aed6aa65b255af72b2b0a5ddacf8b2fcb348bdc5b8e8bbd2bbd7c2f3cc51dd5dddfede4ee2c2d2ccf05aeabbbfaddb5de3bbe7b2eb5bf2f2e0caf17bef50ec7df5a6f1eaf7cfcbd9dde7",
   "He4",	"b650bbaec562cbcbdccab77be2baeae4de77",
   "Hei1",	"bc4bb6c2e648",
   "Hen2",	"b2aacedae8b2",
   "Hen3",	"abdcacbd",
   "Hen4",	"abeb",
   "Heng1",	"a6ebadf3d750ebb0",
   "Heng2",	"abedbeeebfc5cbbcce64d968aeecddf3d2b2f4c1e44bf76d",
   "Heng4",	"d4a6e65adafb",
   "Hong1",	"af4dc546caa1ce46d96eda48c1a9d0b1e7e5ebceeeeada60",
   "Hong2",	"a7bba5b0aa6cac78acf5ad69b052c245c966c9cee974cb52d247da43cb5ecb6cd041dadde6ddd354d363d367db58dfd2e044d7cde052dc72e862b6a3eef8e4c2c664d07d",
   "Hong3",	"aba1dccf",
   "Hong4",	"c069e5feedfbeeed",
   "Hou2",	"ab4ab3efb555e2dfbd6ae6f5e4a5eedbef53f56ff3f8dfdf",
   "Hou3",	"a771",
   "Hou4",	"add4ab70a65aabe1b06dce5eb3fbcfacdafdd0bfdc5ac64d",
   "Hu1",	"a547a949a9bfb1abca76d47dcbf9e1a1ce7ae570ccc7ccd1d9dbe5f0e2a3d652ca4fd77cc9c1",
   "Hu2",	"b3fda9b7b4f2aab0b7e4bd6bad4ab8acbdb9c447c35be152a77ad8c8caecddacb1d8e5daf260d656da70ead1eb6de7c1ee7debd9ef4de8dcf574f57cddedf5af",
   "Hu3",	"b0e4b55baaeae271",
   "Hu4",	"a4aca4e1b1afbaadb27dc540c9bcd4d7e16ce171cc5ecc7cccb2ccc8cce1b7b1e5eea85be668d2e9d343f0e2e46af851df63e77aeeb2",
   "Hua1",	"bc4daae1ebfbf872",
   "Hua2",	"a645b7c6b7e2b5d8c3cfd4f5eb62d840f4f3f77e",
   "Hua3",	"f749",
   "Hua4",	"b9baa4c6beecb565b8dce554e55fe1e3cce7e5d4f070dffce645",
   "Huai2",	"abdec368ba69b261bdefcbbff454f266eb76eb77",
   "Huai4",	"c361ce45d165f7f6f7f2e7e4",
   "Huan1",	"c577f5cccb61f5ddf94ef65bf9c2e8ee",
   "Huan2",	"aed9c0f4c1d9c1ecbec8e97cd1b3aca7bf4acfc2f8b2f2b4df6ccb77d37bdb7beeb3e058f660f66cf855",
   "Huan3",	"bd77dabae464",
   "Huan4",	"b3eaabb7abc6a4dbb177b4abb541b7d8bac8b8e6d152e9a6e2a1debdf4dedc4d",
   "Huang1",	"b757a877afeeefbec9dad0aa",
   "Huang2",	"b0c4b461b471b7d7bf58acd3c144bd68c2aebdc0b94eb6aab6c0d45dd874d8b1d8ced8eee5b2b547e643ea49edb5e74adfcdf0c1f34ceedac341ef52f3bff576f86fe67d",
   "Huang3",	"b745abe9aeccc1c0cca4e261de53e2bde6b9f167",
   "Huang4",	"dc41",
   "Hui1",	"c0b2abecb4a7b775a6c7b8d9bdf7bea3d95acfa4de6be341e6f8e7c7d3dfe0d2f16ff7b3d86bcee5f773",
   "Hui2",	"a65eaff5b5eeb06acec8cf77d6a4d3ca",
   "Hui3",	"aeacb7b4c0eca6e4ecfde9e5d274d06aad6bf4d5",
   "Hui4",	"b6d7a563b16bb74ab466bc7ab1e2b77cc0edc2a9c3b8bfb7bba3bfd0b8ecb3f1e14ae549e55edd5fd17de5a2e5cde9d8e659e9f4ea5bed6ef055edbcf06ef072f2bee756ee50eb6af0c0f2faf75bf4fcf668f546f677",
   "Hun1",	"b142a9fcb8a7d55fd9d5d9e0d5f7e2e8ec4ededf",
   "Hun2",	"b4fdb7e9c05fbbeed9d0ddccf1a8ef4cf7cbedd7f149",
   "Hun3",	"b256dee0",
   "Hun4",	"d0dcd149e1c4de54e449eba1be40",
   "Huo2",	"aca1cbc3dfaadc64",
   "Huo3",	"a5ebb9d9a4f5",
   "Huo4",	"c0a4b462a9cec0f2bad7c3acc1c5b366c04edcd1ecc4d1c5d56ec0c3f245f452efe6cb5dda46c0e2f25ff043d2d0f5e0f27ccff1d6baf4b3f4b9f4c9eea5f769f174f37af8cff84ff3bee576f07e",
   "J",		"a3a1",
   "Ji1",	"a5e4a44cbc54b0f2ae56ae6abef7bf45b551bf59b7eec146bd5dbf6ebadfc15ac5f9a6d9c3d5b8f1c2fbb0a7c4c8c946b6d6c95cb452c9f3ccd3e5e3efdde26abd42edb0def8d340edcef744f7f1cdcadbb5e7d1e7dfc2ddc545e4aef4f8f76ceef4f670f7acf963f6d2f87e",
   "Ji2",	"ab45a759a4cea64eae41b6fab149a7c4abe6b761c0bbb4c6b7a5b7aaa856af65bd43c479afc5afe1bfe8b6b0a5f9cbb8d464dce7e94fce63d548cad5cadfcce5e1feddfbcfa1da53e26fe64fe9efcfbfd344e3a1e3a9cdbfd76ee3b0e758eb40ee44f0d3e7faeebdf4dfdc6be4aff542f66eef79f6c0f8e7e969eb5ce8b1d14bdfe9",
   "Ji3",	"a476b458b475c0bdb9a8c950d0e9cacdd571ccfeedb3f0cae7fdf7a9",
   "Ji4",	"beacbeafa7b2a975b148a7d2b1aaa7deac4aba5bc0d9b2bdbd5eacf6c47ec1bbad70b04fbbdac5b4c66bc067c356c9abc9beecc1d8a7d8fcf241c95eed40acade2b8f460f044ded3e2dbf278ea78eaaff2a6ede4db53aae7dfbdc1aaf5f9f7f5dff7e44ce45be4ddef72f3d7f7b6f570f95cf1e9e345f1d4",
   "Jia1",	"a8ceb3c3a55bb9c5ae61b350ad7bdd58cf45cd4adea6cfc9af6dd6d2d740b8b5bfdeebb1dbf6f153ecacf5b3cf6ada72",
   "Jia2",	"a7a8b1aeb2f3c055d140d17ccaf6d5b3af48d6b3d755dfe6dbcbdff8e071d3f7e4a6e868e4c4e8b3f1d2",
   "Jia3",	"b0b2a5d2ad4bb8ebb95bd8cacc61d8f5d97addd9e248ecf8cfd2e2dd",
   "Jia4",	"bbf9b6f9ac5bbd5bbe72c9b2",
   "Jian1",	"adddb0eda66cabc1a679c4e8b4e6b7cebacabae0bd70bfa1aad3c17db5d5b6a1c9dbccb1d959ddb8ddecf5cff462e66cea4ada66dea5f27ef6fddba2dfd1e3b6eb46f8bcd7cfdc65f954dca9f179c669ef49ef54f3b7f3c2f6abf7aee8e6f3eaf6b4d55ad668",
   "Jian3",	"bbfcb0c5b47abedfac5ac0cbb4eec2b2c3b5c650a65fd8acd8d2e1d6d1c9da51c2a5b863e6f9f0a5f949eeaaf756d7d6eebff575ddc1deb9",
   "Jian4",	"a5f3b0b7b9b0bc43abd8c265b7b7baa5bceec271bd62b878c4a5aff2a8a3bfcfbde2bdeec1e4c5b3c5b2c05ed0d0dd5ed1e5ddd4e25dcf74f468cfbdd2b6e6e2e75ec2cbee5ef0d9e7d7ec44f572ed7d",
   "Jiang1",	"bbf8abb8a6bfbcdfc3a6c1a4c5b7ed45ed4cf058d373ee6cd3decd6fe37e",
   "Jiang3",	"bcd5bcfabdb1c1bfe743ee75f3a7",
   "Jiang4",	"a64bb14ec2e6adb0e1b0d54ccf7aedcfb5bcf0ecdbc9",
   "Jiao1",	"a5e6abbbbc62b4d4bce5b54ac147bda6bfbcb5ebada5c5bac242e153e5a9e9a1ea4eedb6eaf1d374ee64f0c8b8e5b8f8f4f7f860ef77f6c7f86bf86a",
   "Jiao3",	"b9aeb6cfb6d3c5cdacbeb2aec142b5b1b87da8a4bbc7bbe5cbb3e4efe4f2d1bfe1f3e5b9e9b0ecf2e2aef7e5f051dadec3baf0c6f340dea2",
   "Jiao4",	"a573b1d0b5a2b8fbc3e2e150e943e569e975ced5e1f5de5de64ed2abf6f5d2faf4d3c3e7f8c9e956",
   "Jie1",	"b0bab6d8b1b5b4a6acd2b5f3b6a5efc4d9acd9f4debad6c5db61ee4ee7a8f57e",
   "Jie2",	"b3c7a754a46dba49abfab1b6aa4eaedcaee5c0cdbce4b7fbbadcb860b5b2bd7eb050b8d7be65d0ccd455cbd5cdfcd4d0cac6d4fadd50e96ee9add1efdde5dddae251de66e9f6ca44f04bbad4f9a7d3d6dbc3e05fe7f8d3f0e0c5eee6f543f3c0ef6acccd",
   "Jie3",	"a96aa96eb8d1ecfb",
   "Jie4",	"a4b6adc9a9a1a7d9acc9acceaae3c2c7bb7ccaa5d47ad86ecac9d1a3e2c7cd6bcff0d358f2b6d3c8eb7af950",
   "Jin1",	"a4b5a479a4e7ac7aace1b5acc3ccaaf7d156e56ad2b4e2d3dad4d357db7ed3d7ad6fd564",
   "Jin3",	"b6c8bea8baf2c2d4c041d4bbe158ceafe1cbe5d3e5f2bd40db6ac444",
   "Jin4",	"ab6cbeb6aecaaefbbac9b854c2d1aaf1b669e4e9ecc2cab5ecd3dd48e1b6dda8ed53c275ea68f045ea6ebfa7cdafe763f0b0ebb5f652e0dac9bbcce3de61",
   "Jing1",	"a8cab9b8b1dcb4b9aef9b7fabaebb867aff0b2f4b5d7c5e5c448d4e1cacad5a8e352f1d3f3d9f3dbf8e8f5b4f6d1",
   "Jing3",	"a4abbca9b4bac4b5a8c0c056c964e4eacdf0caa8ece1e9bad64cbf5bed6df2e4ea58",
   "Jing4",	"b9d2ae7cb771b262b56ac476b377c3e8b974c052b3bacddfd0c8d0e4d4d1e9a7d5c8e2cbdf45d748dfbce8b0",
   "Jiong1",	"cbf7ced3e8cc",
   "Jiong3",	"acb3b57ead7eca6ae571ccf9cd52dea3e662e6bbd6e7edd4eb75",
   "Jiu1",	"b3eeb4aaaac8b9a7c956d96add79c9f2e5d6da47ca42dbaed0aff147f9c4",
   "Jiu3",	"a45ba445a862a868ad76b073adb4",
   "Jiu4",	"a953b44eb1cfac5eaab9a873a6ddb8a4c2c2e0f0b45ce5aad1b5f3ccf86cf3f2",
   "Ju1",	"a97ea9ebaa71aaaeaf6abe73d4d4d4f9d9b9d5fadaa1d35fdb4cd075db5edfc6e3fadbede0d5eca2f3e1e3dee7fc",
   "Ju2",	"a7bdb1c5beefb5e2bbb1c1f9ab5dcbd6d1b7d5b6d9bed644dea7cfbee35cf5f6e7f0e842e07bdc56e876f17cf9b5bea1f1d5f3e5f5a4f7cae8a9ef5ed64b",
   "Ju3",	"a943af78c17cb2f7c4d4ca5ccf40d9bcf5d1d2fddf4ce3afe7b7d7c3dbf8ebc4",
   "Ju4",	"add0add1a8e3bc40a579a5a8c4dfa9dabedaacb2bb45ad55b65ac1d8bff7c1fcd4c5cc4ee17ec0abcc5de7b4cca5d575ccfbe9f2d2eeeab2d6ded6ebd6fee3d4d77edbd6f0f2bdf5f4d7f4e4b964f65fe8c8e94bda5e",
   "Juan1",	"ae53aebdaefec359d5afd74ff7f8c54fdff9",
   "Juan3",	"b1b2d4afededdb64",
   "Juan4",	"adc2a8f7af58b2b2b868ceb2d1a6ea5ddabfdedadafedc52ebdfe8b5ec72",
   "Jue1",	"e4fee5b1",
   "Jue2",	"adcfb3d6bebbc45aa46eb155a7e0b1b8c5cca84dc0efbcfbaab2b5b4bfb9c4b1b35ac3d4c3ddc5edd852e0f6b9bbefc2d8e0f7d8e57cf7dbd1c2d5c1e9c8e644d654f5daf7e9cd69e6b5f477ede9cdb8eb54d3c0f0d0f96ed7c6c5a9d7cef9aad7d3d7d8f9abdc69f4f2f9c1f85af86ed5de",
   "Jun1",	"a767a7a1ad78b676cbf0d5c9e2e1d764d3cdd3d5ec59f1cbecb1deea",
   "Jun3",	"e3e4",
   "Jun4",	"ab54ae6daf43c0e0b5a4b5dfb070b96dc240caa3e95dd1b8d5acd64dd673daade359dfcee76ae8c5f1dc",
   "K",		"a37d",
   "Ka1",	"a940",
   "Ka3",	"a564ca61",
   "Ka4",	"b3d8f3c1",
   "Kai1",	"b47bb67dcbb4d67c",
   "Kai3",	"b3cdb3cfb7a2dce5b75fe1f8e074eed2f15af16df3ac",
   "Kai4",	"b46eb75ad46ed1f5d271",
   "Kan1",	"a55ab0c9b3f4b760d8dcf7ce",
   "Kan3",	"a8d4a7a2ae72ace5d4b9d9dcddfaefe8f4dcf1a9",
   "Kan4",	"acddc0fde165f8f9eaa9d0abf545f4a5",
   "Kang1",	"b164ba42c152e274f36ee179",
   "Kang2",	"a6aa",
   "Kang4",	"a5eaa7dcaaa1a4aec9c2caa9cb66cba7dc70dc7a",
   "Kao1",	"c975",
   "Kao2",	"caf7",
   "Kao3",	"abfeaf4ea6d2d1dcedf6cfa2",
   "Kao4",	"bab9be52be61",
   "Ke1",	"ac5fb4cabd4fbd57acecb85ead56bdc1b661c1fbcea4e5efcfc8b85cf2acee48c34edea8",
   "Ke2",	"ab79b4df",
   "Ke3",	"a569a956b4f7d4c6cc65e95fd975",
   "Ke4",	"a74aa8e8ab67b6dfabc8abf1b7c2bdd2cdf2cbd8dda4e245d5dfbd79f1b2",
   "Ken3",	"b0d9bec1c0b5aad6e056ebfaf3fb",
   "Ken4",	"d576d6b6dbcf",
   "Keng1",	"a77cc3f4d15bd65edac8def2e8a1a8c2eee8",
   "Kong1",	"adc3b153aac5d554d5e3b851e34febf2",
   "Kong3",	"a4d5aea3",
   "Kong4",	"b1b1eefc",
   "Kou1",	"e1bee1e0cdc3d7bc",
   "Kou3",	"a466",
   "Kou4",	"a746a56eb146a6a9b3a7ccaae26edae5edcae74df6b6e6be",
   "Ku1",	"adfaac5cb85dbe75d4b3ced8d1f1d05cdbf2f3a9",
   "Ku2",	"cbd2",
   "Ku3",	"ad57",
   "Ku4",	"ae77bfc7bbc5f441e2e0cd7dd3e7",
   "Kua1",	"a66ab8d8ce66d3a1",
   "Kua3",	"abb1cbbae4b3ebe9",
   "Kua4",	"b8f3afe3ec6d",
   "Kuai1",	"ce4ad87b",
   "Kuai3",	"e3c7",
   "Kuai4",	"bbfbb6f4a7d6c0ccb85fc17abc44e944e9f8ea61f05febd7e4d3f856f8dbd5d7",
   "Kuan1",	"bc65f2c1c662",
   "Kuan3",	"b4dab1fbedb7",
   "Kuang1",	"a64ab5a8a8f1cec6cf6fe046",
   "Kuang2",	"a867bba5f1db",
   "Kuang3",	"cdea",
   "Kuang4",	"c252c36daed8aa70b2b5c471efc9f269daeff5e7dbe8f14bf474",
   "Kui1",	"b2afbf73c1abcbd1f5c9d1a7d378f0b1f74aeee5f377cea1",
   "Kui2",	"c4dcabb6b47dbaccb8aab666bbeddd74ddc0ddefddeeefe1d9f9f8f7e6fcf9bedc55ec5ad850f3b8",
   "Kui3",	"b3c8de79e069f0fce0df",
   "Kui4",	"b9bcb3e7b75cbcecc2b1c34ae542dcfbe5a6e5b7e5ebe9cced7ef07ceb44f4f4f558f560e76c",
   "Kun1",	"a95bb158a9f8d563d5adb54fd663b562db74e7c3c043f1b1b9a6f3cb",
   "Kun3",	"aeb9b1eeb869dcf2d1a8df40e8a7dacadff3f7cd",
   "Kun4",	"a778b574d265",
   "Kuo3",	"e9ab",
   "Kuo4",	"b9f8c258c1efce62e272b5f2f54a",
   "L",		"a37b",
   "La1",	"b0d5a9d4cf58d6f7db69",
   "La2",	"c3e5c9ed",
   "La3",	"b3e2f2d9",
   "La4",	"ab66c3bec4fabbb6ddebe2dcdb4bf84ef3c4ddb7",
   "Lai2",	"a8d3b5dcd4fbd54ab174d9b7d5e9e35dd7ecebe4f1b0f3c9f3e0",
   "Lai3",	"d4a8e949",
   "Lai4",	"c375c4eeb7fdc5a3bfe0d15ff4bbe7ec",
   "Lan2",	"b0fdb450c464c4e6c469c478c2c5c4f5c4b0c1f1d559c4e3f8f3f5d9f8aec5d3f9a4f7fcf8c2f8c6",
   "Lan3",	"c369c5f3c656c4fdf1fbf8b0e85ff958d25ff8f6",
   "Lan4",	"c0ddc4eac66ceccceff9f953",
   "Lang2",	"b459b77daf54b277b7e3bdb8ada6cdddd5b0dad6df47d75bdfe2e457e863d1f9",
   "Lang3",	"aed4d171d648dac5e44ee8a6",
   "Lang4",	"aef6d14ae3ac",
   "Lao1",	"bcb4e563",
   "Lao2",	"b3d2bc47a863c0f7e0f2d248f062f0bbf152f4f9",
   "Lao3",	"a8d0abbea6d1ce4ccec4d1dde9c9cfc1f357e47b",
   "Lao4",	"e16fe9d4e5fcf355",
   "Le4",	"b0c7a955bcd6a6d8c952d142d14dc97dd1bbc9a4ccf8d2e3cda7c9aaf7af",
   "Le5",	"a446",
   "Lei2",	"b9e3beddc15dc3bdc54ab970f7d2ed44f8f2f276e6aef5ecf5edf74bf945f641",
   "Lei3",	"c077c253bd55a6d4c1a2e5eaf24ff254f5d8e6b4f04feaa4f47cdaf5f2d2e04cf757f764f973e8bcf97c",
   "Lei4",	"b25cb2d6c3fef7d0f057f47bf8b6f5e8f7f4e474e4b6",
   "Leng2",	"b7abb857d0cdd4f7d9b1ee55",
   "Leng3",	"a74e",
   "Leng4",	"b468e844",
   "Li1",	"adf9",
   "Li2",	"b3edb1f9af40ba76b270bcf9af57b27cbcfec658bfa9bba9c2e7c2f7c67abea4dcc6f7d1cdf9e175f6dbe17df6dff6e0d5bce5cbe5f8e5faf6e8edccd34eedd0eb49f2d4f7f0b8c4ee71f0dbf14ef678f3d1f9cef3eef9cff5b6db7af84d",
   "Li3",	"ab5aae5ba7f5bf43b27ac2a7c4f9b8ccc5dda8bdc355ce7ef8f4df55e054c4bfbe59f8d7",
   "Li4",	"a8d2ab57c4d7a751a44fc079bc46a64fb0e6c363b758a9d1bee4aedfbefac377b567c27ec472c474a5dfb2c1b2c9afefb2fabb59c4f7c1f5c645b0acc452d864a57bd145f1f2c976cc6cd560f6e2f8a9f248c9f1d1e4f252f455c5cfcd42b7cceff2f272d2aae2d4f274f471f473cfedd2daf056f4a1d2f5df53eabcf5e6e374d06bf4bed7a9e3eff646dbe0d0b2f760f765f848c5b0e0c7f9adef67f979f978eca4f6baf7bef6caefb9dceeddb9f24be7a4f843",
   "Lian2",	"b9dda9a9b747bca6baa7befcc3aec170bdacb373c549c5bfdcb6e155f6dae5d1de49e6a3e6c2ede0ede5edf7f2e7ee72e443f0def4d4f0fdf14cf154f569",
   "Lian3",	"c179e1f1f2bdeae9ee56",
   "Lian4",	"c5cac0c4c0d4b7d2bd6dc1e5c3ecb7afed4bd259d9efea46c46bdfb5f5fdf2f0d8a9",
   "Liang2",	"b1e7b244b864c2b3a87dd561d9cabcd9e378e847ef59",
   "Liang3",	"adc7a8e2d479e379e3f8c352",
   "Liang4",	"ab47bdccbdf8b671d867d1a2b4bdda4e",
   "Liao2",	"b9b1bc49b9e9bc64bcbabce3c0f8c2b7b2e1bff1e556efc3e1a7e56ce1cce1e5e5bfe27be679eab6f067e3aaeaedf0c2f0eef4eff553f673f7baf863f551",
   "Liao3",	"c141e5a4bee9e764e46df376",
   "Liao4",	"b9f9aec6bf52c9d5cd53",
   "Lie1",	"aba8",
   "Lie4",	"a8e6a643a648b1caac7baf50c279b5f5ecbdce75efd4f271dee1d74ad37edbb6dfeee064f761d3eae8bec663ef71efa5",
   "Lin2",	"aa4cb24fbf4db559c143c17bc3e1bfeebe46c04dc5ecc5efdcb1e562e9b9e5fbbf5aed6fed73ed7adee8e353e360e36af076df69f4e9f778f442b7f7",
   "Lin3",	"bbfebecfe0fce96fecf5dbab",
   "Lin4",	"a75bc4a9c66ee9c0da65f350ec4d",
   "Ling1",	"a9f0",
   "Ling2",	"a744ade2acc2baf0b2dcb2deb2e2ad64b5d9b961b3aeb973c646c06fc4d6cbe5cbefcbf1cc41cc42cc52cc64ccb0ac53cf61c4e7f9bbaa7ed5e6e9fbcd65d676d2bed2cbdedcd2e5d6d8d757bdb7f5f3b34de441dbdedc46e849f4e1f8c8ebf6eefaf3c7f9bcee53e8cd",
   "Ling3",	"c0adbbe2cc76",
   "Ling4",	"a54fa574cfb6",
   "Liu1",	"b7c8",
   "Liu2",	"bc42ba68ac79c273af5baf64bd46b2b8dd46dd55efcdd97ef2d6ee62dbc4bbbfeedcf15ef365f675f561f6b1f6bfefacdfd4",
   "Liu3",	"ac68efc1e371e6f1b967e0e3cfd6",
   "Liu4",	"a4bbc348cbfddd61d6fcf379c2fcdce8",
   "Long2",	"c456c467c46ec4efc5a2c5a4b6a9c073f1fdf450f453f25ded74f5e2c14bf2a9f4b8f750f752f844f846f375f8cbf8d0f9b8",
   "Long3",	"c362c36cc3f7efb7",
   "Long4",	"d0f1f240d5b1dbc1",
   "Lou1",	"ea79",
   "Lou2",	"b9c6b0fabcd3c1b2c55cdcbce1bde66eede7edf0e76ff0e4f54bf7bd",
   "Lou3",	"ba4fc14de15ce1a8",
   "Lou4",	"ba7cc3f3adaebf62",
   "Lu1",	"c250",
   "Lu2",	"c366c46cbf63c4a4c4aac660c674f1f3f1f6f247f456c379d66af6fef742f743f746f74ff847c644f9b7f275",
   "Lu3",	"bedbc372b8b8be7cefd7bab1eaadf2c5e769f373f666b3bf",
   "Lu4",	"bcaeb4e2b84cb853b8efb8f4bffdb3b0c553c64fb3c0c453b6cece5ae1b5cc74e1dcd5f1e275e9f0e66adaa3ed69ca46ded7deded6b5eaacdef7bf72edbbf6fcdb77e753ee46ee5cf755e7f9e078f146dc4fe85eebf5f370f1b3f3d4f3ddf0fa",
   "Lu:2",	"c371be5bc66ae1cfe5f6e742f2d1",
   "Lu:3",	"ab51a766b9f0bc69aec8c15cc1b9be54ecbbcee2d5cde27ef4a4df65bb4dd3f9d6c0",
   "Lu:4",	"abdfbc7bc26fbaf1ecbfd8e9e6fedfd0f84a",
   "Luan2",	"c572c665c671c67df96bf7dff7e1f9ccf8baf943",
   "Luan3",	"a75a",
   "Luan4",	"b6c3ee4a",
   "Luan:2",	"c570c5cb",
   "Luan:3",	"f6dc",
   "Lue:4",	"b1b0b2a4e1e6efd3e86e",
   "Lun2",	"a8daaddbb15bb1c1b25fbafabdfcd4acd565de6adba1e3eee846ec43d84b",
   "Lun3",	"df41",
   "Lun4",	"bdd7def1",
   "Lun:4",	"daec",
   "Luo1",	"c56f",
   "Luo2",	"c57ac659c3b9c5dac1b3c5dec3f1c672c55bc4d8e1e7f7e2f25be76df2f4f8e3",
   "Luo3",	"bb72ea73d2dbf5f0e3ccf2dd",
   "Luo4",	"aba3aca5af4fbabab5b8b8a8b954c064eff6af5fd6b8f942dbcabbdcef70efa1ceaa",
   "M",		"a376",
   "Ma1",	"b6fdc0a8",
   "Ma2",	"b9c0b7f2c1b0b3c2e673",
   "Ma3",	"babfbd58bfc2b0a8e14dde62f156f6c5",
   "Ma4",	"bd7cd858e259e6cc",
   "Ma5",	"b6dc",
   "Mai2",	"ae49c5b5f0b4",
   "Mai3",	"b652e547f868",
   "Mai4",	"bde6c1dab3c1e4f4e7b1f177",
   "Man2",	"bf66c65ac443c5c1cc46d1abe1cae5d8e6a4f0e3f54ff6a5",
   "Man3",	"baa1ae5ef8b4f1c9",
   "Man4",	"b0d2b9f7ba43baa9bdafc3eedcbbe15be170ea42e672e2cdc167f6a4",
   "Mang2",	"a6a3aa5daabca87eafedd0f6cab1d160d178c9f9d65ddab3cd76dac9f4c0dfe7ca51e86cef5cf878d042",
   "Mang3",	"b2f5c1afe2a5dac7db5ce169",
   "Mao1",	"bfdf",
   "Mao2",	"a4f2a5d9ad54c1e3bbecd8a8d8cbe55cd1d1d35de7baee69d7f6e8d5f5a3ccdada55d7dc",
   "Mao3",	"a566cef6aa7dad67",
   "Mao4",	"ab5fb455b7e8ad5abbaab654d8b9c0b7ddd5de41cfe4acfee748cdbbdfc0e767d7c0e85a",
   "Mei2",	"b443aa54b1f6a853b7d1aab4acdcb2f9be60c5f0ca7ad8abe15fd8ddb7b0b544debbe2fbd751df75d0a3e871f44b",
   "Mei3",	"a843acfcc1e2d8c3dcf6d1c0d25a",
   "Mei4",	"a966b441b44bac4eb04cbe79aa7ade71dab6d2cee4c9e7ae",
   "Men2",	"adccb1bfaaf9e5d2eab0dbaff9c7ebea",
   "Men3",	"e5c8",
   "Men4",	"b465c256bf54",
   "Meng2",	"c261c263c0dbb7f9c3a9b5debb58e8f7ade0ecdcece7efdaefeabf5fcd70ea7bf2a4f4b6eb45ad6aebd5eec4e0d6f777f960d766",
   "Meng3",	"c36ab272bb67bff8dec1bb53f4c8",
   "Meng4",	"b9daa973f771f178",
   "Mi1",	"ab7dbd4edd59",
   "Mi2",	"c0b1c46ac153c1bcb067c247cbcdf6e1efe4f7e6f46ef6f1edddf5f2f7f3eec5f95ef5b2f8c7efaa",
   "Mi3",	"abdaa6ccc3fbaec5d9f7ed51f6e9d6a9dfbee76be477",
   "Mi4",	"b14ba851aa63afa6a6cdbb65b356beaddce2cc57cea2e96de258e26de2b7afb5f2bbe74cf643dffbc1c4e8f2e147",
   "Mian2",	"b4d6af76baf8d4edd8b6f251f27af476e7aa",
   "Mian3",	"a74bb0c3ab6aae59bd71c94dcde9b0c1d879d94da85cb542cfe2df5f",
   "Mian4",	"adb1c4d1",
   "Miao1",	"d870",
   "Miao2",	"b479bacbad5df85e",
   "Miao3",	"b4f9acedc2c6aa57d9e7ace0e6dabd7ac2e4",
   "Miao4",	"a7aebc71cfc6",
   "Mie1",	"aba7aacb",
   "Mie4",	"b7c0c14ebdb0efc5efcbf47aee47f642f647dbd0f977",
   "Min2",	"a9a2a5c1cc78ccc9ccc5ded0e6e8d35ed0a2e0c3ec42ec4acc7e",
   "Min3",	"bca7a9d7b1d3a5d7b67bbbd4e4ecca6eb75dcee8ddc3aa7bb543e65ebf49d6d0f06ae0ef",
   "Ming1",	"e240",
   "Ming2",	"addfa657a9fabd50bfc1b955bbcabbefdcf3ba5ccf79de48e3b2ee79e0a5",
   "Ming3",	"afface71d6ae",
   "Ming4",	"a952e051",
   "Miu4",	"c2d5",
   "Mo1",	"ba4e",
   "Mo2",	"bcafbcb1bcd2bf69c155c4a8c2d3c55df5c2e172f6a2f3b1",
   "Mo3",	"a9d9",
   "Mo4",	"b9e6a5bdaa5caa6aba7aafb0afdfbda4ad5bb2f6b8e7adafc55abea5c071e14befbbe166cc45e1cee5c9ccebeff1f26dea70d6afea7ed6e0edd5f5ebf2d7dbbef0c5dbc5f0f1e46ee4b1f368e4c0f6a3cefed772",
   "Mo5",	"bbf2",
   "Mou2",	"a6c8b2b6c15bbfd1cbc6cbedcfa8eda1dbbfe4b5eedeefa4efad",
   "Mou3",	"ac59e45e",
   "Mou4",	"e2e7",
   "Mu2",	"f2fee5f5",
   "Mu3",	"a969a9e6a5c0a864af61cfbce0becea8d2e4",
   "Mu4",	"b6d2b9d3b9f5bc7dbcc7a4eca84eaaaaa5d8b7fcbf70ad60cbf8e1b3dde6d241cd56d3bee0bbe8aff17ef5ad",
   "N",		"a37a",
   "Na2",	"aeb3ced4e7e3",
   "Na3",	"adfe",
   "Na4",	"a76fafc7b35ba8bab675cab4b1cccdb0d3d4d7d1dbe7d7dee8ded6d5",
   "Nai2",	"ecd7e5bad443",
   "Nai3",	"a444a5a4a6bbb069ecceca4e",
   "Nai4",	"a960ad40d0d2cf55eb6eeb71e8f3d9f2",
   "Nan1",	"c9c6",
   "Nan2",	"ab6eb3e4b7a3a86bc3f8c9cfddc6cf49dfd9eba4d778",
   "Nan3",	"b369f7d9d96bd9f5df76e7bc",
   "Nan4",	"d8c9",
   "Nang2",	"c56ef8ee",
   "Nang3",	"f8efc4e4f8f5",
   "Nang4",	"f9d4",
   "Nao1",	"d16f",
   "Nao2",	"a94cbcb8f1f9e960ccacbef8da71effef6eff2b3f2f8f7a4",
   "Nao3",	"b46fb7eab8a3",
   "Nao4",	"be78d5ef",
   "Ne5",	"a94f",
   "Nei3",	"be6bdb4ed163",
   "Nei4",	"a4bacced",
   "Nen4",	"b9e0",
   "Neng2",	"afe0e8f4f0a4ecd1",
   "Ni2",	"add9a967a5a7aa64c04fd4dca9cbd646cd5dd665d2f3f944e3eae7d3e84ed7edf1caf3cdf3f3f8a4d16bdbf5",
   "Ni3",	"a741a970c0c0b1dde8f6cbf4d4ccccbbcf46d06ff0aee0b7eef6e4d2cd62",
   "Ni4",	"b0ceb7c4b845bfb0b066e17cd8fdceeebccaeacbeacff6b5f6b7d0b4",
   "Nian2",	"a67ea9e0c248d6dff3ce",
   "Nian3",	"b1c9bcbfc25bbd56bdfbaf47edcddbf9f655",
   "Nian4",	"b0e1a4dca9c0ce70d5f9f5bcf5b8",
   "Niang2",	"ae51c45d",
   "Niang4",	"c643",
   "Niao3",	"bec5b3bedcf5ecd0e772b8cdeb73",
   "Niao4",	"a7bf",
   "Nie1",	"aebaf76ee845",
   "Nie2",	"d07c",
   "Nie4",	"c4d9c45ec2bfafe5c65cc2ecc941efbff8a5dd51e5aed976e5cef458af49cd73eab7f741eaf4f751e458c668f9c0f16edca1f9aec56a",
   "Nin2",	"b17a",
   "Nin3",	"cee6",
   "Ning2",	"beaec07bb9e7c0bec266c0f1d8d1daacf4b2f76bf95d",
   "Ning4",	"a6f0c0d7",
   "Niu1",	"a7ac",
   "Niu2",	"a4fb",
   "Niu3",	"a7e1afc3b673cd55cb63d770",
   "Nong2",	"bbfabebabf40c177b941c2aaf2ebf4e5f854f9b9",
   "Nong4",	"a7cb",
   "Nou2",	"f4b0f4d1",
   "Nou4",	"ed63bfaef155",
   "Nu2",	"a5a3be71cc56d6d9e3ca",
   "Nu3",	"a756a9b8d2df",
   "Nu4",	"abe3",
   "Nu:3",	"a46bd046d7fd",
   "Nu:4",	"a7d7d17ed1d7d3d0",
   "Nuan3",	"b778d9f6ef4e",
   "Nue:4",	"bac4ad68eba6",
   "Nuo2",	"ae52aebff5c0d57bd5ca",
   "Nuo3",	"e9d6",
   "Nuo4",	"c0b6c47abfd5ece2d1bdddabe0a3",
   "O",		"a3ac",
   "Ou",	"a3b2",
   "Ou1",	"bcdabcdebf5ec5c3f250e665f0dd",
   "Ou2",	"f8ec",
   "Ou3",	"b0b8b9c3c3c2ca7ebda2df78eaf9",
   "Ou4",	"bebee1d3e278",
   "P",		"a375",
   "Pa1",	"b0d4b8b4ad77d3c1d372",
   "Pa2",	"a5b6aa49aaa6b55dafd2d7da",
   "Pa4",	"a9aca9c8cacbd7bd",
   "Pai1",	"a9e7",
   "Pai2",	"add6b172b1c6b550d9d3f06c",
   "Pai3",	"cdeb",
   "Pai4",	"aca3b4fbeece",
   "Pan1",	"c36bbcefcfe3",
   "Pan2",	"bd4cbd59bdedc2dadcfddd5ce1d9cefdba6eeff8eda8ead9e3d2c2cff3a3dbf0",
   "Pan3",	"cbfe",
   "Pan4",	"a750ab71a9e9af60acdfcb58ccf1de64cfb8d7b5f94bdbe2d84e",
   "Pang1",	"a5e3b7bc",
   "Pang2",	"c365b74baec7bfc0cdf7cabeeab8e3aed3efdca7db59",
   "Pang3",	"dcdfeae5",
   "Pang4",	"ad44",
   "Pao1",	"a9dfd74b",
   "Pao2",	"a753b0cca948a9b4b354cfb2e4c6f5be",
   "Pao3",	"b65d",
   "Pao4",	"aa77acb6af70cc43afa5ecb3e8d7",
   "Pei1",	"a941ad46d14ecc5fccaecf42d3cfe85b",
   "Pei2",	"b0f6bb70bddfb3add9e3dee5cdd6d849",
   "Pei3",	"cef1daa6",
   "Pei4",	"a8d8a84baf5cc5afb074c9b5ce72cc6ed1cfd253e8ae",
   "Pen1",	"bc51",
   "Pen2",	"acd6da4bdfe1",
   "Pen3",	"cbebf07bd6fd",
   "Pen4",	"e9de",
   "Peng1",	"a9e1b269af79ca71cc7bcec2e2a7eaa6dbfce0d0e8c7",
   "Peng2",	"b45eaa42b4d7bceab84ec14fbfb1bdb4c450d0d6dcbdc9dcd5f2ded2cba2f0bee84cec40ec58ef68f1bde57ee5e9f84c",
   "Peng3",	"b1b7d6a5",
   "Peng4",	"b849d4b8d56bed72",
   "Peng5",	"e8d3",
   "Pi1",	"a541bc41a4c7a7a5a7e5a9dcc552ca60cbf2ece0cd5fcfecd2efd6f8dc6db965e8d6e8efe47c",
   "Pi2",	"b0e0b0f1aa4aac73b55caf68a5d6afc4b5cab3b2c567cf69f270cd68d341f2bce3a8d7afe3ebee66eeb7d7efdc66ebedcbade8c9ec77",
   "Pi3",	"a5f6a5d4b56cc27df1f1c9c8d4fdc979d0a1e7de",
   "Pi4",	"bbf7b742a7bec4b4c550d95ce9a4d5ede276e9eded57f049f8e5f059",
   "Pian1",	"b0bebd67bda1d8bedfcfe8baf5ab",
   "Pian2",	"c063dde1dde4afe2ebabebc5ec6b",
   "Pian3",	"dbec",
   "Pian4",	"a4f9c446",
   "Piao1",	"ba7dc4c6dcb8e1c0e1c9ecf1ede6f0b7ee5ff6a8",
   "Piao2",	"b9e2bf5dd641",
   "Piao3",	"bf67e1e1d5dcf26ef470c165bda8e75bf2cbf14f",
   "Piao4",	"b6d1b2bcc559edbff54e",
   "Pie1",	"bf68",
   "Pie3",	"ba4a",
   "Pie4",	"e173",
   "Pin1",	"abb9abf7d263f2a3",
   "Pin2",	"c0a7b368c057c649f1f5",
   "Pin3",	"ab7e",
   "Pin4",	"a6c9b875",
   "Ping1",	"a5e2ae5cd2dde8b9",
   "Ping2",	"a957abcca5adbeccb27eb5d3c4abb5fbcde5cbe9ceb0ac69ccf2cfcccb6ee34ddafcdb5bd06dd3b1dbb2e075cf6ed0b7",
   "Po1",	"a959bce2cfdeb07af4faab40",
   "Po2",	"b143be49efe5ed78",
   "Po3",	"a572bbe1d6db",
   "Po4",	"a6b5acc4af7dada2be7acc6ad273b2cbe3bac3e6",
   "Pou1",	"ca7d",
   "Pou2",	"caebd1bcd568b8cf",
   "Pou3",	"ade5d4e0d9abdec0",
   "Pu1",	"a4b2bc50bcb3be51e54ea5b7ccb7dab1f35f",
   "Pu2",	"b9b2ab6dbeebb5d0b8b2bb5ac3dac0e4bf5cf4afe3bcf0d6f359e472f4f5cceceda3",
   "Pu3",	"ae45b4b6aefab7c1c3d0e656d650bba7f4ea",
   "Pu4",	"c36ec272e745",
   "Punctuations",	"a141a142a143a144a145a146a147a148a149a14aa14ba14ca14da14ea14fa150a151a152a153a154a155a156a157a158a159a15aa15ba15ca15da15ea15fa160a161a162a163a164a165a166a167a168a169a16aa16ba16ca16da16ea16fa170a171a172a173a174a175a176a177a178a179a17aa17ba17c",
   "Q",		"a3a2",
   "Qi1",	"a443a964b17ebca1b1adb4cfb4dbb259baa3b5d6d0cee0f5d0e2ce48d4a7d4d3d54ed972ac6dd1e1d5c3e24ee6c5eaa3e368e7d5d7e9ec51f550f1c1f3dcf8dc",
   "Qi2",	"a8e4a95fa7c1b154ba58b4c1b4d1aa5bb24eb558b2a5aac2ace8ace9b852afcfc2c0c34dc55fc451bbf4c951a7a6d4c3e159cac8ece3d1d2f7e7b561dee9e375db44f4b7db6dc2c9f0adf4bfd3bdd3ced3c3e3dbf4c5b04ed7d7e7fbd7ddf35dd843ebf7c042e0e0f1aff567e4deef6bf3d5f3def3dfcae1d5a4ed59",
   "Qi3",	"a45eb1d2a7fbbaf6b05ab05fd4e5c9d7d973d9c9e376cb7dcdbcca55",
   "Qi4",	"a5f8beb9abb4becdb1f3aef0a854aa5face4bd72b057a8b4c9e1b474d1edc961c9fdd9e8d9e9e6accd79bf6cf2badfc2f2e6ebaef364f879",
   "Qia1",	"d574",
   "Qia3",	"dc61",
   "Qia4",	"abeaaca2ceb1d94bd5dd",
   "Qian1",	"a464a561b44fb26fc3b1c5d2c1bebe45b95da6e9c648c4cadcc2d4eecac0b75ee1c7c9e7d952ba53f243f44eefe3cb4cd049df6dcba1eb72f4d2e86af66af774",
   "Qian2",	"ab65bce7bae3b040b678b958bffac072d8c4cac5cae5caf5ccb5d57ad961e279f5d5ea48dfb0dca4f3b4f1bff6acefafc9b0e24b",
   "Qian3",	"b24cc4febbbae5afe256f4adc9e2e3f0",
   "Qian4",	"adc5b9d5a4edba70d853dccbdd67d9cee5deeac6e366c164cdc0d37de3c8e848",
   "Qiang1",	"ba6aaacab5c4c3f2e1acccc2d9aae2c5e2d2cd7be3d6eebef142ebe1c2f2f366eea8",
   "Qiang2",	"b16aa9cfc0f0c1a5e952e970becac0cee27cc962f5fb",
   "Qiang3",	"b76ddcc4e168eaaac166",
   "Qiang4",	"b6e6d476f5ee",
   "Qiao1",	"ba56bef5c3dfc1eadcece54be94ad173e96beda6f074f354e470f374f664ec6af1bae8b7",
   "Qiao2",	"b9b4b3ecbcacbef4bef6c140c2bce142e548e558e568ea56edaef06beb4cc3d7f34bf34e",
   "Qiao3",	"a5a9aea8b473e0fa",
   "Qiao4",	"ab4eae6bbcc0c2acc054e9a9bba6f4d8",
   "Qie1",	"a4c1cb50",
   "Qie2",	"a6f7ad58ca47",
   "Qie3",	"a542",
   "Qie4",	"a963a9c4b467aeb2c5d1c1e6e1f9e6d7e367f0b5dbb7e7f5f3d2",
   "Qin1",	"ab49b4dcbfcbbc6bf25cdf5cd3daef5d",
   "Qin2",	"b6d4beb2bee0b55eb856afb3aae0dd41ecdfe5c2ecfee9fdd368cdc1eb5edc74e0dde8ebd3c6",
   "Qin3",	"b9eccaabd8d4cccfe9b7ee60",
   "Qin4",	"a847d0f7bcc3db6b",
   "Qing1",	"b6c9adebb242b24dbb66bbb4ab43d4abd9e6cb67d7f0c44a",
   "Qing2",	"b1a1c0bab4b8d0ede5e0c0d2d5da",
   "Qing3",	"bdd0b3bce1b8",
   "Qing4",	"bc79bf6bc16ad0e1d5a2cb4de653deedf0e7f76ae4be",
   "Qiong1",	"aac6cb7ce4a9",
   "Qiong2",	"c3a3bd61d946de72ea63e6bdd6ccf2c8f2d5dbbcd7d5e072e076ca54d1e0e9d5",
   "Qiu1",	"a543aceeb34caaf4c2fec4cfd45acbfad8cfdddfe6e6dfc7e75ff0ccebbbf5aececfe7bdf644",
   "Qiu2",	"a57da844aa73b279b8caada9cddec958d8d9c9f0b1fcb241de75c9a6e6a5dab9d35adf5bd747ca4dd076d75ccdc8dfe4e7a3e447d0b0e453d7e4e07dd0c1d444e867ec79f1ccf7b5ecb8",
   "Qiu3",	"eac9",
   "Qiu4",	"d5dbeb69",
   "Qu1",	"b0cfa97db9f2c2a3b349c1cdc2dfc558ca5dc942cbdccc60ccb6e5beafa3d2e7d058b5f1d7b6e8a5cdd8ec76f3e2ec71f85c",
   "Qu2",	"a757b4ebc0f3c5fcc454f3fde979cefaf6e4f6e7f5d6d2c7edaaf7ecd6fad061f745dfc9eaf8f5f8ee6bf0d1f8bee057f951dc43eca9f1e7cee9d5f8dba7efa8",
   "Qu3",	"a8fab0f9a6b1c654cfa6d6e5",
   "Qu4",	"a568bdecda40f2f3eef1ecb2ca6d",
   "Quan1",	"b0e9cebcd1aad9afdaface74",
   "Quan2",	"a5feaeb1c576ac75b2acb8e0bbcda8ded4cff5caced1d557d2a1da68debedae2ead2affebb6cf8bde041bdf4e079eec7f9afec68f1bbf867f6d4",
   "Quan3",	"a4fcd66eaccae365f946cb51",
   "Quan4",	"a8e9c455d279d2a2daf3",
   "Que1",	"afcae3c5",
   "Que2",	"bf61",
   "Que4",	"ab6fba65bd54c1f0b3b6c44ed14fe1c3dd7ce269ded6dad0daccdee7e6c1f05bc2f6f5e1",
   "Qun1",	"d16ee45fd7e7",
   "Qun2",	"b873b8c8d167",
   "R",		"a3a7",
   "Ran2",	"b54dbf55be77d7a4d7a3d7b9",
   "Ran3",	"a554ac56cbe4cc49e9cfcfd3ad5c",
   "Rang2",	"c463f1ebf1eef45bf46dc57bc5a1f6f8f5f1f8c4f9b6",
   "Rang3",	"c457c45bf5dc",
   "Rang4",	"c5fdf44a",
   "Rao2",	"c2ccc4c2c4c7bc63eafef0d2",
   "Rao3",	"c25a",
   "Rao4",	"c2b6ebd0e8abf672",
   "Re3",	"b753d86f",
   "Re4",	"bcf6d9fc",
   "Ren2",	"a448a4afa4d0a449d351cdc6e4b9",
   "Ren3",	"a7d4b85aaff6d1f4d9c2db50d765",
   "Ren4",	"a551a5f4a462a7b3acf7bb7bb8eeb062b6b4b6b9c9d8d1a1cb60cb74b04dd3ddd7e0efa6",
   "Reng1",	"a5b5",
   "Reng2",	"a4b4cb72dc7d",
   "Ri4",	"a4e9d3d2dc73e4d4",
   "Rong2",	"ae65a6a5ba5fba61b7bbbab2b5b3aff1bb54bfc4c2e8dd44c0afe260d243f267d653effccfc0e2cedb41cb78d376f4c6eb79ec63ec6ef6a9f7b7",
   "Rong3",	"a4bed85fe9e6dc44",
   "Rou2",	"b47cac58bfe4c2fdddd6c9a8dfd7e7acebcaeee2eee1f1a5f3b6f571f5a2d8c6",
   "Rou3",	"de6ed34de6df",
   "Rou4",	"a6d7",
   "Ru2",	"bea7c07da670c0a9c0e1aff8c4afceb4d1b2efdcc277dae3f07deb51f0b8dbccf4cbf65defa7",
   "Ru3",	"a8c5a6bccbc7ece9e4a7",
   "Ru4",	"a44abfc8b064dd40cf76de50ead0e3bde0a6dcd9",
   "Ruan2",	"d8a3eccae5b5",
   "Ruan3",	"b36ea8bff041f27de6e4d052e7abccd2",
   "Rui2",	"d4ebe36feb42",
   "Rui3",	"bfb6d8fbd5bde9d0f075",
   "Rui4",	"b7e7bacdbe55e8fbccd9cb55cdbad3c2",
   "Run2",	"da69",
   "Run4",	"bcedb67ce9db",
   "Ruo4",	"b0b4ae7abf78ad59ddd8f26be6d9e3c0dc59c564",
   "S",		"a3aa",
   "Sa1",	"c965",
   "Sa3",	"bcbbc578cf73f8c5e0dc",
   "Sa4",	"a4cac2c4bbe3e1e9d7d9f158e4d6efd6",
   "Sai1",	"b87cc4ced96cd242",
   "Sai4",	"b6ebc1c9e4e6",
   "San1",	"a454f44de5f7f6a6",
   "San3",	"b3cac158f06ff4ed",
   "San4",	"b4b2dc7b",
   "Sang1",	"b3e0aee1",
   "Sang3",	"b6daddbae6caf162f3a8eb7b",
   "Sao1",	"b76bc162bfb4c4ccdd69e6b1edebf3aef8d9de52",
   "Sao3",	"b741b1bdd4b5",
   "Sao4",	"dcd5ed4d",
   "Se4",	"b6dea7a3c0dfb7e6c2a8a6e2e9eced6cdf70f64ff4dbe4a3f775",
   "Sen1",	"b4cbe1b4e5dbedc8e778ee78",
   "Seng1",	"b9acf7a5",
   "Sh",	"a3a6",
   "Sha1",	"b1fea846ace2afbdb2efb8c6c354d546e5d9d2a3daafe771f36ae8dddacd",
   "Sha2",	"d4a3",
   "Sha3",	"b6cc",
   "Sha4",	"b7d9c04bd86cdcd3ddf7e351e37cdb67",
   "Shai1",	"bf7a",
   "Shai3",	"bbeb",
   "Shai4",	"aecdc5ceeef3",
   "Shan1",	"a752a96ba473a7fcbce8acc0c3bbad51aadfad6db65cd57dddb5ba55da5bcfc4eab1d6d3c168d073dcc9cf6b",
   "Shan3",	"b07bd445d9a5dedbe7ceb0a2",
   "Shan4",	"aeb0bed5a6c2bab4aab7c2b5b5bdbfafb053c4bac5ebe4e7e552e54de951d56ce1dff2dceeadd3e4e854d7fcf562",
   "Shang1",	"b6cbb0d3bcdcc2d2e2b9e74eee59f0daf6a7",
   "Shang3",	"aecebde0",
   "Shang4",	"a457a97cce73f7f7",
   "Shang5",	"bb6e",
   "Shao1",	"aeb4b1e9bf4eb579d17addbedf4bdfa5d776dfeaef65e466",
   "Shao2",	"bbe0a463a840cfd0cfb9",
   "Shao3",	"a4d6",
   "Shao4",	"adefb2d0aaf2ca6fca73e64cdabcd7b8",
   "She1",	"b0f8bbadce61ed42f0e0",
   "She2",	"a4b0acc6a6deb344ca65d960e0ae",
   "She3",	"b1cbf1b7",
   "She4",	"ae67c4e1bef9af41aac0aad9b35db36ac565cdf8f5d4d669e751f1a6f2e8",
   "Shei2",	"bdd6",
   "Shen1",	"a6f9a944ae57b260a5d3af7eb2d4a8adcbc2c9d9cf5dea50cfcad2c0d045d05bdfdee04dec67cc50d170",
   "Shen2",	"afab",
   "Shen3",	"ab7bc254bc66a848c26eed7bcfe8e7dcf75acba9f754",
   "Shen4",	"b756baafb5c7b8c2cdecccbdddd2b2e9dfb8e87ad2d1",
   "Sheng1",	"a4c9acb9a5cdb563b2c6c16ecaa2aa40cd4eda54da64cd64e0c8b0a5f3eff1e6",
   "Sheng2",	"c3b7e97af4d0f8d8de68",
   "Sheng3",	"acd9cbced2d6e6ded466",
   "Sheng4",	"b3d1b3d3b2b1b874c96fdd4fdbebc1cb",
   "Shi1",	"a5a2a472abcdae76ac49b7c3b7e0aaebbdbeb8d6da4fde69c0e3e6d6d6eadfade3b9ee77f948d0b9f6b0e4e3f6c6",
   "Shi2",	"a451b9eaac42aec9a5dbbb6badb9b6f6e24dd9f3da41de63d2e8e3c2e0c6f6adf1e5f3f6",
   "Shi3",	"a8cfa576a96cabcba5dabe70a8a8",
   "Shi4",	"a540a8c6a54ba8cdb6d5b6ddbebda468abc7a5aba6a1b749abeeabf8ac4fac55a4f3a5dcafe7b5f8b8d5bb7dc3d1b8fdb375be41c4c0b9a2d0fcbc5dd8bacae6d969e9f5b862f066e6faf64beba8ebaceeb0dbeae06deec3e0b0e4ade8a4f56cf5bad8eddd72d272c95d",
   "Shou1",	"a6acd3a7",
   "Shou2",	"bcf4",
   "Shou3",	"a675a4e2adbad953e746",
   "Shou4",	"a8fcb0e2b9d8b1c2acbcc37ebd47bafe",
   "Shu1",	"a7e7aed1aedebccfaeedb2a8b5cebdadbfe9ce67e1ddefd2cce6e5ccc0cfc95fd356df59d0c7d7dff3f1",
   "Shu2",	"a8fbb9d1b145b251c5abd4c8d65ad2edb5e0f9a5f2ede461f8e2",
   "Shu3",	"c4ddb4bbb870c1a6b8beb6c1b9abd4e7e661f04cc3c5f649f9c9",
   "Shu4",	"b0bfb9d6b166aea4a6a7bcc6c0c6a7f4bef0baa4b34ebdddad7af1ecd8d7ccf5e640df6fdff2e0b4f36fef6dd7b3f57d",
   "Shua1",	"a8ead47c",
   "Shua3",	"ad41",
   "Shuai1",	"ba4cb049f5c7eace",
   "Shuai3",	"a5cf",
   "Shuai4",	"abd3b276c1acce4fedd2",
   "Shuan1",	"ac43aeeaadac",
   "Shuan4",	"b252",
   "Shuang1",	"c45cc2f9c1f7f5c8f6f6f8bbf9b4f7b9",
   "Shuang3",	"b26eb9d7e1d4e5e6eadc",
   "Shuang4",	"f466",
   "Shui3",	"a4f4",
   "Shui4",	"baceb57cd8c2d174d258dff5",
   "Shun3",	"a76dd970dde3ebb7",
   "Shun4",	"c0feb5cfb6b6eb48f3c3ea76",
   "Shuo1",	"bba1",
   "Shuo4",	"a671aed2c37bbad3a8a2c5e0dcdedd78dd7de254d5d6cfa9e6d8e3b7f161",
   "Si1",	"a571bc52bc72abe4bcb9b4b5a870b5b7c5eed454e140ddf1e253cd47e642e340e6cde6ebe37aeb57d3b8e3f1eb6bf0cfdbd2e0c2f1abe6c8",
   "Si3",	"a6ba",
   "Si4",	"a6f8a6fcab53a8e1b6e0a57ca971a678a478aa72aac1b2e0b876bde7b97dbe6fecbecf4ec9fad25dd6ceee41e059d249d1fb",
   "Song1",	"b743aa51b253c350d0dbce65b15da7d8ea43deeedb70e3ddeed6",
   "Song3",	"aeaabca3c171dcc0e1a9dadcef5bdd6e",
   "Song4",	"a7bab35ebb77b065b97c",
   "Sou1",	"b76abb60c442c349dcdbdd60de59deaee0aaeec8f15cf55e",
   "Sou3",	"adeeb9bec25dc3c1e2aae6bcf5e4",
   "Sou4",	"b9c2",
   "Su1",	"c5c8b564bf71c4acb670f45a",
   "Su2",	"ab55",
   "Su4",	"b6eca667b14ab7b9b5afafc0b5c2bdb6b644b374d857b6e8dd42e1c2dd68e5a5d1e3e25ae5cfe9cbcd41d250de4dc9a7df42c150eadee3a5e75cf2cde448eea2e879e8c4f77bf859f865",
   "Suan1",	"bbc4d2a9b56d",
   "Suan4",	"bae2bb5be8fadf48",
   "Sui1",	"b86bc1f6d143de42d267ea41d6aab846d768d76fde44",
   "Sui2",	"b6a6c048",
   "Sui3",	"c5e8e967f261",
   "Sui4",	"b7b3c0e6b848afa9c14ab945c047d4bdf249ecf4ed48ed67ded9f060edd8f2b1db51f2eabdd9e7e8c2e3f544f661f05e",
   "Sun1",	"ae5dbb5eb6b8ddbbe25fdeacedfe",
   "Sun3",	"b76cba67b5abf069f168",
   "Sun4",	"e1d2bcf2",
   "Suo1",	"adf6b6dbae50b1f4bf75c159d854d566e1dad5c4d761bb62e456f0f7",
   "Suo3",	"a9d2babeafc1c2eadcd4e1e2e6a8f163f540",
   "Suo4",	"d7e2",
   "Symbols",	"a1a1a1a2a1a3a1a4a1a5a1a6a1a7a1a8a1a9a1aaa1aba1aca1ada1aea1afa1b0a1b1a1b2a1b3a1b4a1b5a1b6a1b7a1b8a1b9a1baa1bba1bca1bda1bea1bfa1c0a1c1a1c2a1c3a1c4a1c5a1c6a1c7a1c8a1c9a1caa1cba1cca1cda1cea1cfa1d0a1d1a1d2a1d3a1d4a1d5a1d6a1d7a1d8a1d9a1daa1dba1dca1dda1dea1dfa1e0a1e1a1e2a1e3a1e4a1e5a1e6a1e7a1e8a1e9a1eaa1eba1eca1eda1eea1efa1f0a1f1a1f2a1f3a1f4a1f5a1f6a1f7a1f8a1f9a1faa1fba1fca1fda1fe",
   "T",		"a379",
   "Ta1",	"a54cb6f2a66fa5a6a865cda2e6cf",
   "Ta3",	"b6f0e247",
   "Ta4",	"bed8ba66baaac3a1bdf1c1cfc4bedcd6ecc5ddade26bcceed5f0d04fe7dbbbbdbbbeebfdf159f76ff16cf66beefef3a1f6aeed4ef9d5d85a",
   "Tai1",	"ad4c",
   "Tai2",	"a578a9efbb4fad61b660bbe4e8f5ecd5c269cfb1f4a6c2cacdd7e8ceec7ccafb",
   "Tai4",	"a4d3ba41a84faef5de5eed60dc67",
   "Tan1",	"a77ec575c579c5f5b367cec0ccbee9c5e364d752f4ce",
   "Tan2",	"bec2c0c8bce6b7f0c2bbb5f7bdcdc3d3d0cbe545d4dfd558e5a1bee8f2c6f347d7e8f35eebe0f4ecec5cf77a",
   "Tan3",	"a95ab4e0b352e154cad8e5abedafede8db65f2e9f34aebd8f6cc",
   "Tan4",	"b9c4b1b4acb4bad2d4bcbcdbda45e7eedcc1",
   "Tang1",	"b4f6c3ede7b0f141f8e9",
   "Tang2",	"adf0b0f3b6edb765b4c5bf7dbda3c1aec1dee1fde5e8e9d9de46e2b5e2c1bac1e6c9e3b1edfdeb5deeb9ebc3f15ff378f6b3",
   "Tang3",	"add5a9aeb249bdf6c56cf7daf8aaf8b1f8f8f166f9bf",
   "Tang4",	"bf53bdebf4e7e1f2",
   "Tao1",	"b1c7b7cac3fccc71dd6dddb0e24fb86cead6e37bc5b9dd45e3e6",
   "Tao2",	"b0deaee7b25ec0dcb5e5b06bb3b3cbd7ce42c268acabc276def6e370e860ebebec41e4c3ec66f1b5",
   "Tao3",	"b051",
   "Tao4",	"ae4d",
   "Te4",	"bc7caf53cad7cad6f0c9d3e2e869",
   "Teng2",	"af6bc4f0c3c3c1c3c4cbbcf0ead7eb4aeb66",
   "Ti1",	"ade7b1e8bdf0f6c2",
   "Ti2",	"b3dab3f6b4a3bfe1c344d456cdf6d94ed66be2fddad7df57bd7bd377e7c9eea9ebbcebdbeee0b6acf3bbf1cff578f5a5f87cd8eae7af",
   "Ti3",	"c5e9",
   "Ti4",	"ab63c0a1b150aeadb1a7b4c0aef7b37cbe4fd0d7d552d956e5f3f4a8ee4be7c2f654f1bce2e3",
   "Tian1",	"a4d1b24bd0dddc5fd4ec",
   "Tian2",	"b6f1abefb2a2a5d0c2f5cc5accfad9ebaccbcfe5e6d4dbb0",
   "Tian3",	"a9bdb5c9bb51c053d562cf66d5eed3c9e7e9ebfce4ced9a7",
   "Tian4",	"d56dde6ce2d0",
   "Tian5",	"ec5b",
   "Tiao1",	"ac44ceb9cec9d6bde774ef6f",
   "Tiao2",	"a8d9b1f8ad7ccc67d6d1ca4cd071bb6de066f16bec55e8d4f7b2f5bbd2eb",
   "Tiao3",	"b2c0eccfce77e04b",
   "Tiao4",	"b2b7b8f5d1d8eab5f8fddaf8d36db8d0",
   "Tie1",	"b64bcca3",
   "Tie3",	"a9abc54be0fde4abe872f852",
   "Tie4",	"d7a6c34b",
   "Ting1",	"c655a5c5c5a5d5b9df5ecdaaca4b",
   "Ting2",	"ab46b0b1b440ae78a7cab8bbbe5ed8ebc9efddcae257d9eadf4de6fbd76cdface7bbe8a8f5b9",
   "Ting3",	"aebcb1f2b8a5cdeec96ed658d670cb6dd74de86f",
   "Tong1",	"b371cfb5e66bcfc3d6a2e766",
   "Tong2",	"b9ada650a7cdaee4bce0c0fbb5a3bbc9c969ca63cbbeabd0e9b3e9bde9e7d268d275f6ecea59e677d6bbedb1df4adaeadaf0ede2eaf3f0a2d3a6eafae04ad3ebe0ace0cbe4d0ef6ef1e8ce40",
   "Tong3",	"b1edb5a9b2cece54ce6fd1b6",
   "Tong4",	"ba45b568f5f5dbc2",
   "Tou1",	"b0bdd8c1",
   "Tou2",	"a7ebc059dea4d7f3",
   "Tou3",	"cc44e9b2d359dc6fefae",
   "Tou4",	"b37a",
   "Tu1",	"a872e1b9e1a4d5a1d260",
   "Tu2",	"a559b9cfb6eeb14fae7bacf0b2feb37ed172cca8d1ccd5d3d25cda4ce6abdec8dad9df50df7edfabe3ade459bbc6eeecef62f1ddf577f7bbf7c9dd53e2a2f7c4",
   "Tu3",	"a652a467d147cb7ad841",
   "Tu4",	"a8dfd4cbb5e9f3e6",
   "Tuan1",	"b4f8de7eebb2",
   "Tuan2",	"b9cedcc7e1c6e1dee5e5e277c47bf371f861",
   "Tuan3",	"e2d8",
   "Tuan4",	"f5c6cebde7ca",
   "Tui1",	"b1c0e761f2ce",
   "Tui2",	"c05ae9d3f2a7f352e8aaf1c2c9de",
   "Tui3",	"bb4ccdede0f9",
   "Tui4",	"b8c0b068cde7ef61",
   "Tun1",	"a75dcccee9b4d24bcd57",
   "Tun2",	"a779a4d9c176b362b6bbd474cadccdb5d7c9d7dbe8e1",
   "Tun3",	"c9f8caa4",
   "Tun4",	"bfc6",
   "Tuo1",	"a6aba9ecb2e6b055cbc9d8add1becd4bcd7ed84fe0e5c9ec",
   "Tuo2",	"a6efaa62b659aafbb9a4be6dc06bcc40cc5bd549d2d9e2f6d6e3dbe1dc5dca57e4c7f7a2e4dfec73f965d7b2",
   "Tuo3",	"a7b4bef2e557e5bb",
   "Tuo4",	"b3e8a9ddac6ce9d1ddfdf6fbf4bddbfbd1fe",
   "W",		"a3b9",
   "Wa1",	"ab7aabf5badab5ecb445cf71de43e270ca48d2fb",
   "Wa2",	"abbd",
   "Wa3",	"a5cbca5f",
   "Wa4",	"c4fbd5f5e3a6dcda",
   "Wai1",	"ac6e",
   "Wai4",	"a57e",
   "Wan1",	"ade6c573c657bb64bddcc9bde655",
   "Wan2",	"a459a7b9aab1b978d4cecac1caeaa6c5d64ad04bcba3",
   "Wan3",	"b0fba97baebeb1dfb570b84abaedb2f0bbb5d0cad9a1d246e9ebda7bdec4ded8e377d74edb60e7f3e864ec56f1c3dac2",
   "Wan4",	"b17bb855b5c3c945c9bac9c3cadad567df64e6f6ee63",
   "Wang1",	"a84ca471cabf",
   "Wang2",	"a460a4fda841d75a",
   "Wang3",	"a9b9b1a6aa50baf4aac9d9a4efebca49db76bdfec353",
   "Wang4",	"a66ba7d1a9f4b1e6e1fbcdcd",
   "Wei1",	"b0b9abc2b5e4b451d94fd96ddddbda44de5ad26bb7dbe2efdfbbdfdae7a9e7d0e050b66adc7cdc7eed61",
   "Wei2",	"a64db0dfb3f2c4deb163b74cb1a9aee9acb0bafbc1a8b948c1f2adb3c949ce7cdd52b457f6e5cfaad9f8de57e65cc0e5f262f4ccdc51e861eee3f66fef74f04e",
   "Wei3",	"b0b6a965ae55a7c0b554b7f5bd6eb8abbdd3c243f6d6e4e8d87af1f7d8d0d8f7ddc2ddf0aca8d24cde6ddeb3d67ee6c7df79cdb7e770f0a9f0b6e3e5eee7e0d4f1a4f671e8bbe0e9d542f7ded6b7e843dfa4dfaf",
   "Wei4",	"a6ecb0b0a8fdb3deb14cbca2a5bcb4f4acc8ad47bdabbdc3bfd7c1fdc351d8bcde7ce674f6eee6c4eae0db73ee42f2d8f74ce3e8e7b3c1baf759f0f6f763f362f37dec5eec75ecde",
   "Wen1",	"b6f3b7c5bd45e2eaeec1f3b3eeb4",
   "Wen2",	"a4e5aab3afbeb041b6b2cd54daa7cdb2ec4ce8e4efb2eef2e8e0",
   "Wen3",	"a646a76bc3adcbead5d5",
   "Wen4",	"b0ddafbfbb44cab9a7eeddafa85af46f",
   "Weng1",	"b6e4afceeb6ff6c8ec53",
   "Weng3",	"dce9e1f6d266de5be6bfeae7bb63",
   "Weng4",	"c27ccfd8f2b9f8ea",
   "Wo1",	"add8b4f5badbb8b1da73e841",
   "Wo3",	"a7dad4d6d5a6",
   "Wo4",	"b3e1b4a4ba57a855b4ecaad7c653d451d8f2d5e2ed52da5f",
   "Wu1",	"b6e3a664abcea7c5a6beaf51d46acafee264cf72d6c8df77e0a9ef7aa6c3eb68",
   "Wu2",	"a75ea764adf8b1efa4f0b54cbfbeb8bcbb7ad16dd24fd65cd66ceaf0d762d3f5e866e86bf1c5f869f1dfc4d3d264",
   "Wu3",	"a4ada5eeab56a4c8bc61aeb8aa5abb52c44dc940c9aed0dad4a4dd54e575cadebcadddb3e64bcd6ded71dee6e9dd",
   "Wu4",	"a461b0c8a4c5b6f5b9edaea9a5b3b1e0aaabbb7ec2ebc3fac445cde1cdf5e4fad4c1d8b8c9d6c9e5cb42cb57dab2cd7cd34fcdbef4bacdd1d7e5ebd2e874ca56f3f7cac4d651dcaa",
   "X",		"a3a3",
   "Xi1",	"b9afa4bca76cbc48ae4fbc5ea7c6b178c4e2b4b7c466aa52b258b7cbbab3bf51b552c4ebc148b57dbfaabda5bb68c1b5a6e8c1c6c1d1cde6d85ddcbeae44d15ddd47d16af445cebedd63cebfcec5d1a9d949caedb1e3e250e5dfe9cad5d8e9e0d244d257e652b26ded5ef46bd677f6f3ded5dac0d6b4eab3dae8d769db6feb65eb67f8bff94cc3d6e451eeb5eeb6f65cf151f972f173f55cf9c3f1d8f87bd5d0",
   "Xi2",	"b740ae75aea7b1a4a9f5c0cabab6b2dfbb56c5a7bffce1afd9b6e5d5d1f6da62ea5fe6b3e3cdee4fe3fce444f0dff169eef5f37bf552f679f7b1",
   "Xi3",	"b3dfb170ac7ec3a2e1a2cf56d2a7edc7eddcf8fedfc4e775f0bdeba9f143f971e9b1e2abf8a6",
   "Xi4",	"ab59a469c0b8a6c1aabfa874b2d3c3b4b5bfbbd8c96dcdfdf8a8cca7de67bcf3e2bfcfe6e2f9cda5df62cdaedb57eb4df0baf8c0e7cfeea3e05dd3fde0abd7fbd7faf15bf547f1adf1beecb5f7cccc79cece",
   "Xia1",	"bd4dbdbccac2eed5e0e1",
   "Xia2",	"ab4ca758a945ae6cb776aaadaf55b7e5c1d2b949c1f8c35ccbcfdda1ac6ad27ad2bbdac6e2f5e6c0d6c1d6dceadadfa3ee45ebbaf3baec78",
   "Xia3",	"e0ce",
   "Xia4",	"a455c07eae4cb748d1f8b7daede1cb79f367f6b2",
   "Xian1",	"a550a5fdb1c8bee6cff7c5d6c241c96adcb9e148c9d0e957f443c977f447cae0e9a2ccdccf5bcb49e647aac4e3d0ee73f7fdf75fe479ef44f3b2d2b9ace6",
   "Xian2",	"ab77b0e5b6fbbc5fa9b6b243b2cdb2ecbde5bbceb67eb6a2c4d0d4e6e5a7ea47ed77f479e6f2d056dfbad77ddbb8eba3f871f870",
   "Xian3",	"c57ec4f6c049c5e3ce68dd4be964f1fedda3d240f96cd276effbea60ed64f7e8e342dae6b8c3e06ebbd1eeddf850f87af8ebf242",
   "Xian4",	"becbc46db27bbd75bfa4b872b8a2b341adadb3b4c060cde4b9b7d162ae73e5b6d5abd262f265dabddf56d7b4eeb1f657e87cebecc4c5ce76",
   "Xiang1",	"b45bb4f0acdbbd63c1b8b66dc65eadbbf448f5d2c4ece6e7f7eeeaf2dfb9eb52f9b3",
   "Xiang2",	"abd6b2bbb5beb8d4",
   "Xiang3",	"a8c9b751c554bbe8c557f959f3d0d1d6",
   "Xiang4",	"b9b3a656c251abd1bef3b648b6b5e9b8dfddf0c7f0cef0d7f541eeefced0f85f",
   "Xiao1",	"adfdc4dbae64b1faaef8c374b576c2adbfbdb370be50be5dcbe2b9cce4f9e57dcf4af457e263f7e3d251e646ca41d26ee6a1dab0dab4edb4df60eaeadfbff0a7f947d3b7f74ee45dc5bbf564ef69f1cdeca6d4aad175dadb",
   "Xiao2",	"cf6dd7f1d342",
   "Xiao3",	"a470bee5df4ec151eea7",
   "Xiao4",	"bc53a7b5aec4aed5afbaa876bbc3b3cbcec1ea53",
   "Xie1",	"a8c7b7b2c3c8dcceda74e7cd",
   "Xie2",	"a8f3aeb5b1d7afd9bfd3a8b8be63c9c0bc45ce5cd15add6add71cedbddb2c25ed044daf4f5e9d746e7bef648f9a1e2c3ed5f",
   "Xie3",	"bc67a6e5",
   "Xie4",	"a8f8ae68bed3b1f1b7a4ba6baa6ec26dc0e8c3c9c1b6c1c2c1dbca67d44ccab6d8b7e561e963e972d95be24aacaad9f1e9f7f263cb5fea5ed2c9cff8b2d8daf2edfcf8c3f1a1ec57ef5ae4daf3fcf6d3",
   "Xin1",	"a4dfb773aa59b2f1c17ea8afbe4ec4c9d860cabbe574cae3a9fdccdfddf5cd51cfe7aae4b360dc63f8caef58",
   "Xin2",	"e9aff0d8e856",
   "Xin3",	"c9b3",
   "Xin4",	"ab48c65dc9c7da5cde76f4b5",
   "Xing1",	"b469ac50b556b87bbfb3d153de7adebcd060dfe8ee7cf9b2",
   "Xing2",	"a644abaca7cea6e6a8b7cbb6cfaded50d278b2bad36ee478e87bb0a4ef4fe0d7",
   "Xing3",	"bff4ececd9fb",
   "Xing4",	"adc6a96da9afa9cab1a2a7f6d4d2d5e5d3aed763",
   "Xiong1",	"a553a5fba4bfa649aca4afddcecccae2",
   "Xiong2",	"bab5b6afe05c",
   "Xiong4",	"dbdb",
   "Xiu1",	"a5f0add7aba6b2dbb2e7cebae5eddb56d3aae05ae4b8f3afec70efa2",
   "Xiu3",	"a6b4eac8",
   "Xiu4",	"b6e5a9a6a871c2b8b353c4c3b7cdd2b5d671e7cc",
   "Xu1",	"a653bc4ebc56a6a6ad45b5eabbddb6b7c5bdd0d8cbe6e559ecd2caf9ddd7cf64e9dfcd77e346e6e9f4aceb53e7adb058f768f7a1f7a8d8f3d963",
   "Xu2",	"ae7d",
   "Xu3",	"aeddb7d6b35cd0dfd872cc4acef3d9fad2b7e6e0e048eba5e859ebda",
   "Xu4",	"a8f9b442a7c7abf2b1d4a6b0b1e5b5b6bafcc4f2bb57b3a4b97acbc4d46dd154cca1dd66c9eed1fcacaee2a9d277ed7cdf43cdb9f0acf2ccdbd8e8d8f95bcd45e2e2",
   "Xuan1",	"b3d9abc5b8a9b061ca69e4ebdce4c0a5d8c5e953d94ad950d955ccccaecfb779d5ccb7dcdeb1f475eaaef2bfe7a1f2e0eb7ebfdce86deedff6c3",
   "Xuan2",	"c461b1dbba78a5c8ca66cc4be17acfcbd66fe6a2c27be7d6dfed",
   "Xuan3",	"bfefcdfad26a",
   "Xuan4",	"b4e8acafaf74b5bae5c0ceecddc9ddddccf0d6adedd1e77cd7b1f758f845b962f361ec54ef60",
   "Xue1",	"c1a7b975e966ca7b",
   "Xue2",	"bec7e950ed4fed62f4cdf8e6",
   "Xue3",	"b3b7f7ab",
   "Xue4",	"ab64a5deccefee7ee065cc5c",
   "Xun1",	"b3d4c274c2c8c548beb1efdbd64fe2c0ed65f27bf4aef0a1e765",
   "Xun2",	"b44db460a6afaab6affbb8dfa8b5b9a5ce7dcecbe5b4cce8d1ece262e9ceacacbcf1f9a3ea4bd2b1ea67d04aeb43f0c3d0bdf858e540",
   "Xun4",	"b453abe0aeeebfb8b054b056a8b3bbb9cbc0e541a6c4d3edf1a3f1da",
   "Y",		"a3b8",
   "Ya1",	"a458a772c0a3a9e3be7ec06ed9b2d4ef",
   "Ya2",	"b250a4faaadeb8c5ccd6cb62b048f3fa",
   "Ya3",	"b0d7b6aec9c4cacfeb56dca6",
   "Ya4",	"a8c8b359aaeec959d4d5d56fd95db4e3da6fcd67cfebe34bdb47ca50cdceebe2f9d3",
   "Yai2",	"b156d4a9dedd",
   "Yan1",	"ab7ca961b9e4b254b4f3b26ab7cfafdab5d2be4dd460ecd6d4fce2b1da6dd2b8f4b4e759e46bf35cec49f6cd",
   "Yan2",	"c459a7b0a9a5c5c9a9b5aa75aaa2c0f9ace3bae1c3b2a8a5c046c343c651d4baf1f8f7d3d15ef7d5d8e5dd77dde9c0d1d667e2f2f8fae372eb5ae3e9d7eedc6eef4af5b1",
   "Yan3",	"b0b3c56bab5eb1bbba74b2b4ad6cc64cc5c4d0e6cdf4f1efce6bf1fcd8daf7d6cebbd94ce5acd951caf1d966f8abd9b0ddf4cb56da4ada7cf5dedf6adb62e7a7e3f9e7c6b66ed7f5e0d1f56af5a1f5b5f97df5bfebc8",
   "Yan4",	"b9bdadf1c360b3f7ae62abdbaecbb54bbf50bf56b578bfcec676b6adc5e4c5e7dcb5d869e945ce6dd4e9ece6f451ddeaf9d0da5df46acd5bc641f7fef840f9a9f849c66fd845f55bf976e8edef76f6bbf86dd978c5ac",
   "Yang1",	"a5a1ac6faa74afb1bbdfc06dca62cbf6cc47cf4bd6efd066e0bd",
   "Yang2",	"a8cbb4adb7a8ac76af4cb7d5bac5a6cfb6a7c347ce52d8dfabe2ceefb77ad2b3deb4e2fedbb1c1edf4fdf8e4d6b1",
   "Yang3",	"a5f5aef1c46fbe69cc62efd0ccbfefd5cfb4d67de3e3",
   "Yang4",	"a9c2ae7ebccbba79efeed6f2",
   "Yao1",	"a45ca65bb3e9a4d4a7afb879c1dcd86ddfb7d7cc",
   "Yao2",	"b3f3abc0b76eb263a4f8babdbd60aad4c1c1bbbbd85cdce0ce5ddcf8b15ce566dd64dd6cba6fd9e2d26cd662deadd2b0dbfee4a2f3adc061f6af",
   "Yao3",	"ab72aa48afb7afe6d450cabcccb3cf57e255cceade4ad2d3d2f8d6c9d0a5f3b5f7c5cac7e3cf",
   "Yao4",	"c4a3c3c4ad6ec65fc563c260effae678d040dae0f0a3dfd3d7c4e446f34de4c8",
   "Ye1",	"bc4ff7f9",
   "Ye2",	"b7a6b7ddb278ad43d95eeced",
   "Ye3",	"a45da74db3a5d4b1e2b2",
   "Ye4",	"a95db77eb8adbfd6c5e2adb6d44fe965e9acecebbee7ddd1d9dfea45de6fea4deda2f650bff3eee4f165f667f1ac",
   "Yi1",	"a440a5eca8ccbeb3b3fcb4a5baaca6e7c2e5aba9c9c9e176efded9daefe9ccfccfabde55ea57d661ea62e2fce349eddfdbbadc54d848f7c3f1e0f877",
   "Yi2",	"bbf6ab78a665a669abbca979c255a9c9bac3b2beafd8bdcbb64dbff2c05bb97ecbb7c96cd166ecd9cea7e95eecdaddbfcb44cf51d1dfaeebddcbe265a85eccf3cf70e66fcfd4d2bfb2add6abedc6db43db42dba6dbb3eb6cd7bbdbcdf64cb059dbdff0ebd3e1e068d3eed441e0c0f36def47f8dfcec3",
   "Yi3",	"a441a548adcaa477ba59b4c8a86fc3c6a8b2b0c0d8e4d1b0c9e6d578d9a8ecf6f05cd05ef2c3d077eb63d0adf4daada3d0c0e0bfe476f3aadcaff8a3",
   "Yi4",	"a5e7a8dbbbf5a4c2c56dabb3a67aabd9a7d0b74ebed0c574a7edb1b3a9f6a6b2bcddb247b7b8b2a7acccaf71bf7ec3b6b871acfdb2ddc16bc16cb877b5c5c172c3c0bb69b8c7b8dac4b3c4b6b663b668a8b6c5e6dcb2c968ca68a748cde2beb0ca70e143d0fadccce948d151d4b0d4b7e94ce16eecd8e961abd4e1bbc9dda47cd1a5e97dccb4d1c3d1baeceed9a6e9b5",
   "Yi41",	"cb40ccddcf41e5ddecf3d1f7d9dee9e2cf7eaf4ae65be9f9f45eda61e66de666ea55ed5ded5ccfcee6b0ea6de36df2afd6f5d6f6c9a9e3a4eaf7cb7be75aedf5f2c9f5f7dff6f94af345dbf3f4e3f4e6d7f8c2eff65eca59d84ce4c1f1a2f554f3ecf8dde8f1f967ceb3dbd7f37c",
   "Yin1",	"a65dabc3b9feaeefaef4aff4b3b1adb5d468d866ecc6ce58d8a1d8feddf6cfa7e2dae2fadaf1e3d3dbc7eba2e4a1eef0ec52eef7f54df54cec65f6cbe1ed",
   "Yin2",	"a775abadb9dbb147b25dbbc8c3f9c569c955efbdd148d4d9d543e5f1d27bd2a4cdc2d779e750f0bfe7ddbbc2dc6cf864efe7",
   "Yin3",	"a4a8a4dec57db043c1f4b6bca776ed41ed56d355c169ee58f8c1e7f2e0dbe4d5f5f4dc68",
   "Yin4",	"a64cad4ebdaed150e1bae978da79e34ae475e1fa",
   "Ying1",	"c458c0a6c4e5b7ebc5d5c174ad5ec561c64ec678d463dcfcf44cddc8da56de7dc4ede6adf277e2f7f5e3eadfc4a2f5faf7faeb74f651eefbf1a7f5b0e7bf",
   "Ying2",	"bec6b7adc373c0e7bcfcacd5bfa2bfc3c3c7c4b9aaefb6f7f444f446f244e26cf25ef45dbab7f96deeabf0a6",
   "Ying3",	"bc76bf6fd5bbd256e5f9f45ff6f4cfe9b072",
   "Ying4",	"c0b3ac4db577dcf9e1efefefe454f16a",
   "Yo1",	"adf2",
   "Yong1",	"b6c4b165c173b06fb96cdcdce8fce156f5cbba48e9e9f5d7f7eaee52bbc1f360f175f776",
   "Yong2",	"d851d871dcfedd4de5e1e2aff1aae178",
   "Yong3",	"ab4dab69bec3b176bed6a5c3aa61b4e9a869b8bab5fabfe3d155dcead1a4af46e6cee45c",
   "Yong4",	"a6fea5ceeec9",
   "You1",	"c075abd5b179bc7ecbe7efbaccaba7f1f24eeff3f5eaf5eff14de0ee",
   "You2",	"a4d7aa6fb4e5b553b7dfa5d1b943b66cb95cbe7bceeaddcdcb4fd25bacd0d75feb4fd7a5e7a2d7caebc9d7e6c9acd2f4",
   "You3",	"a4cda6b3bcf8b2fba8bbc24bd461d176efcae5d0cd4fd04ed7abe47dcc6bcdc4",
   "You4",	"a6f6a453a56babc9a5aeac63afa7bba4b956c35ea8ddca72abaace6eceadcd5cdbe6ecabcaf0d3f1",
   "Yu",	"a3ba",
   "Yu1",	"b24ab7efa8b1d4a5c9e3de40d6a7cda6e350acfa",
   "Yu2",	"a45fa745ab5ca7b1ae54b74db472a9f3b7aec26ab4fcbaaeb7ecaabbacf2aad8b5e3b8b7bfccc1d6b94fb6a8be6cb3bda666d8e1d8e3d967f44fcafdd9bfddf9da42e9f3d2a8cb69f042daaee2e6dad1acebe34cf4aae6eee6f4b5cddf7dd370dfa8eafbf4bcbdc2ee6dbdc9bddbf0dcebc6f659ca53dc5cd7fedca2e8acb3b8f1cef56df1d7f8e0f961d0ac",
   "Yu3",	"a4a9a674c0acb168aceaa6d0bb50bb79ab42c5c5c94fcde3d459dcbae940ae46b0ebdd4ab1d6d97bdde2deb7decfd6bce6d5edc9dfccf4c2ebb3dc5be777",
   "Yu4",	"b3ebb0ecb9e1b44aae6eb173b755bca4b1fdb7b6af44b7d4babba5c9bac7c2a1bf6dc67ea6d6a87ca8a1b8cebfd9c541bfddb94aada7b977b6bfc67be4fbae4bd17bd1acd553e1d8ac52d1e7d9add9b5cce9cb53d252d5e7bf48f9d1ea52c0eef9c6e67adac3d2e1f2a2defde36bf071df67e3b4ee40ee4de3daf9ace467ebd1f150e0b1ebf1e873ec48ec4fdcaef3b0f77df7a7f1c0e8e7eca3f1d9f866f5b7",
   "Yuan1",	"addeb257bbf0c070d8fad9d6d2d7cb75e3b3dfebe3f5ebf0e8d1f3d8f6cff469dfdbe3ec",
   "Yuan2",	"a4b8adecadfbb6e9b6eaabaeb444b4a9a84ab7bdacb8b7e1bd74b04bc1d5e947cabadcf4dd43ccd4e244e25bf258b545de5fdeabda75d346eae3cdb4dfc5e3bed3bbe7b5eb60f4e0cbabf164c4cdf5a8efb1",
   "Yuan3",	"bbb7cc53",
   "Yuan4",	"abe8ba40ad62b07cc440c970d964deb6e343e7cbeeaee442",
   "Yue1",	"a4eaacf9e941e6dc",
   "Yue4",	"a9a8c0aeaeaea4ebb866b656c544be5ca647c97ccaf2e9c4ccf6f465f5dbcd5eaab5cda3f6f7c5d4f5fed3cbb063dc76e0b5f962f9c5efb6",
   "Yun1",	"b777ba72e16aead5eb64f349",
   "Yun2",	"a4aaa4c3a9fbb861afc6afd0b6b3c9b4cab3cb4ede65e658e2bce2becfdaeac0ead4aae5d75deafce0a8e8a3cfe1",
   "Yun3",	"a4b9b96bcae9e266cb65eb70ebb6e465dc75cbb0f176",
   "Yun4",	"a5a5b759bcf7c4adb942c1dfc3fdd940cce0e6e3edf4dc50f3a5f579",
   "Z",		"a3a8",
   "Za1",	"a560cbdfd473e14eccc0e0c4",
   "Za2",	"aba5af7bc2f8f8cdeda9",
   "Zai1",	"ab76aee2a861d9eeebb8",
   "Zai3",	"ae5fd8e6eacd",
   "Zai4",	"a641a662b8fc",
   "Zan1",	"c2aff4ee",
   "Zan2",	"b0afe6e1",
   "Zan3",	"f5c1d873d4f1cedff6e3cef5f8b7f96ff8b5",
   "Zan4",	"c667c3d9f6d9f7e0f6ebc5d0f766c3f5",
   "Zang1",	"c542c5bcd27dc5d8bb4e",
   "Zang3",	"e8ca",
   "Zang4",	"c5a6b8ae",
   "Zao1",	"c156be44dcb7f0fe",
   "Zao2",	"c677",
   "Zao3",	"a6adb4c7befec4a6b044ed6af2b2",
   "Zao4",	"beb8a85fc0eaa86dc4bcb379e1d1cb71c4b7f4d6",
   "Ze2",	"ab68b9bfb9c9bedcbf41b364d8e7e1b2b2c8edbdd756dfc1f2e1f0e9f0f3d0b5d1c8f2e5",
   "Ze4",	"a4b7c97acccadada",
   "Zei2",	"b8e9",
   "Zen3",	"abe7",
   "Zen4",	"f2fb",
   "Zeng1",	"bc57bca8b4bfe9c1eda4eda5c2b9ede3f779ea65",
   "Zeng4",	"c3d8ed70",
   "Zh",	"a3a4",
   "Zha1",	"a4e3b4edccbccee1cf48ddd3e5d7ea74f966",
   "Zha2",	"a5beb2cfb968d0f5e35ad7acf343eed4e8adf9a8",
   "Zha3",	"af77ca75afa4ec7a",
   "Zha4",	"a545a65ca951b763ac5dba5eacb5b34bb642de4bedc0e3dceeca",
   "Zhai1",	"ba4bc24ed1c7",
   "Zhai2",	"a676",
   "Zhai3",	"afb6cc68",
   "Zhai4",	"b6c5b9ebea71d6b9",
   "Zhan1",	"aa67c2a4b8e2c04ccbe1d1d0d1eac0d6dbd1dbdac4b8eec2e0b9f676f853f8d6f8de",
   "Zhan2",	"ee4c",
   "Zhan3",	"ae69b9f1b1d9b7f8c1d3e55addaae25ee9d2e9cdda7ef052eebbe85ce4ccf8d5",
   "Zhan4",	"a6fba565bed4bcc8b4ccb4efafb8baecc5d9c5b8eb59f145e84af358d44e",
   "Zhang1",	"b169b9fcbcccba73babcbcfdc1adb3b9dcb4e160e16be1c5e5c6e35ee468f6a1f7aae852",
   "Zhang3",	"b478baa6c953ef41",
   "Zhang4",	"a456a54db162b9f3a7fabf60b5c8bde3bbd9e1a3c9e9ea7d",
   "Zhao1",	"a9dbac4cb4c2b078aed0cfdfe0b8eee9e8cfcc4f",
   "Zhao3",	"a7e4aa68e2d1dba8",
   "Zhao4",	"a5fca56cc267b7d3b86ebb46b640bbafce55d97dacb7cfc5d345e355e4bdf3e4",
   "Zhe1",	"c1b1be42e177d5ae",
   "Zhe2",	"adf5c4e0a7e9ba50b8bdc1b7bbb3c947d551e1cdcff3e6c6cb73d0a7c2d6f0edf842f94df1c6f8e1f273",
   "Zhe3",	"aaccbdeaebe3",
   "Zhe4",	"aefdbda9b36fc5c2cf43ecfad270ee5b",
   "Zhen1",	"b0bbb772b7a9ba64acc3bac2af75af7abad5bd65bfb2ad73b077d8ccd8d5d5b4e9d7de4ce657deb0deb2e2ece6c3e6d0f4a7d065e3b8e3bff0abeec0e0a2eed3e8d0f97af6b8d8b3",
   "Zhen3",	"aa45af6cb645cae8ccbaddc7d2c1d2d4e6d2d347d6ecdf61bfa6d7bfdc48f35bf568f7c8eadddff1",
   "Zhen4",	"aeb6aed3bbacc2edb07dbe5fbe7dcde0ced6d95fd1dad6a8dfe3e5bde44a",
   "Zheng1",	"b157a9babc78a9c3b1c3aaa7b275c470b843bae5bb5dbffed4c9cc4dcfb3d26dd2cfeac3bdd8e0b2d742",
   "Zheng3",	"ac40bee3d57ee5b3c9a1cda9",
   "Zheng4",	"b456ac46a5bfaf67b5fdc3d2be47",
   "Zhi1",	"a4a7a567a4e4aa4bb1f7a5c4aabeafadc2b4aacfafd7aadbbb6ab0a6e55bdda5cf4ce243cb5bcfdccffcd2f2ad4fdbf4e8e8ecaed059d3dc",
   "Zhi2",	"adc8b0f5abbfc259b4d3b4deaabdc2bebde8c5adcbbbd4b2e57aefceba54efd1cf50d1e8e9beda6ad6c7def9eddeeae8ee68f0cdf0f9e4d8debff748dbce",
   "Zhi3",	"a575aba4a77dabfca6aea4eeace7afc8b36bca74caaacec7caefd1d3d1f2cb54d643de56d2c5aae9f2daf2a5dc40e0adcbafdcb0",
   "Zhi4",	"a8eeabcfbc6da7d3bcb0b4bcaa76baa2aaa5b2a9b569afb4b858b2bfbd6fb86da6dcad50b5edbb73bb78b8feb96ed45fcbdadd49cc6fceb6ceb7d8f4cadbece4ced9f257d5f4d2a6d664d67ae2d9f47ed2ecd6e9d6f9d36ce6fddb55ee70d7bae445f2f5cba4f0f4e06ac5aed0b3d0bbe47ee878f84bd446ec64f563f67eecadf7c1cfa3",
   "Zhong1",	"a4a4a9beb2d7b04ac1e9c4c1c9b1cab8cad4cf60dea1acd8e779ee6ecd58d371",
   "Zhong3",	"b6efbad8b87ebfe6",
   "Zhong4",	"a5f2b2b3adabd45cd8afd8d8b546cb64e6f0d3d3cff5",
   "Zhou1",	"a950a67bac77b5b0a6e0b667cbc5b0e7d876d550cf7cd645d2baed79db4ff64ee7eae07ae84de4aaf1b8efa3",
   "Zhou2",	"a96fb662",
   "Zhou3",	"a9aaa879dee2f3ca",
   "Zhou4",	"ab60a947a97ab1debd4bacf4ad48e4f0ce43e942cca6e2d7c3b3bfa8edd9d440e8cb",
   "Zhu1",	"a8dca6b6aee8af5db2b9affcb5efb8ddbdd1bddebbcbf24cf255cf78eff5d6bedaf9f640dbc8b8f9d0bcef7def73e7d2",
   "Zhu2",	"a5bac0eba6cbaac7bf76c4bdb376f8add2f9d043b5aed754e762f2e2f9a6dbeff7b0eac4dadf",
   "Zhu3",	"a544c5f1a9d6b25ab54ec666b64ace5ff8a7f8f0f8f1dec9d2e0d35becafcd46d847",
   "Zhu4",	"a6eda6eea755ac57aa60afacad52b5dbb345b5f9c5b1be6ec972d8f0aa56cf4de5eccfaed2c3d2cdbae6d6e4d6e2d6f3e37dd777e7d9dbf1dc4be0afe0e7ecb0cf67",
   "Zhua1",	"a7ecbee2ecf9ef66edee",
   "Zhua3",	"a4f6",
   "Zhuai1",	"abfb",
   "Zhuan1",	"b14dbf6ac346e157e16de6aaedbead42e740e070e46cf7adf7b8f0c4",
   "Zhuan3",	"c4dac2e0",
   "Zhuan4",	"bcb6bd66c1c8b9b6deb5eabfedd3f2fcf557",
   "Zhuang1",	"a7a9bcceb2f8b8cbd5ce",
   "Zhuang3",	"ae4e",
   "Zhuang4",	"a7a7bcb2aaacf9bad659",
   "Zhui1",	"b4d5b06cc040ab41f1b6f3ebefa9",
   "Zhui3",	"cd44",
   "Zhui4",	"bc59b46dbaf3c2d8e2d5e2f0ead8e3a7f770ec5df3e3ebaa",
   "Zhun1",	"aad2bdcecabdd9c3cffecdcf",
   "Zhun3",	"ade3b7c7d4ade362d447",
   "Zhun4",	"defc",
   "Zhuo1",	"aebbaee0b4cdb267edb2f6f9",
   "Zhuo2",	"a8f4b0d6a9e5bf42c0dea860b55aac48ad5fb075c54ed0d3d47ec9dfc0c2ecefd97ce5c1d5bfd9bad9b8efe0c9fed255f461da5ae6cbeab9f6fadf6bf4c7e7d8f0e8e840ebe7f7bfd0ec",
   "Zi1",	"a773ab74abbaa7b6b446b264b4febafdaff7b8eab8edbdfdc068c568c9d3d8dbd9c4e9faaf59cd72dae7dba4bfd4e0a7e4bac045eecdf3cff3e9f5acecb7f3f9d1f3d353",
   "Zi2",	"d8d3",
   "Zi3",	"a54aa46cb1eab7bab5b5c9c5ce49cb45cda1d2f1d6d7acf3d054d064cb7ed3a5b8e4d842",
   "Zi4",	"a672aea1ba7ba6dbd0d1d0e7caeed27ed6b0db48db49",
   "Zong1",	"a976b4c4c2dcc34fd0d9d948e671da77e347e6f7df7ae749f0eff3bdf3c6e7b6d8e2",
   "Zong3",	"b6cdc160e1ebe670",
   "Zong4",	"baeabaeec161cef8ea72",
   "Zou1",	"b951c1dddcfad570d9c5d9b4e369db68e7d4eea4d7eab3b5f55ff3c8f3f4f8a1f969",
   "Zou3",	"a8ab",
   "Zou4",	"abb5b47ec64a",
   "Zu1",	"afb2e3c6",
   "Zu2",	"a8f2b1daa8acdcc3d0fbd541d56ae7f6ebc7",
   "Zu3",	"ab5bafaab2d5b641aafdcfd1e4c5",
   "Zuan1",	"f970",
   "Zuan3",	"c4a1f8fcf940",
   "Zuan4",	"c670d965f7ddf9b1",
   "Zui1",	"d470e1abf8b9df6e",
   "Zui3",	"bc4cecc8e1aaed5af046e043",
   "Zui4",	"b3ccb86fbe4bd9a2ed49ecfcdef5d6eebfbfebf4",
   "Zun1",	"b44cbeeabfede54ae564f06df4ebf862",
   "Zun3",	"e0f1e4f7e553bcc1f2f6",
   "Zun4",	"a660d1c1ea51e4b2f857",
   "Zuo2",	"ac51d9cbdefedf4fdfc3",
   "Zuo3",	"a6f5a5aaf077",
   "Zuo4",	"a740b0b5a7a4ae79ac67afaecca9d05fdfdcdc60cddad159",
   NULL
};

#endif /* ~_NO_TGTWB5 */
