/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2003, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/tdgtlist.e,v 4.15 2003/08/13 20:15:16 william Exp $
 */

#ifndef _TDGTLIST_E_
#define _TDGTLIST_E_

#include "tidget.h"

#include "list.e"

#define TDGTLIST_DEF_H_PAD 1
#define TDGTLIST_DEF_V_PAD 1

typedef struct tagListInfo {
   char **entries; /* this is a cache, updated by TdgtListUpdateEntries() */
   DspList *dsp_ptr;

   int first_index;
   int marked_index;
   int num_visible_lines;

   struct CheckArrayRec *p_check_array;

   CVList list;
} ListInfo;

typedef struct tagTdgtList {
   TidgetInfo *pti;

   Window dsp_win, scr_win;
   SimpleWinInfo dsp_win_info, scr_win_info;

   int can_select; /* if FALSE, cannot select an item */
   int multicolor;
   int auto_scroll_on_insert;

   int scr_area_h;
   int scr_dir; /* temporary variable, which direction it's scrolling */

   ListInfo list_info;
} TdgtList;

typedef struct tagListItemInfo {
   char nick_name[MAXSTRING];
   int color_index, font_style;
   char *buf;
} ListItemInfo;

#ifdef _INCLUDE_FROM_TDGTLIST_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_TDGTLIST_C_*/

extern void	TdgtListReset ARGS_DECL((TdgtList*));
extern TdgtList	*CreateTdgtList ARGS_DECL((Window parent_win,
				TidgetInfo *parent_tidgetinfo, int ctl_id,
				int x, int y, int w, int h_pad, int v_pad,
				int num_visible_lines, int can_select,
				int multicolor, int auto_scroll_on_insert));

extern int	TdgtListCleanUpEntries ARGS_DECL((TdgtList*));
extern int	TdgtListUpdateEntries ARGS_DECL((TdgtList*));
extern int	TdgtListScrollToBottom ARGS_DECL((TdgtList*));
extern int	TdgtListInsertString ARGS_DECL((TdgtList*, char*));
extern int	TdgtListInsertListItemInfo ARGS_DECL((TdgtList*,
				ListItemInfo*));
extern int	TdgtListSetAutoScrollOnInsert ARGS_DECL((TdgtList*, int));
extern int	TdgtListGetAutoScrollOnInsert ARGS_DECL((TdgtList*));

extern int	InitTdgtList ARGS_DECL((void));
extern void	CleanUpTdgtList ARGS_DECL((void));

#ifdef _INCLUDE_FROM_TDGTLIST_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_TDGTLIST_C_*/

#endif /*_TDGTLIST_E_*/
