/*
 * Author:      Daniel Ratton Figueiredo <ratton@land.ufrj.br>
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2003, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/tangram2.e,v 4.16 2003/02/25 01:17:41 william Exp $
 */

#ifndef _TGIF_TANGRAM2_E_
#define _TGIF_TANGRAM2_E_

#define CMDID_TANGRAM2_BASE 0x4000

#define CMDID_ABOUT_TANGRAM2           (CMDID_TANGRAM2_BASE+0)
#define CMDID_TANGRAM2_GENERATE_CHAIN  (CMDID_TANGRAM2_BASE+1)
#define CMDID_TANGRAM2_START_SIMULATOR (CMDID_TANGRAM2_BASE+2)
#define CMDID_TANGRAM2_SIMULATION_STEP (CMDID_TANGRAM2_BASE+3)
#define CMDID_TANGRAM2_END_SIMULATOR   (CMDID_TANGRAM2_BASE+4)

#define MAXTANGRAM2CMDIDS (CMDID_ABOUT_TANGRAM2+5)

#ifdef _TANGRAM_II
extern		TgMenuInfo tangram2MenuInfo;
#endif /* _TANGRAM_II */

#ifdef _INCLUDE_FROM_TANGRAM2_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_TANGRAM2_C_*/

#ifdef _TANGRAM_II

/* ======================= Init & CleanUp ======================= */

extern void	CleanUpTangram2 ARGS_DECL((void));
extern int	InitTangram2 ARGS_DECL((void));

/* ======================= Tangram2 Shortcuts ======================= */

extern void	CleanUpTangram2ShortCut ARGS_DECL((void));
extern int	InitTangram2ShortCut ARGS_DECL((void));

extern int	ValidTangram2CmdName ARGS_DECL((char *buf, int buf_sz,
		                                int *pn_num_args));
extern int	ValidTangram2CmdId ARGS_DECL((int nCmdId));
extern int	DoTangram2Cmd ARGS_DECL((int nCmdId, char *args));
extern int	FetchTangram2ShortCutNumArgs ARGS_DECL((int index,
		                                        int *pn_num_args));
extern int	DoTangram2ShortCut ARGS_DECL((int index, char *args));

/* ======================= Tangram2 Internal Commands ======================= */

extern ExecInfo	*Tangram2GetExecInfo ARGS_DECL((char *func_name));

/* ======================= Tangram2 Menu ======================= */

extern int	RefreshTangram2Menu ARGS_DECL((TgMenu*));
extern TgMenu	*CreateTangram2Menu ARGS_DECL((TgMenu*, int X, int Y,
		                               TgMenuInfo*,
		                               int status_str_xlated));
extern int	Tangram2Menu ARGS_DECL((int X, int Y, int TrackMenubar));

/* ======================= Tangram2 Menu Functions ======================= */

extern void	AboutTangram2 ARGS_DECL((void));
extern void	Tangram2GenerateChain ARGS_DECL((char*));
extern void	Tangram2StartSimulator ARGS_DECL((char*));
extern void	Tangram2SimulationStep ARGS_DECL((void));
extern void	Tangram2EndSimulator ARGS_DECL((void));

/* ======================= Tangram2 Misc Functions ======================= */

extern void	Tangram2UpdateInitAttr ARGS_DECL((struct ObjRec *, char*));

#endif /* _TANGRAM_II */

#ifdef _INCLUDE_FROM_TANGRAM2_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_TANGRAM2_C_*/

#endif /*_TGIF_TANGRAM2_E_*/
