/***************************************************************************
                             client.c
                             -------------------
    begin                : May 2001
    copyright            : (C) 2001 by Jorge Allyson Azevedo
                                       Milena Scanferla
                                       Magnos Martinello
                                       Daniel Sadoc
    email                : {allyson,milena,magnos,sadoc}@land.ufrj.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/******************************************************************************************************
 *																									  *
 * Reliable Multicast Protocol (client.c)															  *
 *																									  *
 * Example of usage of the Reliable Multicast Protocol.                                               *
 *																									  *
 * This program receives packets from the multicast group and shows them on the screen.				  *
 *																									  *
 * use tab spacing = 4																				  *
 *																									  *
 ******************************************************************************************************/

#include "rmcast.h"

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define BUFFSIZE 785


int main(int argc, char **argv)
{
    int soc,i, port = 5151;
    
    char buffer[BUFFSIZE];
     
    int sz;
    
    /* strcpy(buffer,"Mensagem de teste!"); */
    
    for (i=0; i<BUFFSIZE-1; i++)
    {
        buffer[i] = i;
    }
    
    buffer[BUFFSIZE-1]= '@'; 
    
    sz=BUFFSIZE;    
     
    fprintf(stderr,"Reliable multicast CLIENT in action!\n");
    
    RM_initialize(0, "rmcastclient.log");
    
    RMDEBUG_setpidip(2,"146.164.47.1");
   
    soc =  RM_joinGroup ("224.1.1.1", port);
    
    if (argc >= 4)
        exit(1);
    
    if (argc == 3)
    {
        for (i=atoi(argv[1]);i<atoi(argv[2]);i++)
         {
            RMDEBUG_setsn(i);
            
            fprintf(stderr,"data size: %d \n",sz);

            RM_sendto    (soc, buffer, sz);

          }  
    }
    else
    {
        if (argc==2)
            RMDEBUG_setsn(atoi(argv[1]));
        else
            RMDEBUG_setsn(0);
/*        
        for(i=0; i<sz; i++)
         {
            if (isalnum((int)buffer[i]))
            {
               fprintf(stderr,"%c ",buffer[i]);
            }
            else
            {
               fprintf(stderr,"\\%d ",buffer[i]);
            }
         }
        
        fprintf(stderr,"sz: %d\n",sz);
*/            
        RM_sendto    (soc, buffer, sz);
    }
    
    getchar();

 
    RM_leaveGroup(soc, "224.1.1.1");

    fprintf (stderr,"Exiting...\n");
    return 1;
}
