/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2002, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/markup.c,v 4.5 2002/01/05 02:48:02 william Exp $
 */

#define _INCLUDE_FROM_MARKUP_C_

#include "tgifdefs.h"

#include "file.e"
#include "http.e"
#include "markup.e"
#include "msg.e"
#include "setup.e"
#include "util.e"

int cmdLineParseHtml=FALSE;

static int parseHtml=FALSE;

/* ===================== Parse Routines ===================== */

static
int DumpHtmlBuf(in_tag, psz_start)
   int in_tag;
   char *psz_start;
{
   int last_ch_is_lf=FALSE;
   char *psz=NULL;

   if (in_tag) {
      for (psz=psz_start; *psz != '\0'; psz++) {
         switch (*psz) {
         case '\r':
            if (psz[1] == '\n') {
               psz++;
            }
            printf("\n");
            last_ch_is_lf = TRUE;
            break;
         case '\n':
            printf("\n");
            last_ch_is_lf = TRUE;
            break;
         default:
            fputc(*psz, stdout);
            last_ch_is_lf = FALSE;
            break;
         }
      }
   } else {
      for (psz=psz_start; *psz != '\0'; psz++) {
         switch (*psz) {
         case '\r':
            if (psz[1] == '\n') {
               psz++;
            }
            printf("\n");
            last_ch_is_lf = TRUE;
            break;
         case '\n':
            printf("\n");
            last_ch_is_lf = TRUE;
            break;
         default:
            fputc(*psz, stdout);
            last_ch_is_lf = FALSE;
            break;
         }
      }
   }
   if (!last_ch_is_lf) {
      printf("\n");
   }
   return TRUE;
}

static
int DoParseMarkUpFile(buf)
   char *buf;
{
   int in_tag=FALSE; /* TRUE if inside a tag (and looking for '>') */
   char *psz_start=buf;

   in_tag = (*psz_start == '<');
   while (psz_start != NULL && *psz_start != '\0') {
      char *psz=NULL, saved_ch='\0';

      if (in_tag) {
         if ((psz=strchr(psz_start, '>')) == NULL) break;

         saved_ch = (*(++psz));
         *psz = '\0';
         DumpHtmlBuf(in_tag, psz_start);
         *psz = saved_ch;
         in_tag = FALSE;
      } else {
         if ((psz=strchr(psz_start, '<')) == NULL) break;

         *psz = '\0';
         DumpHtmlBuf(in_tag, psz_start);
         *psz = '<';
         in_tag = TRUE;
      }
      psz_start = psz;
   }
   if (psz_start != NULL) {
      DumpHtmlBuf(in_tag, psz_start);
   }
   printf("\n");
   fflush(stdout);

   return TRUE;
}

int ParseMarkUpFile(buf, buf_sz, pn_html, psz_content_type)
   char *buf, *psz_content_type;
   int buf_sz, *pn_html;
{
   if (parseHtml) {
      if (*pn_html || *buf == '>') {
         if (!DoParseMarkUpFile(buf)) {
         }
      }
   }
   return TRUE;
}

/* ===================== Init & CleanUp Routines ===================== */

void CleanUpHtml()
{
}

int InitHtml()
{
   parseHtml = FALSE;
   if (!PRTGIF || cmdLineOpenDisplay) {
      char *c_ptr=FALSE;

      if ((c_ptr=XGetDefault(mainDisplay, TOOL_NAME, "ParseHtml")) !=
            NULL && UtilStrICmp(c_ptr, "true") == 0) {
         parseHtml = TRUE;
      }
   }
   if (PRTGIF && cmdLineParseHtml) {
      parseHtml = TRUE;
   }
   return TRUE;
}

