/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1999, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgifcal" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgifcal" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgifcal", the right to sell or distribute derivative
 * works of "tgifcal", the right to distribute "tgifcal" for a fee, and
 * the right to include "tgifcal" or derivative works of "tgifcal" in a
 * for-sale product) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/tgifcal/RCS/tgifintf.h,v 1.0 1999/02/21 22:09:02 william Exp $
 */

#ifndef _TGIFCAL_TGIFINTF_H_
#define _TGIFCAL_TGIFINTF_H_

#ifdef _INCLUDE_FROM_TGIFINTF_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_TGIFINTF_C_*/

extern void	CleanUpTgifInterface ARGS_DECL((void));
extern int	InitTgifInterface ARGS_DECL((void));

extern int	TgifTextJust ARGS_DECL((char *justification));

extern int	TgifAttr ARGS_DECL((
			float *x,
			float *baseline_y,
			char *font_name,
			int font_size,
			int center_justified, /* 1: center, 0: left justified */
			int visible,          /* 1: visible, 0: invisible */
			int name_visible,     /* 1: visible, 0: invisible */
			char *attr_name,      /* the last char must be '=' */
			char *attr_value,
			char *color_str));

extern int	TgifCenterAttr ARGS_DECL((
			float *ltx,
			float *lty,
			float *rbx,
			float *rby,
			char *font_name,
			int font_size,
			int visible,          /* 1: visible, 0: invisible */
			int name_visible,     /* 1: visible, 0: invisible */
			char *attr_name,      /* the last char must be '=' */
			char *attr_value,
			char *color_str));

extern int	TgifText ARGS_DECL((
			float *x,
			float *baseline_y,
			char *font_name,
			int font_size,
			char *buf,
			char *color_str));

extern int	TgifOval ARGS_DECL((
			float *ltx, float *lty, float *rbx, float *rby,
			char *color_str));
extern int	TgifMarkedOval ARGS_DECL((
			float *inside_ltx, float *inside_lty,
			float *inside_rbx, float *inside_rby,
			float *ltx, float *lty, float *rbx, float *rby,
			char *color_str));

extern int	TgifBox ARGS_DECL((
			float *ltx, float *lty, float *rbx, float *rby,
			int solid,    /* 1: filled, 0: hollow (timed) */
			int rotate,   /* 0: no rotate, +1: 45, -1: 135 */
			char *width_spec,
			char *color_str));

extern int	TgifStartVertex ARGS_DECL((float *x, float *y));
extern int	TgifAddVertex ARGS_DECL((float *x, float *y));

extern int	TgifPoly ARGS_DECL((
			char *width_spec,
			char *arrow_width_spec,
			char *arrow_height_spec,
			char *color_str));
extern int	TgifSmooth ARGS_DECL((
			int head, /* 1: smooth near head, 0: smooth near tail */
			int horizontal, /* 1: horizontal, 0: vertical */
			int rotate)); /* 0: no rotate, +1: 45, -1: 135 */

extern int	TgifImportGIF ARGS_DECL((
			char *path, float *x, float *y, float *w, float *h,
			char *gamma, int fit));

extern int	TgifImportJPEG ARGS_DECL((
			char *path, float *x, float *y, float *w, float *h,
			char *gamma,
			int fit)); /* 0: don't fit, 1: stretch to fit */

extern int	TgifGenerate ARGS_DECL((FILE*, char *psz_format));

/* -------------------- Utility Functions -------------------- */

extern void	TgifFree ARGS_DECL((char *pszStr));
extern int	TgifStrCpyN ARGS_DECL((
			char *pszDest, int nMaxDestSz, char *pszSrc));
extern void	TgifTrimBlanks ARGS_DECL((char *pszStr));
extern void	TgifStrLower ARGS_DECL((char *pszStr));
extern char	*TgifStrRChr ARGS_DECL((char *pszStr, int int_ch));
extern char	*TgifGetALine ARGS_DECL((FILE *lpFile));
extern int	TgifPathExists ARGS_DECL((char *pszPath));

extern int	TgifGetCurDir ARGS_DECL((char *buf, int buf_sz));

extern int	TgifDownloadURL ARGS_DECL((char *psz_url, char *tmp_fname));

#ifdef _INCLUDE_FROM_TGIFINTF_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_TGIFINTF_C_*/

#endif /*_TGIFCAL_TGIFINTF_H_*/
