/****************************************************************************
*                   lighting.h
*
*  This module contains all defines, typedefs, and prototypes for LIGHTING.C.
*
*  from Persistence of Vision(tm) Ray Tracer
*  Copyright 1996,1999 Persistence of Vision Team
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file.
*  If POVLEGAL.DOC is not available or for more info please contact the POV-Ray
*  Team Coordinator by email to team-coord@povray.org or visit us on the web at
*  http://www.povray.org. The latest version of POV-Ray may be found at this site.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
*****************************************************************************/


#ifndef LIGHTING_H
#define LIGHTING_H

#include "point.h"



/*****************************************************************************
* Global preprocessor defines
******************************************************************************/

/*DSW*/
/* How many subrays to trace for dispersive media */
#define DEFAULT_DISP_NELEMS  7
/*---*/

/*****************************************************************************
* Global typedefs
******************************************************************************/
/*
 * List to store light colours during shadow testing
 * to avoid repeated testing with layered textures.
 */

typedef struct Light_Tested_Struct LIGHT_TESTED;

struct Light_Tested_Struct
{
  int    Tested;
  COLOUR Colour;
};



/*****************************************************************************
* Global variables
******************************************************************************/



/*****************************************************************************
* Global functions
******************************************************************************/

void Determine_Apparent_Colour (INTERSECTION *Ray_Intersection, COLOUR Colour, RAY *Ray, DBL Weight);
void Initialize_Lighting_Code (void);
void Reinitialize_Lighting_Code (int Number_Of_Entries, TEXTURE ***Textures, DBL **Weights);
void Deinitialize_Lighting_Code (void);
int Test_Shadow (LIGHT_SOURCE *Light, DBL *Depth, RAY *Light_Source_Ray, RAY *Eye_Ray, VECTOR P, COLOUR Colour);


#ifdef UseMediaAndLightCache
void ResizeMediaMallocCaches(long newSize);
void ResizeLightMallocCaches(long newSize);
#endif


#endif
