/****************************************************************************
*                   lightgrp.h
*
*
*****************************************************************************/

#ifndef LIGHTGRP_H
#define LIGHTGRP_H

/* Generic header for all modules */

#include "point.h"

/* XOR */

#define Check_No_Shadow_Group(o,l) \
	(!((l)->In_Group[(o)->No_Shadow_Group]) ^ /* XOR */ \
	!(Test_Flag(o,INVERT_NO_SHADOW_GROUP)))

#define Check_Light_Group(o,l) \
	(!((l)->In_Group[(o)->Light_Group]) ^ /* XOR */ \
	!(Test_Flag(o,INVERT_LIGHT_GROUP)))

#define Check_Media_Light_Group(o,l) \
	(!((l)->In_Group[(o)->Light_Group]) ^ /* XOR */ \
	!((o)->Invert_Light_Group))

unsigned char Get_Light_Group(char *str, int *flag);
void Assign_Light_Groups(LIGHT_SOURCE *Light,char *groups);
void InitLightGroupTable(void);
void DestroyLightGroupTable(void);
void Post_Light_Groups(OBJECT *Object);
void Set_Sibling_Light_Groups(OBJECT *Sib, int Group, int Shadow, int IG, int IS);
#endif
