/* lightgrp.c 
 * 
 * This is the setup code for light_groups, a patch to control which
 * lights interact with which object.
 *
 * Author: Matthew Corey Brown
 *
 * Created : Oct 1998
 *
 */

#include "frame.h"
#include "povproto.h"
#include "lightgrp.h"
#include "povray.h"
#include "point.h"
#include "mem.h"
#include "objects.h"
#include "csg.h"



char **LightGroupNames;



void InitLightGroupTable (void) {
	int i;
	LightGroupNames=(char **)POV_MALLOC(sizeof(char *) * MAXLIGHTGROUPS,"Light Group Table");
	for (i=0;i<MAXLIGHTGROUPS;i++)
		LightGroupNames[i]=NULL;
	LightGroupNames[ALL_GROUP] = pov_strdup("all");
	LightGroupNames[NONE_GROUP] = pov_strdup("none");
}

void DestroyLightGroupTable (void) {
	int i;
	for (i=0;i<MAXLIGHTGROUPS;i++)
		if (LightGroupNames[i]) POV_FREE(LightGroupNames[i]);
	POV_FREE(LightGroupNames);
}

	

unsigned char Get_Light_Group(char *str,int *flag){
	int i;

/*YS*/
  while ( *str!= 0 && *str==' ')
    str++;
  i=strlen(str);
  while ( i && str[i-1]==' ')
  {
    i--;
    str[i]=0;
  }
  i=strlen(str);
  if ( i==0)
    Error("Name expected after comma\n");
/*YS*/

	*flag = 0;

	if (strrchr(str,',') )
		Error("Light Group Names can not contain commas.");
	if (str[0] == '!') {
		*flag = 1;
		str++;
	}
	for(i=0;i<MAXLIGHTGROUPS;i++){
		if (LightGroupNames[i] == NULL) break;
		if (!pov_stricmp(str,LightGroupNames[i]))
			return (unsigned char)i;
	}
	if (i == MAXLIGHTGROUPS)
		Error("Too many Light Groups.");
	LightGroupNames[i]=pov_strdup(str);
	return (unsigned char)i;
}

void Assign_Light_Groups(LIGHT_SOURCE *Light,char *Names){
	char *start;
	int flag;
	if (strrchr(Names,'!') != NULL) 
		Error("Can not have ! in Group names when assigning lights.\n");
	while( (start = strrchr(Names,',') ) != NULL) {
		Light->In_Group[Get_Light_Group((char *)(start+1),&flag)] = TRUE;
		*start='\0';
	}
	Light->In_Group[Get_Light_Group(Names,&flag)] = TRUE;
}



void Set_Sibling_Light_Groups(OBJECT *Sib, int Group, int Shadow,int IG,int IS){
  OBJECT *Current_Sib;

  for (Current_Sib = Sib; Current_Sib != NULL; Current_Sib = Current_Sib->Sibling)
  {
	  if (Current_Sib->Light_Group == NONE_GROUP) {
		  Current_Sib->Light_Group=Group;
		  Bool_Flag(Current_Sib,INVERT_LIGHT_GROUP,IG);
	  }
	  if (Current_Sib->No_Shadow_Group == NONE_GROUP) {
		  Current_Sib->No_Shadow_Group=Shadow;
		  Bool_Flag(Current_Sib,INVERT_NO_SHADOW_GROUP,IS);
	  }
	  if (Current_Sib->Type & COMPOUND_OBJECT) 
		  Set_Sibling_Light_Groups(((CSG *)Current_Sib)->Children, 
			Current_Sib->Light_Group, Current_Sib->No_Shadow_Group,
			Test_Flag(Current_Sib,INVERT_LIGHT_GROUP),
			Test_Flag(Current_Sib,INVERT_NO_SHADOW_GROUP));
  }
}


void Post_Light_Groups(OBJECT *Object){

	if (Object->Light_Group == NONE_GROUP) Object->Light_Group=ALL_GROUP;
    if (Object->Type & COMPOUND_OBJECT) 
		Set_Sibling_Light_Groups(((CSG *)Object)->Children, 
				Object->Light_Group, Object->No_Shadow_Group, 
				Test_Flag(Object,INVERT_LIGHT_GROUP),
				Test_Flag(Object,INVERT_NO_SHADOW_GROUP));
}



