#include <math.h>

#ifdef DLL
  #ifdef _WIN32
   #define EQPTSRF
   #include <windows.h>
   BOOL WINAPI DllMain (HINSTANCE hDLL, DWORD dwReason, LPVOID lpReserved)
   {return TRUE;}
   #undef BLOB
  #endif
#endif

#ifdef DLL
  #ifndef DBL
  #define DBL double
  #endif

  #ifdef _WIN32
    #define DllExport	__declspec( dllexport )
    #define FUNC DllExport DBL 
  #else
    #define FUNC DBL 
  #endif

#ifndef DLL_FRAME
 #define X 0
 #define Y 1
 #define Z 2

 typedef DBL VECTOR [3];
 typedef struct Function_Struct FUNCTION;
 typedef DBL (*ISO_FUNC)(FUNCTION *, VECTOR );

 struct Function_Struct {
   char      *ops_stack;
   DBL       *number_stack;
   int       opslen, numlen;
   unsigned char      Flags;
   char      *func_name;
   DBL       *parm;
   int       pnum;
   DBL       sign;
   ISO_FUNC  iso_func;
   DBL       Max_gradient,gradient;
   char      *isosf;
   DBL       threshold;
   FUNCTION  *prev, *next;
   #ifdef IsoPigmentPatch
#ifndef DLL
   PIGMENT	 *Pigment;		/* Added MCB 12-28-98 */
#endif
   void		 *cache;		/* Added MCB 01-06-00 */
#endif
  };
#ifndef M_PI
#define M_PI   3.1415926535897932384626
#endif

#ifndef M_PI_2
#define M_PI_2 1.57079632679489661923
#endif

#ifndef TWO_M_PI
#define TWO_M_PI 6.283185307179586476925286766560
#endif

#ifndef M_PI_180
#define M_PI_180 0.01745329251994329576
#endif

#ifndef M_PI_360
#define M_PI_360 0.00872664625997164788
#endif

/* Get minimum/maximum of two values. */

#ifndef min
#define min(x,y) (((x)>(y))?(y):(x))
#endif

#ifndef max
#define max(x,y) (((x)<(y))?(y):(x))
#endif

/* Get minimum/maximum of three values. */

#define max3(x,y,z) (((x)>(y))?(((x)>(z))?(x):(z)):(((y)>(z))?(y):(z)))
#define min3(x,y,z) (((x)<(y))?(((x)<(z))?(x):(z)):(((y)<(z))?(y):(z)))

#ifndef labs      /* Absolute value of the long integer x. */
#define labs(x) (long) (((x)<0)?-(x):(x))
#endif

#ifndef fabs      /* Absolute value of the double x. */
#define fabs(x) ((x) < 0.0 ? -(x) : (x))
#endif


#ifndef ACOS
#define ACOS acos
#endif

#ifndef SQRT
#define SQRT sqrt
#endif

#ifndef POW
#define POW pow
#endif

#ifndef COS
#define COS cos
#endif

#ifndef SIN
#define SIN sin
#endif

#ifndef TAN 
#define TAN tan 
#endif

#ifndef ASIN 
#define ASIN asin 
#endif

#ifndef ATAN 
#define ATAN atan 
#endif

#ifndef SINH 
#define SINH sinh 
#endif

#ifndef COSH 
#define COSH cosh 
#endif

#ifndef TANH 
#define TANH tanh 
#endif

#ifndef ASINH 
#define ASINH asinh 
#endif

#ifndef ACOSH 
#define ACOSH acosh 
#endif

#ifndef ATANH 
#define ATANH atanh 
#endif

#ifndef LOG 
#define LOG log 
#endif

#ifndef EXP 
#define EXP exp 
#endif

#ifndef ABS 
#define ABS fabs 
#endif

#ifndef FFLOOR
#define FFLOOR floor
#endif

 #ifndef FCEIL 
 #define FCEIL  ceil   
 #endif

 #else
  #define POVWIN_FILE
  #include "frame.h"
  #include "isosrf.h"
 #endif

  #define x XYZ[X]
  #define y XYZ[Y]
  #define z XYZ[Z]
#endif



#define P0 Func->parm[0]
#define P1 Func->parm[1]
#define P2 Func->parm[2]
#define P3 Func->parm[3]
#define P4 Func->parm[4]
#define P5 Func->parm[5]
#define P6 Func->parm[6]
#define P7 Func->parm[7]
#define P8 Func->parm[8]
#define P9 Func->parm[9]
#define M_2PI 	 6.28318530718
#define M_PI180   0.01745329251994



