/****************************************************************************
*                   glow.h
*
*  This module contains all defines, typedefs, and prototypes for glow.c.
*   Author: Chris Huff
*
*****************************************************************************/


#ifndef GLOW_H
#define GLOW_H


/*****************************************************************************
* Global preprocessor defines
******************************************************************************/

/*This is defined in povray.h, uncommenting it causes a warning or error.
Maybe it should be defined in frame.h instead...
typedef GLOW * GLOW_PTR;*/

/*****************************************************************************
* Global typedefs
******************************************************************************/
struct Glow_Struct
{
    VECTOR Center;
    COLOUR Colour;
    int Glow_Type;
    DBL Size;
    DBL Cutoff_Radius;
    DBL fade_pow;
    TPATTERN * Warps;
    GLOW * next;
};

/*****************************************************************************
* Global variables
******************************************************************************/



/*****************************************************************************
* Global functions
******************************************************************************/

void Do_Glow(INTERSECTION * Isect, RAY * Ray, COLOUR Colour);
GLOW * Create_Glow();
void Add_Glow(GLOW * Glow);
void Destroy_Glow(GLOW * Glow);
void Destroy_Glow_List(GLOW * Glow_List);
void Parse_Glow(GLOW * Glow);
void Transform_Glow(GLOW * Glow, TRANSFORM * Trans);

#endif
