/****************************************************************************
*                f_expr.c
*
*  This module implements the isosurface shapetype.
*  This module was written by D.Skarda&T.Bily and modified by R.Suzuki 
*  for POV3.0.
*
*****************************************************************************/
#include <ctype.h>
#include "frame.h"
#include "povray.h"
#include "vector.h"
#include "povproto.h"
#include "parse.h"
/*--- R.S. July  '96 ---*/
#include "tokenize.h"
#include "render.h"
#include "isosrf.h"
#include "f_expr.h"
#include "express.h"
#ifdef IsoPigmentPatch
#include "parstxtr.h" /* Added MCB 12-28-98*/
#include "pigment.h" /* Added MCB 12-28-98*/
#endif

#ifdef POVISO
#define FUNC_GET_TOKEN() {Func_Parse_Flag=TRUE;Get_Token();Func_Parse_Flag=FALSE;}
int Func_Parse_Flag;
extern FUNCTION *First_Func, *Last_Func;
LIBRARY *First_Lib, *Last_Lib;
extern DBL iso_p[ISOSURFACE_MAXPARM];
/*----*/

extern int CS_Index, Skipping, Inside_Ifdef;
extern DATA_FILE *Data_File;
extern DATA_FILE Include_Files[];
extern int Include_File_Index;
extern int String_Index;
extern int token_count , line_count;
extern FUNCTION Imp_Func;


extern int Include_File_Index;
/*---*/

struct Function_Info_Struct FuncInfo[FE_LAST+1]={
#ifdef IsoBlobPatch
/*
 *  FuncInfo modified by Lummox JR, July 1999:
 *
 *  norm_ functions added, to support new "normal" element of the
 *  Function_Info_Struct structure defined in isosrf.h
 */
  { /*FE_X*/           X_TOKEN,   FI_NUMBER,FP_HIGHEST,func_x,      int_x,      norm_x},
 { /*FE_Y*/           Y_TOKEN,   FI_NUMBER,FP_HIGHEST,func_y,      int_y,      norm_y},
 { /*FE_Z*/           Z_TOKEN,   FI_NUMBER,FP_HIGHEST,func_z,      int_z,      norm_z},
 { /*FE_R*/           R_TOKEN,   FI_NUMBER,FP_HIGHEST,func_r,      int_r,      norm_r},
 { /*FE_S*/           S_TOKEN,   FI_NUMBER,FP_HIGHEST,func_s,      int_s,      norm_s},
 { /*FE_T*/           T_TOKEN,   FI_NUMBER,FP_HIGHEST,func_t,      int_t,      norm_t},
 { /*FE_U*/           U_TOKEN,   FI_NUMBER,FP_HIGHEST,func_u,      int_u,      norm_u},
 { /*FE_V*/           V_TOKEN,   FI_NUMBER,FP_HIGHEST,func_v,      int_v,      norm_v},
 { /*FE_CONSTANT*/   FLOAT_TOKEN,FI_NUMBER,FP_HIGHEST,func_const,  int_const,  norm_const},
 { /*FE_UNARYMINUS*/ DASH_TOKEN, FI_UNARY, FP_HIGH,   func_uminus, int_uminus, norm_uminus},
 { /*FE_sin*/        SIN_TOKEN,  FI_FUNC,  FP_HIGH,   func_sin,    int_sin,    norm_sin},
 { /*FE_asin*/       ASIN_TOKEN, FI_FUNC,  FP_HIGH,   func_asin,   int_asin,   norm_asin},
 { /*FE_cos*/        COS_TOKEN,  FI_FUNC,  FP_HIGH,   func_cos,    int_cos,    norm_cos},
 { /*FE_acos*/       ACOS_TOKEN, FI_FUNC,  FP_HIGH,   func_acos,   int_acos,   norm_acos},
 { /*FE_tan*/        TAN_TOKEN,  FI_FUNC,  FP_HIGH,   func_tan,    int_tan,    norm_tan},
 { /*FE_atan*/       ATAN_TOKEN, FI_FUNC,  FP_HIGH,   func_atan,   int_atan,   norm_atan},
 { /*FE_sinh*/       SINH_TOKEN, FI_FUNC,  FP_HIGH,   func_sinh,   int_sinh,   norm_sinh},
 { /*FE_asinh*/      ASINH_TOKEN,FI_FUNC,  FP_HIGH,   func_asinh,  int_asinh,  norm_asinh},
 { /*FE_cosh*/       COSH_TOKEN, FI_FUNC,  FP_HIGH,   func_cosh,   int_cosh,   norm_cosh},
 { /*FE_acosh*/      ACOSH_TOKEN,FI_FUNC,  FP_HIGH,   func_acosh,  int_acosh,  norm_acosh},
 { /*FE_tanh*/       TANH_TOKEN, FI_FUNC,  FP_HIGH,   func_tanh,   int_tanh,   norm_tanh},
 { /*FE_atanh*/      ATANH_TOKEN,FI_FUNC,  FP_HIGH,   func_atanh,  int_atanh,  norm_atanh},
 { /*FE_ln*/         LN_TOKEN,   FI_FUNC,  FP_HIGH,   func_ln,     int_ln,     norm_ln},
 { /*FE_exp*/        EXP_TOKEN,  FI_FUNC,  FP_HIGH,   func_exp,    int_exp,    norm_exp},
 { /*FE_exp_xy*/     HAT_TOKEN,  FI_BINARY,FP_MEDIUM ,func_exp_xy, int_exp_xy, norm_exp_xy},
 { /*FE_sqrt*/       SQRT_TOKEN, FI_FUNC,  FP_HIGH,   func_sqrt,   int_sqrt,   norm_sqrt},
 { /*FE_sqr*/        SQR_TOKEN,  FI_FUNC,  FP_HIGH,   func_sqr,    int_sqr,    norm_sqr},
 { /*FE_cub*/        CUB_TOKEN,  FI_FUNC,  FP_HIGH,   func_cub,    int_cub,    norm_cub},
 { /*FE_cube*/        CUBE_TOKEN,  FI_FUNC,  FP_HIGH,   func_cub,    int_cub,    norm_cub},
 { /*FE_noise3d*/  NOISE3D_TOKEN,FI_FUNC|FI_3PARAMS,  FP_HIGH,     func_noise3d,  int_noise3d,  norm_noise3d},
 { /*FE_func3d*/   FUNC3D_TOKEN,FI_FUNC|FI_4PARAMS,   FP_HIGH,     func_func3d,  int_func3d,  norm_func3d},
 { /*FE_abs*/        ABS_TOKEN,  FI_FUNC,  FP_HIGH,   func_abs,    int_abs,    norm_abs},
 { /*FE_B_OR*/       BAR_TOKEN, FI_BINARY, FP_LOWEST, func_b_or,  int_b_or,  norm_b_or},
 { /*FE_B_AND*/  AMPERSAND_TOKEN, FI_BINARY, FP_LOWEST, func_b_and, int_b_and, norm_b_and},
 { /*FE_B_MOD*/  PERCENT_TOKEN, FI_BINARY, FP_LOW, func_b_mod, int_b_mod, norm_b_mod},
 { /*FE_B_PLUS*/     PLUS_TOKEN, FI_BINARY,FP_LOWEST, func_b_plus, int_b_plus, norm_b_plus},
 { /*FE_B_MINUS*/    DASH_TOKEN, FI_BINARY,FP_LOWEST, func_b_minus,int_b_minus, norm_b_minus},
 { /*FE_B_MULT*/     STAR_TOKEN, FI_BINARY,FP_LOW    ,func_b_mult, int_b_mult, norm_b_mult},
 { /*FE_B_DIV*/      SLASH_TOKEN,FI_BINARY,FP_LOW    ,func_b_div,  int_b_div, norm_b_div},
 { /*FE_LEFT_PAR*/   LEFT_PAREN_TOKEN, FI_UNARY|FI_PAR, FP_HIGHEST    , NULL, NULL, NULL },
 { /*FE_RIGHT_PAR*/  RIGHT_PAREN_TOKEN,FI_NOARG|FI_BINARY|FI_PAR,0 , NULL, NULL, NULL},
 { /*FE_min*/        MIN_TOKEN,FI_FUNC|FI_TWOPARAMS, FP_HIGH, func_b_min, int_b_min, norm_b_min},
 { /*FE_max*/        MAX_TOKEN,FI_FUNC|FI_TWOPARAMS, FP_HIGH, func_b_max, int_b_max, norm_b_max},
 { /*FE_COMMA*/      COMMA_TOKEN, FI_BINARY|FI_DONT_INS, 0,    NULL, NULL, NULL},
/* Lummox JR, June 1999 */
 { /*FE_ceil*/       CEIL_TOKEN, FI_FUNC,  FP_HIGH,   func_ceil,   int_ceil,   norm_ceil},
 { /*FE_floor*/      FLOOR_TOKEN,FI_FUNC,  FP_HIGH,   func_floor,  int_floor,  norm_floor},
 { /*FE_PI*/         PI_TOKEN,   FI_NUMBER,FP_HIGHEST,func_pi,     int_pi,     norm_pi},
 { /*FE_RADIANS*/    RADIANS_TOKEN,FI_FUNC,FP_HIGH,   func_radians,int_radians,norm_radians},
 { /*FE_DEGREES*/    DEGREES_TOKEN,FI_FUNC,FP_HIGH,   func_degrees,int_degrees,norm_degrees},
 { /*FE_IF*/         IF_TOKEN,   FI_FUNC|FI_3PARAMS, FP_HIGH, func_if, int_if, norm_if},
 { /*FE_ATAN2*/      ATAN2_TOKEN,FI_FUNC|FI_TWOPARAMS, FP_HIGH, func_atan2, int_atan2, norm_atan2},
 { /*FE_CLOCK*/      CLOCK_TOKEN,FI_NUMBER,FP_HIGHEST,func_clock,  int_clock,  norm_clock},
/* End Lummox JR's function additions */
 { /*FE_LAST*/       LAST_TOKEN, FI_DONT_INS, 0 , NULL,NULL,NULL}
#else
 { /*FE_X*/           X_TOKEN,   FI_NUMBER,FP_HIGHEST,func_x,      int_x},
 { /*FE_Y*/           Y_TOKEN,   FI_NUMBER,FP_HIGHEST,func_y,      int_y},
 { /*FE_Z*/           Z_TOKEN,   FI_NUMBER,FP_HIGHEST,func_z,      int_z},
 { /*FE_R*/           R_TOKEN,   FI_NUMBER,FP_HIGHEST,func_r,      int_r},
 { /*FE_S*/           S_TOKEN,   FI_NUMBER,FP_HIGHEST,func_s,      int_s},
 { /*FE_T*/           T_TOKEN,   FI_NUMBER,FP_HIGHEST,func_t,      int_t},
 { /*FE_U*/           U_TOKEN,   FI_NUMBER,FP_HIGHEST,func_u,      int_u},
 { /*FE_V*/           V_TOKEN,   FI_NUMBER,FP_HIGHEST,func_v,      int_v},
 { /*FE_CONSTANT*/   FLOAT_TOKEN,FI_NUMBER,FP_HIGHEST,func_const,  int_const},
 { /*FE_UNARYMINUS*/ DASH_TOKEN, FI_UNARY, FP_HIGH,   func_uminus, int_uminus},
 { /*FE_sin*/        SIN_TOKEN,  FI_FUNC,  FP_HIGH,   func_sin,    int_sin},
 { /*FE_asin*/       ASIN_TOKEN, FI_FUNC,  FP_HIGH,   func_asin,   int_asin},
 { /*FE_cos*/        COS_TOKEN,  FI_FUNC,  FP_HIGH,   func_cos,    int_cos},
 { /*FE_acos*/       ACOS_TOKEN, FI_FUNC,  FP_HIGH,   func_acos,   int_acos},
 { /*FE_tan*/        TAN_TOKEN,  FI_FUNC,  FP_HIGH,   func_tan,    int_tan},
 { /*FE_atan*/       ATAN_TOKEN, FI_FUNC,  FP_HIGH,   func_atan,   int_atan},
 { /*FE_sinh*/       SINH_TOKEN, FI_FUNC,  FP_HIGH,   func_sinh,   int_sinh},
 { /*FE_asinh*/      ASINH_TOKEN,FI_FUNC,  FP_HIGH,   func_asinh,  int_asinh},
 { /*FE_cosh*/       COSH_TOKEN, FI_FUNC,  FP_HIGH,   func_cosh,   int_cosh},
 { /*FE_acosh*/      ACOSH_TOKEN,FI_FUNC,  FP_HIGH,   func_acosh,  int_acosh},
 { /*FE_tanh*/       TANH_TOKEN, FI_FUNC,  FP_HIGH,   func_tanh,   int_tanh},
 { /*FE_atanh*/      ATANH_TOKEN,FI_FUNC,  FP_HIGH,   func_atanh,  int_atanh},
 { /*FE_ln*/         LN_TOKEN,   FI_FUNC,  FP_HIGH,   func_ln,     int_ln},
 { /*FE_exp*/        EXP_TOKEN,  FI_FUNC,  FP_HIGH,   func_exp,    int_exp},
 { /*FE_exp_xy*/     HAT_TOKEN,  FI_BINARY,FP_MEDIUM ,func_exp_xy, int_exp_xy},
 { /*FE_sqrt*/       SQRT_TOKEN, FI_FUNC,  FP_HIGH,   func_sqrt,   int_sqrt},
 { /*FE_sqr*/        SQR_TOKEN,  FI_FUNC,  FP_HIGH,   func_sqr,    int_sqr},
 { /*FE_cub*/        CUB_TOKEN,  FI_FUNC,  FP_HIGH,   func_cub,    int_cub},
 { /*FE_noise3d*/  NOISE3D_TOKEN,FI_FUNC|FI_3PARAMS,  FP_HIGH,     func_noise3d,  int_noise3d},
 { /*FE_func3d*/   FUNC3D_TOKEN,FI_FUNC|FI_4PARAMS,   FP_HIGH,     func_func3d,  int_func3d},
 { /*FE_abs*/        ABS_TOKEN,  FI_FUNC,  FP_HIGH,   func_abs,    int_abs},

 { /*FE_B_OR*/       BAR_TOKEN, FI_BINARY, FP_LOWEST, func_b_or,  int_b_or},
 { /*FE_B_AND*/  AMPERSAND_TOKEN, FI_BINARY, FP_LOWEST, func_b_and, int_b_and},
 { /*FE_B_MOD*/  PERCENT_TOKEN, FI_BINARY, FP_LOW, func_b_mod, int_b_mod},


 { /*FE_B_PLUS*/     PLUS_TOKEN, FI_BINARY,FP_LOWEST, func_b_plus, int_b_plus},
 { /*FE_B_MINUS*/    DASH_TOKEN, FI_BINARY,FP_LOWEST, func_b_minus,int_b_minus},
 { /*FE_B_MULT*/     STAR_TOKEN, FI_BINARY,FP_LOW    ,func_b_mult, int_b_mult},
 { /*FE_B_DIV*/      SLASH_TOKEN,FI_BINARY,FP_LOW    ,func_b_div,  int_b_div},

 { /*FE_LEFT_PAR*/   LEFT_PAREN_TOKEN, FI_UNARY|FI_PAR, FP_HIGHEST    , NULL, NULL },
 { /*FE_RIGHT_PAR*/  RIGHT_PAREN_TOKEN,FI_NOARG|FI_BINARY|FI_PAR,0 , NULL, NULL},

/* Fri 09-27-1996 0. */
 { /*FE_min*/        MIN_TOKEN,FI_FUNC|FI_TWOPARAMS, FP_HIGH, func_b_min, int_b_min},
 { /*FE_max*/        MAX_TOKEN,FI_FUNC|FI_TWOPARAMS, FP_HIGH, func_b_max, int_b_max},
 { /*FE_COMMA*/      COMMA_TOKEN, FI_BINARY|FI_DONT_INS, 0,    NULL, NULL},
/* 0 */

 { /*FE_LAST*/       LAST_TOKEN, FI_DONT_INS, 0 , NULL,NULL}
#endif
  };


extern struct Token_Struct Token;
extern void Parse_Vector_Param (VECTOR Vector);
extern void Parse_Parm (int PMax, int *pnum);

 DBL Parse_Float_Factor (void);

DBL Parse_Float_Factor ()
{
  DBL Local_Float;
  int Exit_Flag; 
  Exit_Flag = FALSE; 
  while (!Exit_Flag) 
  {
    FUNC_GET_TOKEN();
    switch (Token.Token_Id) 
    {
      CASE (FLOAT_TOKEN)
        Local_Float = Token.Token_Float;
        EXIT
      END_CASE
      CASE (FLOAT_ID_TOKEN)
        Local_Float = *((DBL *) Token.Data);
        EXIT
      END_CASE
      OTHERWISE
        Parse_Error_Str ("float factor");
      END_CASE
    }
  }
  return (Local_Float);
}

/*YS*/
char parneeded[][10]={
 "imp_func",
 "R",
 "TH",
 "PH"};
/*YS*/
FUNCTION *Parse_Function (void)
{
  int opslen= 0, nlen=0;
  char lastFunction[255];  /*addes for no params*/
  char ops_stack[FUNC_MAX_STACK_LEN];
  DBL n_stack[FUNC_MAX_STACK_LEN];
  char expect_xnary= FI_UNARY; 
  /* Fri 09-27-1996 0. */
  char number_of_args[FUNC_MAX_STACK_LEN];
  /* 0 */

  char not_ins_ops[FUNC_MAX_STACK_LEN];
  int not_ins_ops_priority[FUNC_MAX_STACK_LEN];
  int n_nis= 0, priority_add=0, nub=0, noa_temp=0;
  #ifdef IsoPigmentPatch
  PIGMENT *LPigment=NULL;   /* Added MCB 12-28-98 */
  #endif
  int p, i, a_flag=FALSE, funcflags=0,curly_flag=FALSE,left_paren_flag=FALSE;
  unsigned int flags, method_flag=0;
  char *tstr;

  FUNCTION *Func;

  int Old_Ok = Ok_To_Declare;
  Ok_To_Declare = FALSE;

  FUNC_GET_TOKEN();
  if (Token.Token_Id == LEFT_CURLY_TOKEN) 
    curly_flag=TRUE; 
  else 
    UNGET
  FUNC_GET_TOKEN();

  #ifdef IsoPigmentPatch
  /*--- MCB    12-28-98 ----*/
  if (Token.Token_Id == PIGMENT_TOKEN) 
  {
    Func = (FUNCTION *) POV_MALLOC (sizeof(FUNCTION), "function");
    Func->func_name = POV_MALLOC (12, "func_name");
    strcpy (Func->func_name, "iso_pigment");
    Func->opslen = 0;
    Func->pnum = 0;
    Func->numlen = 0;
    Func->ops_stack = NULL;
    Func->number_stack = NULL;
    Func->Max_gradient=1.1;
    Func->gradient=0.;
    Func->Flags=0;
    Func->m_flag=0;
    Func->threshold=0.;
    Func->sign=1.;
    Func->cache=NULL;		/*Added MCB 01-06-00 */
    Func->isosf=NULL;		/*Added MCB 01-06-00 */
    Func->prev=Last_Func;
    if (!Last_Func) 
      First_Func=Func;
    else 
      Last_Func->next=Func;
    Last_Func=Func;
    Func->next=NULL;
    Func->Lib=NULL; /* R.S. May 97 */
    Func->Pigment = Create_Pigment();
    Parse_Begin();
    Parse_Pigment(&(Func->Pigment));
    Parse_End();
    Post_Pigment(Func->Pigment);
    if (curly_flag==TRUE)
    {
      Get_Token ();
      if (Token.Token_Id != RIGHT_CURLY_TOKEN) 
        Error("No matching right brace in function");
    }
    Ok_To_Declare = Old_Ok;
    return Func;
  }
  /*--------------------------- */
  #endif
  /*--- R.S.   July 7 '96 ----*/
  if (Token.Token_Id == STRING_LITERAL_TOKEN) 
  {
    Func = (FUNCTION *) POV_MALLOC (sizeof(FUNCTION), "function");
    Func->func_name = POV_MALLOC (strlen(Token.Token_String) + 1, "func_name");
    strcpy (Func->func_name, Token.Token_String);
    Func->opslen = 0;
    Func->numlen = 0;
    /*YS*/ /*added this line, bugfix*/
    Func->pnum = 0;
    /*YS*/

    Func->ops_stack = NULL;
    Func->number_stack = NULL;
    Func->Max_gradient=1.1;
    Func->gradient=0.;
    Func->Flags=0;
    Func->m_flag=0;
    Func->threshold=0.;
    Func->sign=1.;
    Func->cache=NULL;		/*Added MCB 01-06-00 */
    Func->isosf=NULL;		/*Added MCB 01-06-00 */
    Func->prev=Last_Func;
    if (!Last_Func) 
      First_Func=Func;
    else 
      Last_Func->next=Func;
    Last_Func=Func;
    Func->next=NULL;
    Func->Lib=NULL; /* R.S. May 97 */
    Func->pnum=0;   /* R.S. Mar 99 */
    Func->parm=NULL;/* R.S. Mar 99 */

    Func->Pigment = NULL; /* Added MCB 12-28-98 */
    Parse_Comma();
    Get_Token();
    if (Token.Token_Id == LEFT_ANGLE_TOKEN) 
    {
      UNGET;
      Parse_Parm(0,&Func->pnum);
      Func->parm = (DBL *) POV_MALLOC (Func->pnum * sizeof(DBL), "function parm");
      memcpy( Func->parm, iso_p, Func->pnum *sizeof(DBL));
    }
    else 
    {
      /*YS*/
      int x;
      int needed=TRUE;
      for(x=0;x<=3;x++)
      if (     pov_stricmp (parneeded[x], Func->func_name) == 0)
      {
        needed=FALSE;
        break;
      }
      if( needed)
        Error("Function '%s' needs at least one parameter\n",Func->func_name);
      /*YS*/
      UNGET;
    }
    Parse_Comma();
    Get_Token();
    if (Token.Token_Id == LIBRARY_TOKEN)
    {
      GET (STRING_LITERAL_TOKEN);
      tstr = POV_MALLOC (strlen(Token.Token_String) + 1, "lib_name");
      strcpy (tstr, Token.Token_String);
      Func->Lib= POV_MALLOC (sizeof(LIBRARY), "library struct");
      memset(Func->Lib,0,sizeof(LIBRARY));
      Func->Lib->prev=Last_Lib;
      if (!Last_Lib) 
        First_Lib=Func->Lib;
      else 
        Last_Lib->next=Func->Lib;
      Last_Lib=Func->Lib;
      Func->Lib->next=NULL;  
      
      Get_Token();
      Load_Lib(Func->Lib, tstr); /* RS July 18  '96 */
      if (Token.Token_Id == COMMA_TOKEN)
      {
        Get_Token();
        if(Token.Token_Id==ARRAY_ID_TOKEN)
        {
          Func->Lib->pClient=(*(Token.DataPtr));
          Func->Lib->pClientDataSource=PCLIENTDATA_ARRAY;
        }
        else 
        {
          Unget_Token();
          /* .. if its not an array, it should be a filename*/
          Func->Lib->pClient =(void*)Parse_String();
          Func->Lib->pClientDataSource=PCLIENTDATA_FILE;
        }
        /*--dfs*/
        Get_Token();
        if (Token.Token_Id == COMMA_TOKEN) 
        {
          Parse_Parm(0, &Func->Lib->pnum);
          Func->Lib->parm = (DBL *) POV_MALLOC (Func->Lib->pnum * sizeof(DBL), "isosurface lib_parm");
          memcpy( Func->Lib->parm, iso_p, Func->Lib->pnum *sizeof(DBL));
        }
        else 
          Unget_Token();
      }
      else 
      {
        Unget_Token();
        Func->Lib->pClientData =0;
      }
      Init_Lib(Func->Lib);
      POV_FREE(tstr);
    }
    else 
      UNGET;

    if (curly_flag==TRUE)
    {
      Get_Token ();
      if (Token.Token_Id != RIGHT_CURLY_TOKEN) 
        Error("No matching } in function");
    }
    Ok_To_Declare = Old_Ok;
    return Func;
  }
  /*--------------*/

  Unget_Token();
  for(i=0; i<FUNC_MAX_STACK_LEN; i++) number_of_args[i]=0;

  a_flag=2;

  do
  {
    left_paren_flag=FALSE;
    if ((nlen>= FUNC_MAX_STACK_LEN)||(opslen>= FUNC_MAX_STACK_LEN)||
      (n_nis>= FUNC_MAX_STACK_LEN)) Error("Too long function - parser is bored");
      FUNC_GET_TOKEN();
    if((Token.Token_Id==FUNC_ID_TOKEN)&&(n_nis==0))
    {
      Func= (FUNCTION *) Token.Data;
      Load_Function(Func, Func->func_name);
      FUNC_GET_TOKEN();
      UNGET;
      Token.Data= (char *)Func;

      if (Token.Token_Id==LEFT_PAREN_TOKEN)
      {
        Token.Token_Id= FUNC3D_TOKEN;
        left_paren_flag=TRUE;
      }
      else
      {
        Get_Token();
        if (Token.Token_Id== COMMA_TOKEN)
        {
          Get_Token();
          if (Token.Token_Id == LEFT_ANGLE_TOKEN) 
          {
            UNGET;
            Func= Copy_Function( Func );
            Parse_Parm(0,&Func->pnum);
            Func->parm = (DBL *) POV_MALLOC (Func->pnum * sizeof(DBL), "function parm");
            memcpy( Func->parm, iso_p, Func->pnum *sizeof(DBL));
          }
          else 
            UNGET;
        }
        else
        {
          if ((a_flag==2)&&(Token.Token_Id == RIGHT_CURLY_TOKEN)) 
          {
            a_flag=FALSE;
            UNGET;
          }
          else
          {
            method_flag=1;
            memcpy( &n_stack[nlen], &Token.Data, sizeof(char *));
            nlen++;
            UNGET;
            a_flag=TRUE;
          }
        }
        if (a_flag==FALSE)
        {
          if (curly_flag==TRUE)
          {
            Get_Token ();
            if (Token.Token_Id != RIGHT_CURLY_TOKEN) 
              Error("No matching } in function");
          }
          Ok_To_Declare = Old_Ok;
          return Func;
        }
      }
    }
    if (a_flag!=TRUE)
    {
      if (Token.Token_Id==FUNC_ID_TOKEN)
      {
        Func= (FUNCTION *) Token.Data;
        Load_Function(Func, Func->func_name);
        Token.Token_Id= FUNC3D_TOKEN;
        #ifdef IsoPigmentPatch
        LPigment = Func->Pigment;/* Added MCB 12-28-98 */
        #endif
      }
      for (i=0; i<FE_LAST; ++i)
      {
        if ((FuncInfo[i].Token_Number == Token.Token_Id) &&
          ((FuncInfo[i].Flags & FI_XNARY_MASK) == expect_xnary)) 
        {
          /*line added for pars()*/
          strcpy(lastFunction,Token.Token_String);
          break;
        }
      }
      if(i==FE_LAST)
        if (expect_xnary==FI_UNARY) 
          i= FE_CONSTANT;
        else 
          Unget_Token();                /* error or end of function         */

      p= FuncInfo[i].Priority + priority_add;
      flags= FuncInfo[i].Flags & 0xff;
      if (i==FE_func3d) 
      {
        method_flag=1;
        memcpy( &n_stack[nlen], &Token.Data, sizeof(char *));
        nlen++;
      }

      if (n_nis>0) /* R.S. 98.2 */
        if ( !  ((flags & FI_UNARY) && ( FuncInfo[not_ins_ops[n_nis-1]].Flags & FI_UNARY) &&
          (p == not_ins_ops_priority[n_nis-1])))
          while (n_nis>0)
          if (not_ins_ops_priority[n_nis-1] >= p )
          {
            n_nis--;
            ops_stack[opslen]= not_ins_ops[n_nis];
            opslen++;
          }
          else 
            break;

      if ((flags & FI_DONT_INS) == 0)
      {
        not_ins_ops[n_nis]= i;
        not_ins_ops_priority[n_nis]= p;
        n_nis++;

        if (i==FE_func3d) 
        {
          not_ins_ops[n_nis]= FE_CONSTANT;
          not_ins_ops_priority[n_nis]= priority_add+FP_HIGHEST+1;
          n_nis++;
        }
      }
      if (flags & FI_EXPECT_PAR)
      {
        if (left_paren_flag==TRUE) 
          Token.Token_Id = LEFT_PAREN_TOKEN;
        Get_Token ();
        UNGET
        if (Token.Token_Id != LEFT_PAREN_TOKEN) 
        {
          a_flag=TRUE;
          n_nis--;
          n_nis--;
        }
        else
        {
          noa_temp= FI_NUMARGS(FuncInfo[i].Flags);
          if (noa_temp == 4) 
            noa_temp = 2;
        }
      }
      if (flags & FI_UNARY) 
        expect_xnary= FI_UNARY;
      if (flags & FI_BINARY) 
        expect_xnary= FI_UNARY;
      if (flags & FI_NOARG) 
        expect_xnary= FI_BINARY;
      /* OK_X, OK_Y, OK_....           */
      if (i<=FE_V) 
        funcflags|= (1<<i);  
       /* exceptions  -  "(",")", ...    */
      if(i==FE_LEFT_PAR) 
      {
        priority_add+= FP_ADD;
        number_of_args[nub]= noa_temp;
        if ((nub++) >= FUNC_MAX_STACK_LEN) 
          Error("To many right parentheses");
        noa_temp=0;
      }
      if(i==FE_RIGHT_PAR) 
      {
        priority_add-= FP_ADD;
        if (priority_add<0) 
          Error("To many right parentheses");
        nub--;
        if(number_of_args[nub] != 0) 
          Error("Too few arguments");
      }
      if(i==FE_CONSTANT)  /* parse float number   */
      {
        Unget_Token();
        n_stack[nlen]= Parse_Float_Factor();  /* NOT Parse_Float() !!! */
        nlen++;
      }
      if (i==FE_COMMA)    
      { 
        if (nub==0) /* this is comma in parametric surface */
        { 
          i= FE_LAST; 
          UNGET 
        } /* this is comma in parametric surface */
        else
        {
          if ((--number_of_args[nub-1])< 0) 
            Error("Too many arguments");
        }
      }
    }
    if (a_flag==TRUE)
    {
      ops_stack[opslen]= FE_CONSTANT;
      opslen++;
      ops_stack[opslen]= FE_X;
      opslen++;
      ops_stack[opslen]= FE_Y;
      opslen++;
      ops_stack[opslen]= FE_Z;
      opslen++;
      ops_stack[opslen]= FE_func3d;
      opslen++;
      expect_xnary= FI_BINARY;
      a_flag=FALSE;
    }
  } while (i!=FE_LAST);
  /*  any errors?                   */
  if (priority_add != 0) 
    Error("Mising parenthesis");
  if (!nlen) 
    nlen=1;

  Func = (FUNCTION *) POV_MALLOC (sizeof(FUNCTION), "function");
  Func -> Flags= funcflags;
  Func -> m_flag= method_flag;
  Func -> opslen= opslen;
  Func -> numlen= nlen;
  Func -> ops_stack = (char *) POV_MALLOC (opslen, "function ops");
  Func -> number_stack = (DBL *) POV_MALLOC (sizeof(DBL)*nlen, "function num");
  memcpy(Func->ops_stack, ops_stack, opslen);
  memcpy(Func->number_stack, n_stack, nlen * sizeof(DBL) );
  Func->func_name = POV_MALLOC (strlen("imp_func") + 1,"imp_func");
  Func->pnum = 0;
  strcpy (Func->func_name, "imp_func");
  Func->iso_func = NULL;
  Func->Max_gradient=1.1;
  Func->gradient=0.;
  Func->threshold=0.;
  Func->sign=1.;
  Func->cache=NULL;		/*Added MCB 01-06-00 */
  Func->isosf=NULL;		/*Added MCB 01-06-00 */
  Func->prev=Last_Func;
  if (!Last_Func)
    First_Func=Func;
  else 
    Last_Func->next=Func;
  Last_Func=Func;
  Func->next=NULL;
  Func->Lib=NULL;
  #ifdef IsoPigmentPatch
  Func -> Pigment = Copy_Pigment(LPigment); /* Added MCB 12-28-98 */
  #endif
  if (curly_flag==TRUE)
  {
    Get_Token ();
    if (Token.Token_Id != RIGHT_CURLY_TOKEN) 
      Error("No matching } in function");
  }
  Load_Function(&Imp_Func, "imp_func");
  Ok_To_Declare = Old_Ok;
  return (Func);
}
#else
static char dmm[2];
#endif
