
#ifndef POSTPROC_H
#define POSTPROC_H

#ifdef HuffPostProcessPatches
#define sqr(x) ((x)*(x))
#endif
/* #define PostCartoonPatch */

/* post-process requirement flags */
#define PP_FLAG_NONE    0x000
#define PP_FLAG_DEPTH   0x001
#define PP_FLAG_COLOUR  0x002
#define PP_FLAG_IPOINT  0x004
#define PP_FLAG_INORMAL 0x008
#define PP_FLAG_PNORMAL 0x010
#define PP_FLAG_IUV     0x020
#define PP_FLAG_OBJECT  0x040

struct post_process_data_lists
{
  DBL **Depth;
  COLOUR **Colour;
  VECTOR **IPoint;
  VECTOR **INormal;
  VECTOR **PNormal;
  UV_VECT **Iuv;
  int **Object;
};

struct post_process_data
{
  DBL Depth;
  COLOUR Colour;
  VECTOR IPoint;
  VECTOR INormal;
  VECTOR PNormal;
  UV_VECT Iuv;
  int Object;
};
typedef struct post_process_data PP_DATA;
typedef struct post_process_data_lists PP_DATA_LISTS;
typedef struct post_process_task PP_TASK;

typedef void (*POST_PROCESS_METHOD)(PP_TASK *, COLOUR **, COLOUR **, PP_DATA_LISTS, int, int);

typedef void (*POST_PROCESS_DESTROY)(PP_TASK *);

#define POST_PROCESS_FIELDS PP_TASK *next; \
  POST_PROCESS_METHOD doPostProcess; \
  POST_PROCESS_DESTROY DestroyPostProcess;

struct post_process_task
{
  POST_PROCESS_FIELDS
};

void Assign_PP_Data(PP_DATA *pp_data, INTERSECTION *Inter, COLOUR Colour, DBL depth);
void Write_Post_Line(PP_DATA *Line, int y);
void Read_Post_Line(PP_DATA_LISTS Line, int y, int width);
void Open_Post_File();
void Close_Post_File();
void Delete_Post_File();
void DoPostProcess(char* filename);
void Deinitialize_PostProcessing(void);
void Initialize_PostProcessing(void);
void Open_Post_Input();



#ifdef PostProcessPatternBlurPatch
/* ================================================== */
/*  pattern_blur post process */
/* ================================================== */

struct post_process_pattern_blur
{
  POST_PROCESS_FIELDS
  PIGMENT * Pig;
  DBL Radius;
  DBL Div;
  DBL Levelling;
};
typedef struct post_process_pattern_blur PP_PATTERN_BLUR;

PP_PATTERN_BLUR * createPostPatternBlur(void);
void DestroyPostPatternBlur(PP_TASK * task);
void doPostPatternBlur(PP_TASK *, COLOUR **, COLOUR **, PP_DATA_LISTS, int, int);
#define PP_PATTERN_BLUR_FLAGS PP_FLAG_COLOUR
#endif

#ifdef PostProcessStarsPatch
/* ================================================== */
/*  stars post process */
/* ================================================== */

struct post_process_stars
{
  POST_PROCESS_FIELDS
  DBL Density;
  COLOUR colRangeMin;
  COLOUR colRangeMax;
};
typedef struct post_process_stars PP_STARS;

PP_STARS * createPostStars(void);
void DestroyPostStars(PP_TASK * task);
void doPostStars(PP_TASK *, COLOUR **, COLOUR **, PP_DATA_LISTS, int, int);
#define PP_STARS_FLAGS (PP_FLAG_COLOUR|PP_FLAG_DEPTH)
#endif


#ifdef 	PostProcessStepsPatch
/* ================================================== */
/*  steps post process */
/* ================================================== */

struct post_process_steps
{
  POST_PROCESS_FIELDS
  COLOUR numSteps;
};
typedef struct post_process_steps PP_STEPS;

PP_STEPS * createPostSteps(void);
void DestroyPostSteps(PP_TASK * task);
void doPostSteps(PP_TASK *, COLOUR **, COLOUR **, PP_DATA_LISTS, int, int);
#define PP_STEPS_FLAGS PP_FLAG_COLOUR
#endif

#ifdef PostProcesNormalPatch
/* ================================================== */
/*  normal post process */
/* ================================================== */

struct post_process_normal
{
  POST_PROCESS_FIELDS
};
typedef struct post_process_normal PP_NORMAL;

PP_NORMAL * createPostNormal(void);
void DestroyPostNormal(PP_TASK * task);
void doPostNormal(PP_TASK *, COLOUR **, COLOUR **, PP_DATA_LISTS, int, int);
#define PP_NORMAL_FLAGS (PP_FLAG_INORMAL|PP_FLAG_DEPTH)
#endif


#ifdef PostProcessMultiplyPatch
/* ================================================== */
/*  multiply post process */
/* ================================================== */

struct post_process_mult
{
  POST_PROCESS_FIELDS
  PIGMENT * Pig;
};
typedef struct post_process_mult PP_MULT;

PP_MULT * createPostMult(void);
void DestroyPostMult(PP_TASK * task);
void doPostMult(PP_TASK *, COLOUR **, COLOUR **, PP_DATA_LISTS, int, int);
#define PP_MULT_FLAGS PP_FLAG_COLOUR
#endif

#ifdef PostProcessAddPatch
/* ================================================== */
/*  add post process */
/* ================================================== */

struct post_process_add
{
  POST_PROCESS_FIELDS
  PIGMENT * Pig;
};
typedef struct post_process_add PP_ADD;

PP_ADD * createPostAdd(void);
void DestroyPostAdd(PP_TASK * task);
void doPostAdd(PP_TASK *, COLOUR **, COLOUR **, PP_DATA_LISTS, int, int);
#define PP_ADD_FLAGS PP_FLAG_COLOUR
#endif

#ifdef PostProcessExponentPatch
/* ================================================== */
/*  exponent post process */
/* ================================================== */
struct post_process_exp
{
  POST_PROCESS_FIELDS
  PIGMENT * Pig;
};
typedef struct post_process_exp PP_EXP;

PP_EXP * createPostExp(void);
void DestroyPostExp(PP_TASK * task);
void doPostExp(PP_TASK *, COLOUR **, COLOUR **, PP_DATA_LISTS, int, int);
#define PP_EXP_FLAGS PP_FLAG_COLOUR
#endif

#ifdef PostProcessClipColorsPatch
/* ================================================== */
/*  clip_colors post process */
/* ================================================== */

struct post_process_clip_colors
{
  POST_PROCESS_FIELDS
  COLOUR ClipMin;
  COLOUR ClipMax;
};
typedef struct post_process_clip_colors PP_CLIP_COLORS;

PP_CLIP_COLORS * createPostClipColors(void);
void DestroyPostClipColors(PP_TASK * task);
void doPostClipColors(PP_TASK *, COLOUR **, COLOUR **, PP_DATA_LISTS, int, int);
#define PP_CLIP_FLAGS PP_FLAG_COLOUR
#endif

#ifdef PostProcessInvertPatch
/* ================================================== */
/*  invert post process */
/* ================================================== */

struct post_process_invert
{
  POST_PROCESS_FIELDS
};
typedef struct post_process_invert PP_INVERT;

PP_INVERT * createPostInvert(void);
void DestroyPostInvert(PP_TASK * task);
void doPostInvert(PP_TASK *, COLOUR **, COLOUR **, PP_DATA_LISTS, int, int);
#define PP_INVERT_FLAGS PP_FLAG_COLOUR
#endif

#ifdef PostProcessFindEdgesPatch
/* ================================================== */
/*  find_edges post process */
/* ================================================== */

struct post_process_edges
{
  POST_PROCESS_FIELDS
  DBL ThreshDepthMax;
  DBL ThreshNormMax;
  DBL ThreshColMax;
  /*COLOUR LineCol;*/
  DBL Radius;
  DBL Sharpness;
  PIGMENT *LinePig;
};
typedef struct post_process_edges PP_EDGES;

PP_EDGES * createPostEdges(void);
void DestroyPostEdges(PP_TASK * task);
void doPostEdges(PP_TASK *, COLOUR **, COLOUR **, PP_DATA_LISTS, int, int);
#define PP_EDGES_FLAGS (PP_FLAG_COLOUR|PP_FLAG_DEPTH|PP_FLAG_PNORMAL)
#endif

#ifdef PostProcessBlurMatrixPatch
/* ================================================== */
/*  blur_matrix post process */
/* ================================================== */

struct post_process_blur_matrix
{
  POST_PROCESS_FIELDS
  DBL * Matrix;
  DBL Div;
  DBL Levelling;
  int xSize;
  int ySize;
};
typedef struct post_process_blur_matrix PP_BLUR_MATRIX;

PP_BLUR_MATRIX * createPostBlur_Matrix(void);
void DestroyPostBlur_Matrix(PP_TASK * task);
void doPostBlur_Matrix(PP_TASK *, COLOUR **, COLOUR **, PP_DATA_LISTS, int, int);
#define PP_BLUR_MATRIX_FLAGS PP_FLAG_COLOUR
#endif

#ifdef PostProcessColorMatrixPatch
/* ================================================== */
/*  color_matrix post process */
/* ================================================== */

struct post_process_color_matrix
{
  POST_PROCESS_FIELDS
  DBL Matrix[3][3];
};
typedef struct post_process_color_matrix PP_COLOR_MATRIX;

PP_COLOR_MATRIX * createPostColor_Matrix(void);
void DestroyPostColor_Matrix(PP_TASK * task);
void doPostColor_Matrix(PP_TASK *, COLOUR **, COLOUR **, PP_DATA_LISTS, int, int);
#define PP_COLOR_MATRIX_FLAGS PP_FLAG_COLOUR
#endif

/* ================================================== */
/*  Focal Blur post process */
/* ================================================== */

struct post_process_focal_blur
{
  POST_PROCESS_FIELDS
  DBL fieldStart;
  DBL fieldDepth;
  DBL keepAA;
  int maxPixelBlur;
  DBL **Weights;
};
typedef struct post_process_focal_blur PP_FOCAL_BLUR;
PP_FOCAL_BLUR *createPostFocalBlur(void);
void DestroyPostFocalBlur(PP_TASK * task);
void doPostFocalBlur(PP_TASK *, COLOUR **, COLOUR **, PP_DATA_LISTS, int, int);
#define PP_FOCAL_BLUR_FLAGS PP_FLAG_DEPTH

/* ================================================== */
/*  Depth post process */
/* ================================================== */

struct post_process_depth
{
  POST_PROCESS_FIELDS
  DBL fieldDepth;
  DBL fieldStart;
};
typedef struct post_process_depth PP_DEPTH;
PP_DEPTH *createPostDepth(void);
void DestroyPostDepth(PP_TASK * task);
void doPostDepth(PP_TASK *, COLOUR **, COLOUR **, PP_DATA_LISTS, int, int);
#define PP_DEPTH_FLAGS PP_FLAG_DEPTH

/* ============================================================ */
/*  Soft Glow post process */
/* ============================================================ */

struct post_process_soft_glow
{
  POST_PROCESS_FIELDS
  DBL glowAmount;
  DBL blurAmount;
};
typedef struct post_process_soft_glow PP_SOFT_GLOW;
PP_SOFT_GLOW *createPostSoftGlow(void);
void DestroyPostSoftGlow(PP_TASK * task);
void doPostSoftGlow(PP_TASK *, COLOUR **, COLOUR **, PP_DATA_LISTS, int, int);
#define PP_SOFT_GLOW_FLAGS PP_FLAG_NONE

#ifdef PostCartoonPatch
/* ============================================================ */
/*  Cartoon post process */
/* ============================================================ */

struct post_process_cartoon
{
  POST_PROCESS_FIELDS
  DBL blurAmount;
  DBL hueThreshold;
  DBL lumThreshold;

  /*int lineWidth;
  COLOUR lineColour;
  DBL lineHueThreshold;*/
};
typedef struct post_process_cartoon PP_CARTOON;
PP_CARTOON *createPostCartoon(void);
void DestroyPostCartoon(PP_TASK * task);
void doPostCartoon(PP_TASK *, COLOUR **, COLOUR **, PP_DATA_LISTS, int, int);
#define PP_CARTOON_FLAGS PP_FLAG_NONE
#endif

#endif
