/****************************************************************************
*                   mesh.h
*
*  This module contains all defines, typedefs, and prototypes for MESH.C.
*
*  from Persistence of Vision(tm) Ray Tracer
*  Copyright 1996,1999 Persistence of Vision Team
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file.
*  If POVLEGAL.DOC is not available or for more info please contact the POV-Ray
*  Team Coordinator by email to team-coord@povray.org or visit us on the web at
*  http://www.povray.org. The latest version of POV-Ray may be found at this site.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
*****************************************************************************/


#ifndef MESH_H
#define MESH_H

#include "bbox.h"



/*****************************************************************************
* Global preprocessor defines
******************************************************************************/

#ifdef ColorTrianglePatch
/* [AP] */
#define MESH_OBJECT (PATCH_OBJECT+HIERARCHY_OK_OBJECT)
#else
#define MESH_OBJECT (PATCH_OBJECT+HIERARCHY_OK_OBJECT)
#endif


/*****************************************************************************
* Global typedefs
******************************************************************************/

typedef struct Mesh_Struct MESH;
typedef struct Mesh_Data_Struct MESH_DATA;
typedef struct Mesh_Triangle_Struct MESH_TRIANGLE;

struct Mesh_Struct
{
  OBJECT_FIELDS
  TRANSFORM *Trans;  /* Transformation for this object. */
  MESH_DATA *Data;   /* Mesh data holding triangles.    */
  /* NK 1999 these moved from Mesh_Data_Struct */
  long Number_Of_Textures;       /* Number of textures in the mesh.   */
  TEXTURE **Textures;            /* Array of texture references.      */
  /* NK --- */
	/*YS*/
	short has_inside_vector;
	/*YS*/

};

struct Mesh_Data_Struct
{
  int References;                /* Number of references to the mesh. */
  /* NK 1998 */
  long Number_Of_UVCoords;       /* Number of UV coords in the mesh.  */
  /* NK ---- */
  long Number_Of_Normals;        /* Number of normals in the mesh.    */
  long Number_Of_Triangles;      /* Number of trinagles in the mesh.  */
  long Number_Of_Vertices;       /* Number of vertices in the mesh.   */
  SNGL_VECT *Normals, *Vertices; /* Arrays of normals and vertices.   */
  /* NK 1998 */
  UV_VECT *UVCoords;             /* Array of UV coordinates           */
  /* NK ---- */
  MESH_TRIANGLE *Triangles;      /* Array of triangles.               */
  BBOX_TREE *Tree;               /* Bounding box tree for mesh.       */
  VECTOR Inside_Vect;            /* vector to use to test 'inside'    */
};

struct Mesh_Triangle_Struct
{
  unsigned int Smooth:1;         /* Is this a smooth triangle.            */
  unsigned int Dominant_Axis:2;  /* Dominant axis.                        */
  unsigned int vAxis:2;          /* Axis for smooth triangle.             */
#ifdef ColorTrianglePatch
  unsigned int ThreeTex:1;
#endif
  long P1, P2, P3;               /* Indices of triangle vertices.         */
  long Normal_Ind;               /* Index of unsmoothed triangle normal.  */
  long Texture;                  /* Index of triangle texture.            */
  SNGL Distance;                 /* Distance of triangle along normal.    */
  long N1, N2, N3;               /* Indices of smoothed triangle normals. */
  /* NK 1998 */
  long UV1, UV2, UV3;            /* Indicies of UV coordinate vectors     */
  /* NK ---- */
  SNGL_VECT Perp;                /* Vector used for smooth triangles.     */
#ifdef ColorTrianglePatch
  long Texture2, Texture3; /* NK */
#endif
};



/*****************************************************************************
* Global variables
******************************************************************************/

extern METHODS Mesh_Methods;


/*****************************************************************************
* Global functions
******************************************************************************/

MESH *Create_Mesh (void);
int Compute_Mesh_Triangle (MESH_TRIANGLE *Triangle, int Smooth, VECTOR P1, VECTOR P2, VECTOR P3, VECTOR S_Normal);
void Compute_Mesh_BBox (MESH *Mesh);
void Init_Mesh_Triangle (MESH_TRIANGLE *Triangle);
void Build_Mesh_BBox_Tree (MESH *Mesh);
void Test_Mesh_Opacity (MESH *Blob);

void Create_Mesh_Hash_Tables (void);
void Destroy_Mesh_Hash_Tables (void);
int Mesh_Hash_Vertex (int *Number_Of_Vertices, int *Max_Vertices, SNGL_VECT **Vertices, VECTOR Vertex);
int Mesh_Hash_Normal (int *Number_Of_Normals, int *Max_Normals, SNGL_VECT **Normals, VECTOR Normal);
int Mesh_Hash_Texture (int *Number_Of_Textures, int *Max_Textures, TEXTURE ***Textures, TEXTURE *Texture);
/* NK 1998 */
int Mesh_Hash_UV (int *Number, int *Max, UV_VECT **Elements, UV_VECT aPoint);
/* NK ---- */
int Mesh_Degenerate (VECTOR P1, VECTOR P2, VECTOR P3);
void Initialize_Mesh_Code (void);
void Deinitialize_Mesh_Code (void);

#ifdef ColorTrianglePatch
/* AP and NK */
int Mesh_Interpolate(VECTOR Weights, VECTOR IPoint, MESH *m, MESH_TRIANGLE *Triangle);

#endif

#endif
