#ifndef Isosrf_H
#define Isosrf_H

/****************************************************************************
*                isosurf.h
*
*  This module contains all defines, typedefs, and prototypes for isosurf.c.
*  This module was written by R.Suzuki(rsuzuki@etl.go.jp) and D.Skarda&T.Bily. 
*
*****************************************************************************/

typedef struct Function_Struct FUNCTION;
typedef struct Parametric_Struct PARAMETRIC;
typedef struct PrecompParValues_Struct PRECOMP_PAR_DATA; 

typedef struct IsoSurface_Struct ISOSURFACE;
typedef struct Library_Struct LIBRARY;
/*dfs-- 12/23/99*/
/* possible sources for pClientData */
#define PCLIENTDATA_FILE  0
#define PCLIENTDATA_ARRAY 1
/*--dfs*/
struct Library_Struct {
    char   *lib_name;
    DBL    *parm;
    int    pnum;
    char   *pClient;
    void   *pClientData;
    /*dfs--12/23/99*/
    int    pClientDataSource;
    /*--dfs*/
    LIBRARY  *prev, *next;
  };
  typedef DBL (*INIT_FUNC)(LIBRARY *);

typedef DBL (*ISO_FUNC)(FUNCTION *, VECTOR );
typedef struct {DBL t,f;} ISO_Pair;

#define ISOSURFACE_OBJECT   (BASIC_OBJECT)
#define ISOSURFACE_MAXTRACE 20
#ifndef ISOSURFACE_MAXPARM
  #define ISOSURFACE_MAXPARM  100
#endif

#define Decrease_Counter(x) { if ((--(x).low) == -1L) { (x).high--; } }

struct IsoSurface_Struct
  {
   OBJECT_FIELDS 
   TRANSFORM *Trans; 
   VECTOR bounds[2];
   int  Inverted;

   FUNCTION  *Func;         
   DBL       accuracy;
   int       max_trace;
#ifdef IsoBlobPatch
   char      normal_type;  /* Lummox JR, July 1999 */
#endif
   VECTOR P,D;
   int    cache;
   DBL    grad_parm[3];
   DBL    Vlength;
   DBL    depth[ISOSURFACE_MAXTRACE];
   DBL    tl;
   DBL    fmax;
   int    gradient_flag;
   int    Eval;
   int    closed;
   int    Inv3;
   LIBRARY  *Lib;
   int     method;
   int     bound_shape;
  };


struct Function_Info_Struct {
   TOKEN Token_Number;
   char  Flags;
   char  Priority;
   void  (*function)();
   void  (*interval)();
   #ifdef IsoBlobPatch
      void  (*normal)();
#endif
  };


struct Function_Struct {
   char      *ops_stack;
   DBL       *number_stack;
   int       opslen, numlen;
   unsigned char      Flags;
   unsigned char      m_flag;
   char      *func_name;
   DBL       *parm;
   int       pnum;
   DBL       sign;
   ISO_FUNC iso_func;
   DBL       Max_gradient,gradient;
   ISOSURFACE  *isosf;
   DBL       threshold;
   FUNCTION  *prev, *next;
   LIBRARY   *Lib;
   #ifdef IsoPigmentPatch
   PIGMENT	 *Pigment;		/* Added MCB 12-28-98 */
#endif  
   void	     *cache;			/* Added MCB 01-04-00 */
  };


#define IMPFUN_OBJECT            (BASIC_OBJECT)
#define PARAMETRIC_OBJECT        (PATCH_OBJECT) 

struct  ImpFun_Struct {
   OBJECT_FIELDS
   TRANSFORM *Trans;
   VECTOR    bounds[2];   
   short     Inverted;  /* same as Box_struct, so we can use intersect_boxx :)*/
                        /* in C-- way: 
                          class Impfun_Struct: public Box_Struct              */ 
   FUNCTION  *Func;         
   DBL       accuracy;
   int       max_trace;
  };

struct PrecompParValues_Struct {
   int      use, depth;
   char     flags;

   DBL      *Low[3], *Hi[3];     /*  X,Y,Z  */
 };


struct Parametric_Struct {
  OBJECT_FIELDS
  DBL       last_u, last_v;  /* moved by N.Kopp May 97*/

  TRANSFORM *Trans;   
  VECTOR    bounds[2];
  short     Inverted; 

  FUNCTION  *Func[3];

  DBL       umin, umax, vmin, vmax;

  DBL       accuracy;
#ifdef IsoBlobPatch
  char      normal_type;  /* Lummox JR, July 1999 */
#endif
  PRECOMP_PAR_DATA *PData;
 };

void Destroy_Function (FUNCTION *Func);
FUNCTION *Copy_Function (FUNCTION *Func);
void Imp2XY (FUNCTION *Func);

PARAMETRIC  *Create_Parametric (void);
void Destroy_Parametric (OBJECT *Object);
void *Copy_Parametric (OBJECT *Object);
void Compute_Parametric_BBox (PARAMETRIC *Param);

PRECOMP_PAR_DATA *Precompute_Parametric_Values(PARAMETRIC *Par, char flags, int depth);
PRECOMP_PAR_DATA *Copy_PrecompParVal (PRECOMP_PAR_DATA *PPV);
void Destroy_PrecompParVal (PRECOMP_PAR_DATA *PPV);

void Destroy_All_Functions (void);
ISOSURFACE  *Create_IsoSurface (void);
void Destroy_IsoSurface (OBJECT *Object);
void *Copy_IsoSurface (OBJECT *Object);
void Compute_IsoSurface_BBox (ISOSURFACE *Box);

DBL iso_func (FUNCTION *Func, VECTOR);
DBL iso_fn (ISOSURFACE *Isosrf, DBL *Dbl);
void Load_Function (FUNCTION *Func, char *funcname);
void Load_Lib (LIBRARY *Lib, char *lib_name);
void Init_Lib (LIBRARY *Lib);
void Finish_Lib(LIBRARY * Lib);
void Destroy_Library( LIBRARY *Lib );
void Destroy_All_Library( void);

extern LIBRARY *First_Lib, *Last_Lib;

int iso_find_root(ISOSURFACE *, VECTOR, VECTOR, DBL *, DBL*, int *, int *);
int iso_find_root_R(ISOSURFACE *, ISO_Pair *,  ISO_Pair*, DBL, DBL);
/*YS 2000 Added these 4*/
FUNCTION *Parse_Function (void);
ISO_FUNC find_iso_func(char * fname);
DBL i_dat3dinitialize(LIBRARY *Lib);
DBL i_dat3dfinish(LIBRARY *Lib) ;
/*YS*/

extern METHODS IsoSurface_Methods;

#endif
