//	Persistence of Vision Ray Tracer Scene Description File
//	File: object_pattern.pov
//	Date: 12/12/99
//	Author: Ren Smellenbergh
//	Demo object patterns
#version unofficial MegaPov 0.4;

#include "textures.inc"
#include "colors.inc"
#include "golds.inc"

camera {
	location <0.0, 0.0, -14>
	up y*image_height right x*image_width
	angle 45
	look_at <0.0, 0.0, 0.0>
	rotate x*10
}

light_source {
	<20, 60, -30>
	rgb <1.0, 1.0, 1.0>
}
light_source {
	<0, 0, -14>
	rgb <1.0, 1.0, 1.0>*0.7
	rotate x*10
	shadowless
}
light_source {
	<0.0, 0, 0>
	rgb  0.25
}

#declare StarObj =
union {
		#declare C = 0;
	#declare Copies =20;
			#while ( C < Copies)
		prism {
			linear_spline
			linear_sweep
			0, 	//Base height
			2.1, 	//Top height
			13,
			<0.25419, 0.00000>,
			<0.86603, 0.50000>,
			<0.14121, 0.24459>,
			<-0.00000, 1.00000>,
			<-0.14121, 0.24459>,
			<-0.86603, 0.50000>,
			<-0.28243, -0.00000>,
			<-0.86603, -0.50000>,
			<-0.14121, -0.24459>,
			<0.00000, -1.00000>,
			<0.14121, -0.24459>,
			<0.86603, -0.50000>,
			<0.25419, 0.00000>
			sturm
			scale <0.4, 1, 0.4>
			rotate x * (-89.5)
			rotate y * (0 + (C * (360)/(Copies -1)))
		} //object
		#declare C = C +1;
	#end  //while (C < Copies)
	cylinder {
		<0, -0.05, 0>, <0, 0.05, 0>, 2.0
		translate y*0.5
	}
	cylinder {
		<0, -0.05, 0>, <0, 0.05, 0>, 2.0
		translate y*-0.5
	}
}
	
sphere {
	<0.0, 0.0, 0.0>, 2
	texture {
		object { 
			StarObj
			texture { Brushed_Aluminum scale 0.06},
			texture { Dark_Green_Glass}
		}
	}
	translate x*-0.3
}

#declare TexObj =
union {

#declare C = 0;
#declare Copies = 50;

#declare S2 = -1;
#while ( C < Copies)
	text {
		ttf "arial",
		"POV"
		0.3, <0.0, 0.0, 0.0>
		align_center

		scale < (0.25), 1, 1 >
		#if (((C/(25)) - floor (C/(25))) = 0)		#declare SubC2 = 0;	#declare S2 = S2 * -1;#end  //reverse
		scale < 1, (0.4 #if (S2<0) + ((0.8 -(0.4))/(25) * (25)) #end + (((SubC2 * (0.8 -(0.4))/(25 -1))) * S2 )), 1 >
		rotate z * -(360*5)/250
		translate z * (-1.1)
		rotate y * (0 + (C * (360*5)/(Copies -1)))
		translate y * (-2 + (C * (2 - (-2))/(Copies -1)))
	} //object
	#declare SubC2 = SubC2+1;
	#declare C = C +1;
#end  //while (C < Copies)
}
	
cylinder {
	<0, -3, 0>, <0, 3, 0>, 1
	texture {
		pigment { object { TexObj pigment { BakersChoc }, pigment { color <1, 1, 0>} }}
		finish {
			phong 1.0
			phong_size 300
		}
	}
	scale 0.6
	rotate z*-90
	rotate y*-45
	translate <1.3, -1.0, -2.4>
}

#declare Border =
// Point connector macro
#macro P_C_P ( Center, Radius,  Center2,  Radius2)
	#local dx = Center2.x - Center.x ;		#if (dx=0) #declare dx= 0.000001; #end
	#local dy = Center2.y - Center.y ;
	#local dz = Center2.z - Center.z ;
	#local len = sqrt (dx*dx+dy*dy+dz*dz);
	#local xylen = sqrt (dx*dx+dy*dy);
	#local D = acos( (Radius-Radius2)/len);
		< cos(D)*Radius, 0, 0>, sin(D)*Radius ,
		< len + (cos(D)*Radius2), 0, 0>, sin(D)*Radius2
	rotate <0,  degrees(-atan2(dz, xylen)), degrees(atan2 (dy, dx))>
	translate <Center.x, Center.y, Center.z>
#end

#declare C = 0;
#declare Copies = 600;

union {
	#while ( C < Copies)
		#declare Center = <0, 0, 0>;   #declare Radius = 1.0;
		#declare Center2 = <0, 0, 0>;   #declare Radius2 = 1.0;
		sphere {

			#declare Radius = Radius * (0.07);
			#declare Radius2 = Radius2 * (0.07);
			#declare Tx = (0.15);
			#declare Center = Center + <Tx, 0, 0>;
			#declare Tx2 = (0.15);
			#declare Center2 = Center2 + <Tx2, 0, 0>;
			#declare Roty = (0.0 + (C * (360*14 - (0.0))/(Copies -1)));
			#declare Center = vaxis_rotate (Center, y, Roty);
			#declare Roty2 = (0.0 + ((C+1) * (360*14 -(0.0))/(Copies -1)));
			#declare Center2 = vaxis_rotate (Center2, y, Roty2);
			#declare Tx = (4.6);
			#declare Center = Center + <Tx, 0, 0>;
			#declare Tx2 = (4.6);
			#declare Center2 = Center2 + <Tx2, 0, 0>;
			#declare Roty = (0.0 + (C * (360)/(Copies -1)));
			#declare Center = vaxis_rotate (Center, y, Roty);
			#declare Roty2 = (0.0 + ((C+1) * (360)/(Copies -1)));
			#declare Center2 = vaxis_rotate (Center2, y, Roty2);
			Center, Radius
		}
		#if ((C+1) < Copies)
			cone { P_C_P ( Center, Radius, Center2,  Radius2) }
		#end  //#if ((C+1) < Copies)
		#declare C = C +1;
	#end  //while (C < Copies)
	texture {
		pigment { color rgbft < 1.000000,0.000000, 0.000000,0, 0> }
	}
	scale <1/5, 5, 1/5>
	translate y*0.3
}


lathe {
	bezier_spline
	20, 
	<0.00000, 0.00000>,
	<0.10526, 0.00250>,
	<0.67419, -0.00750>,
	<0.75940, 0.00250>,
	<0.75940, 0.00250>,
	<0.81955, 0.10000>,
	<0.91980, 0.16750>,
	<1.00000, 0.17100>,
	<1.00000, 0.17100>,
	<1.03008, 0.17100>,
	<1.02196, 0.20929>,
	<0.99499, 0.20850>,
	<0.99499, 0.20850>,
	<0.86717, 0.18750>,
	<0.79950, 0.12000>,
	<0.73684, 0.03000>,
	<0.73684, 0.03000>,
	<0.61905, 0.02500>,
	<0.10777, 0.02650>,
	<0.00501, 0.02650>
	sturm
	texture {
		object { 
			Border
			texture { pigment { rgb <1.0, 1.0, 1.0> } finish { phong 1.0 phong_size 500 }},
			texture { T_Gold_3E }
		}
	}
	scale <5, 2.0, 5>
	translate y*-1.7
}


#declare P_Cloud5 =
pigment {
    wrinkles
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0, 0.1   color rgb <0.85, 0.85, 0.85>+<0.2, 0.2, 0.2>
                    	color rgb <0.75, 0.75, 0.75>+<0.2, 0.2, 0.2>]
        [0.1, 0.5   color rgb <0.75, 0.75, 0.75>+<0.2, 0.2, 0.2>
                    color rgb <0.258, 0.258, 0.435>+<0.2, 0.2, 0.2>  ]
        [0.5, 1.001 color rgb <0.258, 0.258, 0.435>+<0.2, 0.2, 0.2>
                    color rgb <0.258, 0.258, 0.435>+<0.2, 0.2, 0.2> ]
    }
    scale <6, 1, 6>
}

#declare P_Cloud6 =
pigment {
    bozo
    color_map {
        [0.0, 0.1  color rgb <0.85, 0.85, 0.85>+<0.2, 0.2, 0.2>
                    	color rgb <0.55, 0.60, 0.65>+<0.2, 0.2, 0.2>]
        [0.1, 0.5   color rgb <0.55, 0.60, 0.65>+<0.2, 0.2, 0.2>
                    	color rgb <0.184, 0.184, 0.309>+<0.2, 0.2, 0.2> ]
        [0.5, 1.001 color rgb <0.184, 0.184, 0.309>+<0.2, 0.2, 0.2>
                   		 color rgb <0.1, 0.1, 0.2>+<0.2, 0.2, 0.2>]
    }
    turbulence 0.65
    octaves 6
    omega 0.707
    lambda 2
    scale <6, 4, 6>
}

#declare S_Cloud8 =
sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.01 rgb <0.847, 0.749, 0.847> ] // horizon
            [0.25 P_Cloud5 scale 0.25 rotate z*5]
            [0.60 P_Cloud6 scale <0.25, 0.15, 0.25> rotate z*10]
        }
    }
}

sky_sphere { S_Cloud8 scale <1, 1, 1> translate y*-0.28}
