//	Persistence of Vision Ray Tracer Scene Description File
//	File: blur_reflect.pov
//	Date: 13-05-2000
//	Author: R. Smellenbergh
//	Demo of blurred reflection

#version unofficial MegaPov 0.5;

camera {
	location <0.0, 0.0, -4>
	up y*image_height right x*image_width
	angle 40
	look_at <0.0, 0.0, 0.0>
	rotate x*35
}

light_source { 	<1000, 4500, -4000> 	rgb 1.0 }

//left-front: normal reflection
box {
	<-0.5, -0.1, -0.5>, <0.5, 0.0, 0.5>
	texture {
		pigment { rgb <0.963424, 0.990112, 0.829862> }
		finish { reflection 1.0 }
	}
	translate <-0.6, 0, -0.5>
}
sphere {
	<0.0, 0.0, 0.0>, 0.2
	texture {
		pigment {
			gradient y
			color_map {
				[ 0.000 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 1
				[ 0.100 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 2
				[ 0.214 rgbft <0.5, 0.5, 1.0, 0.0, 0.0> ]	//indigo
				[ 0.328 rgbft <0.2, 0.2, 1.0, 0.0, 0.0> ]	//blue
				[ 0.442 rgbft <0.2, 1.0, 1.0, 0.0, 0.0> ]	//cyan
				[ 0.556 rgbft <0.2, 1.0, 0.2, 0.0, 0.0> ]	//green
				[ 0.670 rgbft <1.0, 1.0, 0.2, 0.0, 0.0> ]	//yellow
				[ 0.784 rgbft <1.0, 0.5, 0.2, 0.0, 0.0> ]	//orange
				[ 0.900 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red1
				[ 1.000 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red2
			}
			scale <0.3, 0.3, 0.3>
		}
		finish { phong 1.0 phong_size 200 }
	}
	translate <-0.6, 0.2, -0.5>
	no_shadow
}


//left-back: minimal blurred reflection
box {
	<-0.5, -0.1, -0.5>, <0.5, 0.0, 0.5>
	texture {
		pigment { rgb <0.963424, 0.990112, 0.829862>*0.86 }
		finish {
			reflection 1.0
			reflection_blur 0.05
			reflection_samples 25
		}
	}
	translate <-0.6, 0, 0.7>
}
sphere {
	<0.0, 0.0, 0.0>, 0.2
	texture {
		pigment {
			gradient y
			color_map {
				[ 0.000 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 1
				[ 0.100 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 2
				[ 0.214 rgbft <0.5, 0.5, 1.0, 0.0, 0.0> ]	//indigo
				[ 0.328 rgbft <0.2, 0.2, 1.0, 0.0, 0.0> ]	//blue
				[ 0.442 rgbft <0.2, 1.0, 1.0, 0.0, 0.0> ]	//cyan
				[ 0.556 rgbft <0.2, 1.0, 0.2, 0.0, 0.0> ]	//green
				[ 0.670 rgbft <1.0, 1.0, 0.2, 0.0, 0.0> ]	//yellow
				[ 0.784 rgbft <1.0, 0.5, 0.2, 0.0, 0.0> ]	//orange
				[ 0.900 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red1
				[ 1.000 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red2
			}
			scale <0.3, 0.3, 0.3>
		}
		finish { phong 1.0 phong_size 200 }
	}
	translate <-0.6, 0.2, 0.9>
	no_shadow
}

//right-back: reflection more blurred
box {
	<-0.5, -0.1, -0.5>, <0.5, 0.0, 0.5>
	texture {
		pigment { rgb <0.963424, 0.990112, 0.829862>*0.88 }
		finish {
			reflection 1.0
			reflection_blur 0.15
			reflection_samples 80
		}
	}
	translate <0.6, 0, 0.7>
}
sphere {
	<0.0, 0.0, 0.0>, 0.2
	texture {
		pigment {
			gradient y
			color_map {
				[ 0.000 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 1
				[ 0.100 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 2
				[ 0.214 rgbft <0.5, 0.5, 1.0, 0.0, 0.0> ]	//indigo
				[ 0.328 rgbft <0.2, 0.2, 1.0, 0.0, 0.0> ]	//blue
				[ 0.442 rgbft <0.2, 1.0, 1.0, 0.0, 0.0> ]	//cyan
				[ 0.556 rgbft <0.2, 1.0, 0.2, 0.0, 0.0> ]	//green
				[ 0.670 rgbft <1.0, 1.0, 0.2, 0.0, 0.0> ]	//yellow
				[ 0.784 rgbft <1.0, 0.5, 0.2, 0.0, 0.0> ]	//orange
				[ 0.900 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red1
				[ 1.000 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red2
			}
			scale <0.3, 0.3, 0.3>
		}
		finish { phong 1.0 phong_size 200 }
	}
	translate <0.6, 0.2, 0.9>
	no_shadow
}

//right-front: reflection even more blurred
box {
	<-0.5, -0.1, -0.5>, <0.5, 0.0, 0.5>
	texture {
		pigment { rgb <0.963424, 0.990112, 0.829862>*0.8 }
		finish {
			reflection 1.0
			reflection_blur 0.3
			reflection_samples 100
		}
	}
	translate <0.6, 0, -0.5>
}
sphere {
	<0.0, 0.0, 0.0>, 0.2
	texture {
		pigment {
			gradient y
			color_map {
				[ 0.000 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 1
				[ 0.100 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 2
				[ 0.214 rgbft <0.5, 0.5, 1.0, 0.0, 0.0> ]	//indigo
				[ 0.328 rgbft <0.2, 0.2, 1.0, 0.0, 0.0> ]	//blue
				[ 0.442 rgbft <0.2, 1.0, 1.0, 0.0, 0.0> ]	//cyan
				[ 0.556 rgbft <0.2, 1.0, 0.2, 0.0, 0.0> ]	//green
				[ 0.670 rgbft <1.0, 1.0, 0.2, 0.0, 0.0> ]	//yellow
				[ 0.784 rgbft <1.0, 0.5, 0.2, 0.0, 0.0> ]	//orange
				[ 0.900 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red1
				[ 1.000 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red2
			}
			scale <0.3, 0.3, 0.3>
		}
		finish { phong 1.0 phong_size 200 }
	}
	translate <0.6, 0.2, -0.5>
	no_shadow
}

// Create an infinite sphere around scene and allow any texture on it
sky_sphere {
	pigment   {
		gradient y
		color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
	}
}
