#version unofficial MegaPov 0.5;

/****************************************************************
radiance_media_photons.pov

Author: Nathan Kopp

This scene demonstrates all lighting models available in POV.
It uses "radiosity" (aka radiance, diffuse->diffuse interaction),
photons (specular->diffuse and transmittance->diffuse), and direct
lighting.

This scene also includes media and can display photons within
the media.

This scene is intended to look similar to a scene rendered with
ART.

The clear objects in this scene all have white(clear) surfaces,
and get their color from fade_colour, fade_distance, and 
fade_power in their interiors.

*****************************************************************/

// Adjust these parameters to modify which features are
// enabled for the render

$clear_textures=yes;
$use_photons=yes;
$use_light=yes;
$use_rad=yes;
$use_media=yes;
$use_media_photons=yes;
$high_quality_rad=yes;
$turbulent_media=no;
$phd=1.2;  // adjusts the density of the photons

//-------------------------------------------------

#include "colors.inc"
#include "glass.inc"

#if(clear_textures)
  $obj_finish=finish{F_Glass2 reflection .1}
#else
  $obj_finish=finish{phong 0 specular 0 diffuse .7 ambient 0}
#end

global_settings{
#if(clear_textures & use_photons)
  photons{
		spacing 0.02*phd
		max_trace_level 8
		gather 20, 60
		autostop 15
		jitter .5
		
    #if(use_media_photons)
    media 100
    #end
  }
#end
#if(use_rad)
  #if(high_quality_rad)
  radiosity {
  	pretrace_start 0.16
  	pretrace_end 0.04
    count 100            // CHANGE range from 20 to 150
    //count 200            // CHANGE range from 20 to 150
    nearest_count 7      // CHANGE range from 3 to 10
    //nearest_count 10      // CHANGE range from 3 to 10
    error_bound 1        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
    //error_bound .8        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
    recursion_limit 4    // CHANGE
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1         // leave this
    
    adc_bailout 0.01/(18*2)  // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
    #if(!use_light)
    max_sample 200      // CHANGE - max ambient light
    #end
  }
  
  #else
  radiosity {
  	pretrace_start 0.16
  	pretrace_end 0.08
    count 20             // CHANGE range from 20 to 150 (at least 80 if lit by ambient)
    nearest_count 3      // CHANGE range from 3 to 10
    error_bound 2.5      // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
    recursion_limit 4    // CHANGE
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1         // leave this

    adc_bailout 0.01/(18*2)  // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
  }
  
  #end
#end
}

camera{
  location <8,0,0>
  look_at <0,0,0>
  angle 45
} 

$wall_finish=finish{
  phong 0 specular 0 diffuse .7 ambient 0
  brilliance .4
}

$block_color=<.7,.7,.7>;
$pig1=pigment{
  gradient z
  color_map{
    [0.00 color block_color transmit 1]
    [0.05 color block_color transmit 1]
    [0.05 color block_color transmit .5]
    [0.10 color block_color transmit .5]
    [0.10 color block_color transmit 1]
    [0.90 color block_color transmit 1]
    [0.90 color block_color transmit .5]
    [0.95 color block_color transmit .5]
    [0.95 color block_color transmit 1]
    [1.00 color block_color transmit 1]
  }
}
$pig2=pigment{
  gradient z
  color_map{
    [0.00 color block_color transmit 1]
    [0.05 color block_color transmit 1]
    [0.05 color block_color transmit .5]
    [0.95 color block_color transmit .5]
    [0.95 color block_color transmit 1]
    [1.00 color block_color transmit 1]
  }
}
$box_tex=texture{
  pigment{
  gradient x
  pigment_map{
    [0.00 color block_color transmit 1]
    [0.05 color block_color transmit 1]
    [0.05 pig2]
    [0.10 pig2]
    [0.10 pig1]
    [0.90 pig1]
    [0.90 pig2]
    [0.95 pig2]
    [0.95 color block_color transmit 1]
    [1.00 color block_color transmit 1]
  }
  }
  finish{wall_finish}
}

#if(use_light)
light_source{
  <0,1.84,0>
  color <1,1,1>*11*4
  fade_power 2
  fade_distance .12*2
  photons{reflection off}
}
#end
box{
  -1,1

  texture{
    pigment{
      gradient y
      color_map{
        [0 rgbt<1,1,1,1>]
        [1 rgbt<1,1,1,0>]
      }
      scale <1,2,1>
      translate -.9*y
    }
    #if (use_light)
    finish{wall_finish ambient 1}
    #else
    finish{ambient 200 diffuse 0}
    #end
  }

  scale <.4,.05,.4>
  translate <0,1.9,0>

}

union{
sphere{
  <.2,-0.2,-1.0>,.5
  texture{
    pigment{
      #if (clear_textures)
        color White
        filter 1
      #else
        color Yellow*.8+<.1,.1,.1>
      #end
    }
    finish{obj_finish}
  }
  /*
  interior
  {
    media{
      absorption (1.0-Yellow)*2.5
    }
    
   ior 1.45
  }
  hollow
  */
  interior{ ior 1.3 fade_distance .8 fade_power 1001 fade_colour Yellow}
  
  photons {
	target 0.9
    refraction on
    reflection on
    ignore_photons
  }
}

cylinder
{
  0,  .6*y,  .5

  texture{
    pigment{
      #if (clear_textures)
        color White
        filter .9                      
      #else
        color Blue*.7+<.3,.3,.3>
      #end
    }
    finish{obj_finish}
    
  }
  interior{ ior 1.3 fade_distance .8 fade_power 1001 fade_colour Blue}
  photons {
	target 0.9
    refraction on
    reflection on
    ignore_photons
  }
  rotate 65*z
  rotate -115*y
  translate <.9,-1.4,1.4>
}


/*box{
  -1,1
  scale .5
  rotate 30*y
  translate <1,-1.5,1>
  texture{
    pigment{color Yellow}
    finish{wall_finish}
  }
}*/

union{
torus{
  .75,.25
  texture{
    pigment{
      #if (clear_textures)
        color White
        filter .9
      #else
        color Cyan*.7+<.2,.2,.2>
      #end
     }
    finish{obj_finish}
  }
  interior{ ior 1.3 fade_distance .8 fade_power 1001 fade_colour Cyan}
  photons{  ignore_photons}
}

cone{
  1.3*y,  0.0,
  <0,0,0>, .4
  texture{
    pigment{
      #if (clear_textures)
        color White
        filter .9
      #else
        color Green*.7+<.3,.3,.3>
      #end
     }
    finish{obj_finish}
  }
  interior{ ior 1.3 fade_distance .8 fade_power 1001 fade_colour Green}
  photons{  ignore_photons}
}
  rotate 65*z
  rotate -135*y
  translate <-.5,-.5,.5>
  photons {
    target 0.9
    refraction on
    reflection on
    ignore_photons
  }
}  

box{
  -1,1
  scale <2,2,.01>
  translate <0,0,2>

  texture{
    pigment{color Blue}
    finish{wall_finish}
  }
  texture{box_tex rotate 90*x}
}

box{
  -1,1
  scale <2,2,.01>
  translate <0,0,-2>

  texture{
    pigment{color Red}
    finish{wall_finish}
  }
  texture{box_tex rotate 90*x}
}

box{
  -1,1
  scale <.01,2,2>
  translate <-2,0,0>

  texture{
    pigment{color White}
    finish{wall_finish}
  }
  texture{box_tex rotate 90*z}
}

box{
  -1,1
  scale <2,.01,2>
  translate <0,2,0>

  texture{
    pigment{color Yellow}
    finish{wall_finish}
  }
  texture{box_tex}
}
box{
  -1,1
  scale <2,.01,2>
  translate <0,-2,0>

  texture{
    pigment{color White}
    finish{wall_finish}
  }
  texture{box_tex}
}

#if(use_media)
box{
  <-2,-2,-2>,<2,2,2>
  texture{pigment{rgbt<1,1,1,1>}}
  interior{
    media{
    intervals 1
    scattering { 1, rgb 0.07*3 extinction 3} // for some reason more extinction is needed for adaptive?
    //absorption .15
    //samples 10, 10  //use 1,4 or so for "quick" tests
    samples 20,20
    method 3
    aa_threshold .02
    aa_level 2
    jitter .2
    #if(turbulent_media)
      density{
        bozo
        color_map{
          [0 colour 0]
          [.5 colour 0]
          [.7 colour 1]
          [1 colour 1]
        }

        scale 3        
        warp {
          turbulence .5
          octaves 3
          lambda 4
          omega .4
        }
        scale 1/3
        scale .3
      }
    #end
    }
  }
  hollow
  photons{ignore_photons}
}
#end

}