//	Persistence of Vision Ray Tracer Scene Description File
//	File: Scene3.inc
//	Date: 4/28/2000
//	Author: Chris Huff
//	 
//*******************************************
light_source {<-50, 150,-100> color White}
light_source {CamLoc color White*0.2}


box {<-100, 0,-100>, < 100, 0, 10>
	texture {
		pigment {checker color Yellow color Red+Blue}
		finish {ambient 0.6}
//		normal {checker}
	}
}

//*******************************************
//#declare RS = seed(842);
//#declare RS = seed(4863);
//#declare RS = seed(48654);
#declare RS = seed(86315);

union {
	sphere {< 0, 0, 0>, 0.5}
	cylinder {< 0, 0, 0>, < 0, 0,-1>, 0.15}
	texture {
		pigment {color Green}
		finish {ambient 0.6}
	}
	transform {
		translate y*1.5
	}
}
union {
	#declare J=0;
	#while(J<10)
	sphere {< 0, 0, 0>, rand(RS)*0.5 + 0.2
		texture {
			pigment {color rgb < rand(RS), 0, rand(RS)>}
			finish {ambient 0.6}
		}
		translate <rand(RS)*6, rand(RS)*6, rand(RS)*6>-3
		rotate <rand(RS)*360, rand(RS)*360, 0>
		translate <rand(RS)*6, rand(RS)*6, rand(RS)*6>-3
	}
	cone {< 0, 0, 0>, rand(RS)*0.5 < rand(RS), rand(RS), rand(RS)>*rand(RS)*3, rand(RS)*0.15
		texture {
			pigment {color rgb < rand(RS), rand(RS), 0>}
			finish {ambient 0.6}
		}
		translate <rand(RS)*6, rand(RS)*6, rand(RS)*6>-3
		rotate <rand(RS)*360, rand(RS)*360, 0>
		translate <rand(RS)*6, rand(RS)*6, rand(RS)*6>-3
	}
	box {-< rand(RS), rand(RS), rand(RS)>*rand(RS)*3, < rand(RS), rand(RS), rand(RS)>*rand(RS)*3
		texture {
			pigment {color rgb < 0, rand(RS), rand(RS)>}
			finish {ambient 0.6}
		}
		translate <rand(RS)*6, rand(RS)*6, rand(RS)*6>-3
		rotate <rand(RS)*360, rand(RS)*360, 0>
		translate <rand(RS)*6, rand(RS)*6, rand(RS)*6>-3
	}
	#declare J=J+1;
	#end
}

//*******************************************


//-------------------------------------------
