// Persistence Of Vision raytracer version 3.1e isosurface patch
// sample file. By R.Suzuki.
// This image contains an example of 'isosurface' with library "i_nfunc".
#version unofficial MegaPov 0.4;

#include "colors.inc"
#include "textures.inc"

camera {
	location <24, 24, -45>
	angle 26
	look_at <0, -4, 0>
}

light_source { <150, 400, -120> color White }
light_source { <350, 200, -120> color White }

#declare LineObject =
isosurface {
	function   {"func_6", <6, 4/6, 0.4, 0.7, 1.5,1,0>, library "i_nfunc"}
	contained_by{ box {<-1.5, -0, -1.5>, <1.5, 8, 1.5>}}
	max_gradient 3.5
}

#declare CurveObject=
isosurface {
	function  {"func_12", <8.0, -24, 6, 0, 0.4, 0.7, 1/36, -6, 0.2,-64>, library "i_nfunc"}
	contained_by{ box {<-0, -2, -9.5>, <9.5, 2, 0>}}
	max_gradient 4.5
}

union {
	object { LineObject  rotate z*90   translate <0,0,-8> }
	object { CurveObject }
	texture { Yellow_Pine }
}

background { color Gray30 }
