// Persistence Of Vision raytracer version 3.1e isosurface patch
// sample file. By R.Suzuki.
// This image contains an example of 'isosurface'.
#version unofficial MegaPov 0.4;

global_settings { assumed_gamma 1.8 }

camera {  
	location <24, 16, -34>
	angle 20
	look_at <0, 0, 0>
}

light_source { <150, 400, -120> color red 1.0 green 1.0 blue 1.0 }
light_source { <350, 200, -120> color red 1.0 green 1.0 blue 1.0 }

background { color red 0.184314 green 0.309804 blue 0.309804 }

#declare R0 = 3;

isosurface {
	function {"sphere",<R0>}
	contained_by{ box {<-R0,-R0,-R0>,<R0,R0,R0>}}
	accuracy 0.01
	texture {
        pigment {color red 1.0 green 0.8 blue 0.5 }
        finish { phong 0.6 }
	}
	translate <0, 2, 0>
}

isosurface {
	function {"rounded_box", <0.5>}
	contained_by{ box {<-5, -3, -5>, <5, -1, 5> } }
	accuracy 0.01
	texture {
		pigment { color red 0.6 green 0.6 blue 1.0 }
		finish { phong 0.6}
	}
}
