// Persistence of Vision Ray Tracer Scene Description File
// Needs area light orient patch, text alignment and light_group patch
// File: orient_area.pov
// Description: Orient Tag Demonstration
// Date: 14/11/99
// Author: Eric Brown

#version unofficial MegaPov 0.4;


global_settings { assumed_gamma 1.8 }

camera {
	location  <0.0, 0.5, -8>
	right 4/3*x
	look_at <0.0, -1, 0.0>
	angle 50
}

background { rgb <0.848203, 0.823194, 0.711788> }

// Left area light (normal)
light_source {
	<0, 0, 0>
	rgb 1.0*1.2
	area_light <4, 0, 0>, <0, 4, 0>, 2, 2
	adaptive 0
	jitter
	translate <-1.5, 30, 0>
	groups "Normal"	//Will only lighten objects of the "Normal" light_group
}
sphere {
	0.0, 1
	texture { pigment { rgb <1, 0, 1> } }
	translate x*-1.5
	light_group "Normal"
}
box  {
	< -20, -3.2, 20 >, < 0.0, -3.0, -20 >
	texture { pigment { rgb <0.7, 0.5, 0.3> } }
	light_group "Normal"
}
text  {
	ttf "arial.ttf", "Normal"
	0.3, <0.0, 0.0, 0.0>
	position 1		//Centered text
	texture { pigment { rgb <0.857984, 0.022004, 0.565469> } }
	light_group "Normal"
	no_shadow
	rotate x*5
	translate <-2, -3.0, 2>
}

// Right area light (soft shadows)
// Testing the orient keyword
light_source {
	<0,0,0>
	rgb 1.0*1.2
	area_light <4, 0, 0> <0, 4, 0> 2, 2
	adaptive 0
	jitter
	orient					// comment out for normal area lights
	translate <1.5, 30, 0>
	groups "Orient"		//Will only lighten objects of the "Orient" light_group
}
sphere {
	0.0, 1
	texture {pigment { rgb <1, 0, 1> } }
	translate x*1.5
	light_group "Orient"
}
box  {
	<0, -3.2, 20>, <20, -3.0, -20>
	texture { pigment { rgb <0.7, 0.5, 0.3> } }
	light_group "Orient"
}
text  {
	ttf "arial.ttf", "Orient"
	0.3, <0.0, 0.0, 0.0>
	position 1		//Centered text
	texture { pigment { rgb <0.857984, 0.022004, 0.565469> } }
	light_group "Orient"
	no_shadow
	rotate x*5
	translate <2, -3.0, 2>
}
