//	Persistence of Vision Ray Tracer Scene Description File
//	File: date.pov
//	Date: 01/01/2000
//	Author: Yvo Smellenbergh
//	Demo scene for the 'date' keyword.
#version unofficial MegaPov 0.4;
global_settings {
	assumed_gamma 1.8
	ini_option "Width=600"
	ini_option "End_Column=600"
	ini_option "Height=240"
	ini_option "End_Row=240"
}

camera {
	location <0.0, 0.0, -15>
	up y*image_height right x*image_width
	angle 60
	look_at <0.0, 0.0, 0.0>
}

light_source { <100, 1000, -5000> 	rgb 1.2 }
	
#declare Down= 0.9;
#declare Day=date("%A")
#declare Month=date("%B")
#declare Daynr=date("%d")
#declare Monthnr=date("%m")
#declare Year=date("%Y (%y)")

#declare Font="arial.ttf"
text {
	ttf Font,
	concat("Today is ",Day)
	0.1, <0.0, 0.0, 0.0>
	align_center
	texture {
		pigment {
			rgb <0.369986, 0.514031, 0.910002>
		}
	}
	translate y*1.5

}
text {
	ttf Font,
	concat(Month," ",Daynr," ",Year)
	0.1, <0.0, 0.0, 0.0>
	align_center
	texture {
		pigment {
			rgb <0.369986, 0.514031, 0.910002>
		}
	}
	translate y*(1.5-Down)
}


text {
	ttf Font,
	concat("The time is: ",date("%X"))
	0.1, <0.0, 0.0, 0.0>
	align_center
	texture {
		pigment {
			rgb <0.369986, 0.514031, 0.910002>
		}
	}
	translate y*(1.5-(Down*2))
}

text { 
	ttf Font,
	concat("Or : ",date("%I:%M:%S %p"))
	0.1, <0.0, 0.0, 0.0>
	align_center
	texture {
		pigment {
			rgb <0.369986, 0.514031, 0.910002>
		}
	}
	translate y*(1.5-(Down*3))
}

text {
	ttf Font,
	concat("Or : ",date("%H:%M:%S")," (24h)")
	0.1, <0.0, 0.0, 0.0>
	align_center
	texture {
		pigment {
			rgb <0.369986, 0.514031, 0.910002>
		}
	}
	translate y*(1.5-(Down*4))
}

text {
	ttf Font,
	concat("timezone: ",date("%z"))
	0.1, <0.0, 0.0, 0.0>
	align_center
	texture {
		pigment {
			rgb <0.369986, 0.514031, 0.910002>
		}
	}
	translate y*(1.5-(Down*5))
}