/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GIMP_DISPLAY_SHELL_COORDS_H__
#define __GIMP_DISPLAY_SHELL_COORDS_H__


gboolean gimp_display_shell_get_event_coords   (GimpDisplayShell *shell,
                                                GdkEvent         *event,
                                                GdkDevice        *device,
                                                GimpCoords       *coords);
void     gimp_display_shell_get_device_coords  (GimpDisplayShell *shell,
                                                GdkDevice        *device,
                                                GimpCoords       *coords);
void     gimp_display_shell_get_time_coords    (GimpDisplayShell *shell,
                                                GdkDevice        *device,
                                                GdkTimeCoord     *event,
                                                GimpCoords       *coords);
gboolean gimp_display_shell_get_event_state    (GimpDisplayShell *shell,
                                                GdkEvent         *event,
                                                GdkDevice        *device,
                                                GdkModifierType  *state);
void     gimp_display_shell_get_device_state   (GimpDisplayShell *shell,
                                                GdkDevice        *device,
                                                GdkModifierType  *state);
gboolean gimp_display_shell_eval_event         (GimpDisplayShell *shell,
                                                GimpCoords       *coords,
                                                gdouble           inertia_factor,
                                                guint32           time);
void     gimp_display_shell_push_event_history (GimpDisplayShell *shell,
                                                GimpCoords       *coords);


#endif /* __GIMP_DISPLAY_SHELL_COORDS_H__ */
