/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include <string.h>

#include <glib-object.h>

#include "pdb-types.h"

#include "core/gimp-edit.h"
#include "core/gimp.h"
#include "core/gimpchannel.h"
#include "core/gimpdrawable-blend.h"
#include "core/gimpdrawable-bucket-fill.h"
#include "core/gimpdrawable.h"
#include "core/gimpimage.h"
#include "core/gimplayer.h"
#include "core/gimpparamspecs.h"
#include "core/gimpprogress.h"
#include "core/gimpstrokedesc.h"
#include "vectors/gimpvectors.h"

#include "gimppdb.h"
#include "gimppdb-utils.h"
#include "gimpprocedure.h"
#include "internal-procs.h"

#include "gimp-intl.h"


static GValueArray *
edit_cut_invoker (GimpProcedure      *procedure,
                  Gimp               *gimp,
                  GimpContext        *context,
                  GimpProgress       *progress,
                  const GValueArray  *args,
                  GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  gboolean non_empty = FALSE;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);

  if (success)
    {
      if (gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpImage *image    = gimp_item_get_image (GIMP_ITEM (drawable));
          GError    *my_error = NULL;

          non_empty = gimp_edit_cut (image, drawable, context, &my_error) != NULL;

          if (! non_empty)
            {
              gimp_message (gimp, G_OBJECT (progress), GIMP_MESSAGE_WARNING,
                            "%s", my_error->message);
              g_clear_error (&my_error);
            }
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_set_boolean (&return_vals->values[1], non_empty);

  return return_vals;
}

static GValueArray *
edit_copy_invoker (GimpProcedure      *procedure,
                   Gimp               *gimp,
                   GimpContext        *context,
                   GimpProgress       *progress,
                   const GValueArray  *args,
                   GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  gboolean non_empty = FALSE;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);

  if (success)
    {
      if (gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpImage *image    = gimp_item_get_image (GIMP_ITEM (drawable));
          GError    *my_error = NULL;

          non_empty = gimp_edit_copy (image, drawable, context, &my_error) != NULL;

          if (! non_empty)
            {
              gimp_message (gimp, G_OBJECT (progress), GIMP_MESSAGE_WARNING,
                            "%s", my_error->message);
              g_clear_error (&my_error);
            }
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_set_boolean (&return_vals->values[1], non_empty);

  return return_vals;
}

static GValueArray *
edit_copy_visible_invoker (GimpProcedure      *procedure,
                           Gimp               *gimp,
                           GimpContext        *context,
                           GimpProgress       *progress,
                           const GValueArray  *args,
                           GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpImage *image;
  gboolean non_empty = FALSE;

  image = gimp_value_get_image (&args->values[0], gimp);

  if (success)
    {
      GError *my_error = NULL;

      non_empty = gimp_edit_copy_visible (image, context, &my_error) != NULL;

      if (! non_empty)
        {
          gimp_message (gimp, G_OBJECT (progress), GIMP_MESSAGE_WARNING,
                        "%s", my_error->message);
          g_clear_error (&my_error);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_set_boolean (&return_vals->values[1], non_empty);

  return return_vals;
}

static GValueArray *
edit_paste_invoker (GimpProcedure      *procedure,
                    Gimp               *gimp,
                    GimpContext        *context,
                    GimpProgress       *progress,
                    const GValueArray  *args,
                    GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  gboolean paste_into;
  GimpLayer *floating_sel = NULL;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  paste_into = g_value_get_boolean (&args->values[1]);

  if (success)
    {
      if (gimp->global_buffer &&
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          floating_sel = gimp_edit_paste (gimp_item_get_image (GIMP_ITEM (drawable)),
                                          drawable, gimp->global_buffer,
                                          paste_into, -1, -1, -1, -1);

          if (! floating_sel)
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_layer (&return_vals->values[1], floating_sel);

  return return_vals;
}

static GValueArray *
edit_paste_as_new_invoker (GimpProcedure      *procedure,
                           Gimp               *gimp,
                           GimpContext        *context,
                           GimpProgress       *progress,
                           const GValueArray  *args,
                           GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpImage *image = NULL;

  if (gimp->global_buffer)
    {
      image = gimp_edit_paste_as_new (gimp, NULL, gimp->global_buffer);

      if (! image)
        success = FALSE;
    }
  else
    {
      image = NULL;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_image (&return_vals->values[1], image);

  return return_vals;
}

static GValueArray *
edit_named_cut_invoker (GimpProcedure      *procedure,
                        Gimp               *gimp,
                        GimpContext        *context,
                        GimpProgress       *progress,
                        const GValueArray  *args,
                        GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  const gchar *buffer_name;
  gchar *real_name = NULL;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  buffer_name = g_value_get_string (&args->values[1]);

  if (success)
    {
      if (gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpImage *image    = gimp_item_get_image (GIMP_ITEM (drawable));
          GError    *my_error = NULL;

          real_name = (gchar *) gimp_edit_named_cut (image, buffer_name,
                                                     drawable, context, &my_error);

          if (real_name)
            {
              real_name = g_strdup (real_name);
            }
          else
            {
              gimp_message (gimp, G_OBJECT (progress), GIMP_MESSAGE_WARNING,
                            "%s", my_error->message);
              g_clear_error (&my_error);
            }
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_take_string (&return_vals->values[1], real_name);

  return return_vals;
}

static GValueArray *
edit_named_copy_invoker (GimpProcedure      *procedure,
                         Gimp               *gimp,
                         GimpContext        *context,
                         GimpProgress       *progress,
                         const GValueArray  *args,
                         GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  const gchar *buffer_name;
  gchar *real_name = NULL;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  buffer_name = g_value_get_string (&args->values[1]);

  if (success)
    {
      if (gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpImage *image    = gimp_item_get_image (GIMP_ITEM (drawable));
          GError    *my_error = NULL;

          real_name = (gchar *) gimp_edit_named_copy (image, buffer_name,
                                                      drawable, context, &my_error);

          if (real_name)
            {
              real_name = g_strdup (real_name);
            }
          else
            {
              gimp_message (gimp, G_OBJECT (progress), GIMP_MESSAGE_WARNING,
                            "%s", my_error->message);
              g_clear_error (&my_error);
            }
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_take_string (&return_vals->values[1], real_name);

  return return_vals;
}

static GValueArray *
edit_named_copy_visible_invoker (GimpProcedure      *procedure,
                                 Gimp               *gimp,
                                 GimpContext        *context,
                                 GimpProgress       *progress,
                                 const GValueArray  *args,
                                 GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpImage *image;
  const gchar *buffer_name;
  gchar *real_name = NULL;

  image = gimp_value_get_image (&args->values[0], gimp);
  buffer_name = g_value_get_string (&args->values[1]);

  if (success)
    {
      GError *my_error = NULL;

      real_name = (gchar *) gimp_edit_named_copy_visible (image, buffer_name,
                                                          context, &my_error);

      if (real_name)
        {
          real_name = g_strdup (real_name);
        }
      else
        {
          gimp_message (gimp, G_OBJECT (progress), GIMP_MESSAGE_WARNING,
                        "%s", my_error->message);
          g_clear_error (&my_error);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_take_string (&return_vals->values[1], real_name);

  return return_vals;
}

static GValueArray *
edit_named_paste_invoker (GimpProcedure      *procedure,
                          Gimp               *gimp,
                          GimpContext        *context,
                          GimpProgress       *progress,
                          const GValueArray  *args,
                          GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  const gchar *buffer_name;
  gboolean paste_into;
  GimpLayer *floating_sel = NULL;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  buffer_name = g_value_get_string (&args->values[1]);
  paste_into = g_value_get_boolean (&args->values[2]);

  if (success)
    {
      GimpBuffer *buffer = gimp_pdb_get_buffer (gimp, buffer_name, error);

      if (buffer && gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          floating_sel = gimp_edit_paste (gimp_item_get_image (GIMP_ITEM (drawable)),
                                          drawable, buffer,
                                          paste_into, -1, -1, -1, -1);
          if (! floating_sel)
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_layer (&return_vals->values[1], floating_sel);

  return return_vals;
}

static GValueArray *
edit_named_paste_as_new_invoker (GimpProcedure      *procedure,
                                 Gimp               *gimp,
                                 GimpContext        *context,
                                 GimpProgress       *progress,
                                 const GValueArray  *args,
                                 GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  const gchar *buffer_name;
  GimpImage *image = NULL;

  buffer_name = g_value_get_string (&args->values[0]);

  if (success)
    {
      GimpBuffer *buffer = gimp_pdb_get_buffer (gimp, buffer_name, error);

      if (buffer)
        {
          image = gimp_edit_paste_as_new (gimp, NULL, buffer);

          if (! image)
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_image (&return_vals->values[1], image);

  return return_vals;
}

static GValueArray *
edit_clear_invoker (GimpProcedure      *procedure,
                    Gimp               *gimp,
                    GimpContext        *context,
                    GimpProgress       *progress,
                    const GValueArray  *args,
                    GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);

  if (success)
    {
      if (gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpImage *image = gimp_item_get_image (GIMP_ITEM (drawable));

          success = gimp_edit_clear (image, drawable, context);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
edit_fill_invoker (GimpProcedure      *procedure,
                   Gimp               *gimp,
                   GimpContext        *context,
                   GimpProgress       *progress,
                   const GValueArray  *args,
                   GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 fill_type;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  fill_type = g_value_get_enum (&args->values[1]);

  if (success)
    {
      if (gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpImage *image = gimp_item_get_image (GIMP_ITEM (drawable));

          success = gimp_edit_fill (image, drawable, context,
                                    (GimpFillType) fill_type);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
edit_bucket_fill_invoker (GimpProcedure      *procedure,
                          Gimp               *gimp,
                          GimpContext        *context,
                          GimpProgress       *progress,
                          const GValueArray  *args,
                          GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 fill_mode;
  gint32 paint_mode;
  gdouble opacity;
  gdouble threshold;
  gboolean sample_merged;
  gdouble x;
  gdouble y;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  fill_mode = g_value_get_enum (&args->values[1]);
  paint_mode = g_value_get_enum (&args->values[2]);
  opacity = g_value_get_double (&args->values[3]);
  threshold = g_value_get_double (&args->values[4]);
  sample_merged = g_value_get_boolean (&args->values[5]);
  x = g_value_get_double (&args->values[6]);
  y = g_value_get_double (&args->values[7]);

  if (success)
    {
      if (gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpImage *image = gimp_item_get_image (GIMP_ITEM (drawable));
          gboolean   do_seed_fill;

          do_seed_fill = gimp_channel_is_empty (gimp_image_get_mask (image));

          success = gimp_drawable_bucket_fill (drawable, context, fill_mode,
                                               paint_mode, opacity / 100.0,
                                               do_seed_fill,
                                               FALSE /* don't fill transparent */,
                                               GIMP_SELECT_CRITERION_COMPOSITE,
                                               threshold, sample_merged, x, y,
                                               error);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
edit_bucket_fill_full_invoker (GimpProcedure      *procedure,
                               Gimp               *gimp,
                               GimpContext        *context,
                               GimpProgress       *progress,
                               const GValueArray  *args,
                               GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 fill_mode;
  gint32 paint_mode;
  gdouble opacity;
  gdouble threshold;
  gboolean sample_merged;
  gboolean fill_transparent;
  gint32 select_criterion;
  gdouble x;
  gdouble y;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  fill_mode = g_value_get_enum (&args->values[1]);
  paint_mode = g_value_get_enum (&args->values[2]);
  opacity = g_value_get_double (&args->values[3]);
  threshold = g_value_get_double (&args->values[4]);
  sample_merged = g_value_get_boolean (&args->values[5]);
  fill_transparent = g_value_get_boolean (&args->values[6]);
  select_criterion = g_value_get_enum (&args->values[7]);
  x = g_value_get_double (&args->values[8]);
  y = g_value_get_double (&args->values[9]);

  if (success)
    {
      if (gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpImage *image = gimp_item_get_image (GIMP_ITEM (drawable));
          gboolean   do_seed_fill;

          do_seed_fill = gimp_channel_is_empty (gimp_image_get_mask (image));

          success = gimp_drawable_bucket_fill (drawable, context, fill_mode,
                                               paint_mode, opacity / 100.0,
                                               do_seed_fill,
                                               fill_transparent,
                                               select_criterion,
                                               threshold, sample_merged, x, y,
                                               error);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
edit_blend_invoker (GimpProcedure      *procedure,
                    Gimp               *gimp,
                    GimpContext        *context,
                    GimpProgress       *progress,
                    const GValueArray  *args,
                    GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 blend_mode;
  gint32 paint_mode;
  gint32 gradient_type;
  gdouble opacity;
  gdouble offset;
  gint32 repeat;
  gboolean reverse;
  gboolean supersample;
  gint32 max_depth;
  gdouble threshold;
  gboolean dither;
  gdouble x1;
  gdouble y1;
  gdouble x2;
  gdouble y2;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  blend_mode = g_value_get_enum (&args->values[1]);
  paint_mode = g_value_get_enum (&args->values[2]);
  gradient_type = g_value_get_enum (&args->values[3]);
  opacity = g_value_get_double (&args->values[4]);
  offset = g_value_get_double (&args->values[5]);
  repeat = g_value_get_enum (&args->values[6]);
  reverse = g_value_get_boolean (&args->values[7]);
  supersample = g_value_get_boolean (&args->values[8]);
  max_depth = g_value_get_int (&args->values[9]);
  threshold = g_value_get_double (&args->values[10]);
  dither = g_value_get_boolean (&args->values[11]);
  x1 = g_value_get_double (&args->values[12]);
  y1 = g_value_get_double (&args->values[13]);
  x2 = g_value_get_double (&args->values[14]);
  y2 = g_value_get_double (&args->values[15]);

  if (success)
    {
      success = gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error);

      if (success && supersample)
        {
          if (max_depth < 1 || max_depth > 9)
            success = FALSE;

          if (threshold < 0.0 || threshold > 4.0)
            success = FALSE;
        }

      if (success)
        {
          if (progress)
            gimp_progress_start (progress, _("Blending"), FALSE);

          gimp_drawable_blend (drawable,
                               context,
                               blend_mode,
                               paint_mode,
                               gradient_type,
                               opacity / 100.0,
                               offset, repeat, reverse,
                               supersample, max_depth,
                               threshold, dither,
                               x1, y1, x2, y2,
                               progress);

          if (progress)
            gimp_progress_end (progress);
        }
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
edit_stroke_invoker (GimpProcedure      *procedure,
                     Gimp               *gimp,
                     GimpContext        *context,
                     GimpProgress       *progress,
                     const GValueArray  *args,
                     GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);

  if (success)
    {
      if (gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpImage      *image = gimp_item_get_image (GIMP_ITEM (drawable));
          GimpStrokeDesc *desc  = gimp_stroke_desc_new (gimp, context);

          g_object_set (desc, "method", GIMP_STROKE_METHOD_PAINT_CORE, NULL);

          success = gimp_item_stroke (GIMP_ITEM (gimp_image_get_mask (image)),
                                      drawable, context, desc, TRUE, progress,
                                      error);

          g_object_unref (desc);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
edit_stroke_vectors_invoker (GimpProcedure      *procedure,
                             Gimp               *gimp,
                             GimpContext        *context,
                             GimpProgress       *progress,
                             const GValueArray  *args,
                             GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  GimpVectors *vectors;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  vectors = gimp_value_get_vectors (&args->values[1], gimp);

  if (success)
    {
      if (gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpStrokeDesc *desc  = gimp_stroke_desc_new (gimp, context);

          g_object_set (desc, "method", GIMP_STROKE_METHOD_PAINT_CORE, NULL);

          success = gimp_item_stroke (GIMP_ITEM (vectors),
                                      drawable, context, desc, TRUE, progress,
                                      error);

          g_object_unref (desc);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

void
register_edit_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-edit-cut
   */
  procedure = gimp_procedure_new (edit_cut_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-edit-cut");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-edit-cut",
                                     "Cut from the specified drawable.",
                                     "If there is a selection in the image, then the area specified by the selection is cut from the specified drawable and placed in an internal GIMP edit buffer. It can subsequently be retrieved using the 'gimp-edit-paste' command. If there is no selection, then the specified drawable will be removed and its contents stored in the internal GIMP edit buffer. This procedure will fail if the selected area lies completely outside the bounds of the current drawable and there is nothing to copy from.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The drawable to cut from",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("non-empty",
                                                         "non empty",
                                                         "TRUE if the cut was successful, FALSE if there was nothing to copy from",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-edit-copy
   */
  procedure = gimp_procedure_new (edit_copy_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-edit-copy");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-edit-copy",
                                     "Copy from the specified drawable.",
                                     "If there is a selection in the image, then the area specified by the selection is copied from the specified drawable and placed in an internal GIMP edit buffer. It can subsequently be retrieved using the 'gimp-edit-paste' command. If there is no selection, then the specified drawable's contents will be stored in the internal GIMP edit buffer. This procedure will fail if the selected area lies completely outside the bounds of the current drawable and there is nothing to copy from.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The drawable to copy from",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("non-empty",
                                                         "non empty",
                                                         "TRUE if the cut was successful, FALSE if there was nothing to copy from",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-edit-copy-visible
   */
  procedure = gimp_procedure_new (edit_copy_visible_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-edit-copy-visible");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-edit-copy-visible",
                                     "Copy from the projection.",
                                     "If there is a selection in the image, then the area specified by the selection is copied from the projection and placed in an internal GIMP edit buffer. It can subsequently be retrieved using the 'gimp-edit-paste' command. If there is no selection, then the projection's contents will be stored in the internal GIMP edit buffer.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image to copy from",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("non-empty",
                                                         "non empty",
                                                         "TRUE if the copy was successful",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-edit-paste
   */
  procedure = gimp_procedure_new (edit_paste_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-edit-paste");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-edit-paste",
                                     "Paste buffer to the specified drawable.",
                                     "This procedure pastes a copy of the internal GIMP edit buffer to the specified drawable. The GIMP edit buffer will be empty unless a call was previously made to either 'gimp-edit-cut' or 'gimp-edit-copy'. The \"paste_into\" option specifies whether to clear the current image selection, or to paste the buffer \"behind\" the selection. This allows the selection to act as a mask for the pasted buffer. Anywhere that the selection mask is non-zero, the pasted buffer will show through. The pasted buffer will be a new layer in the image which is designated as the image floating selection. If the image has a floating selection at the time of pasting, the old floating selection will be anchored to it's drawable before the new floating selection is added. This procedure returns the new floating layer. The resulting floating selection will already be attached to the specified drawable, and a subsequent call to floating_sel_attach is not needed.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The drawable to paste to",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("paste-into",
                                                     "paste into",
                                                     "Clear selection, or paste behind it?",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_layer_id ("floating-sel",
                                                             "floating sel",
                                                             "The new floating selection",
                                                             pdb->gimp, FALSE,
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-edit-paste-as-new
   */
  procedure = gimp_procedure_new (edit_paste_as_new_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-edit-paste-as-new");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-edit-paste-as-new",
                                     "Paste buffer to a new image.",
                                     "This procedure pastes a copy of the internal GIMP edit buffer to a new image. The GIMP edit buffer will be empty unless a call was previously made to either 'gimp-edit-cut' or 'gimp-edit-copy'. This procedure returns the new image or -1 if the edit buffer was empty.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2005",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_image_id ("image",
                                                             "image",
                                                             "The new image",
                                                             pdb->gimp, FALSE,
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-edit-named-cut
   */
  procedure = gimp_procedure_new (edit_named_cut_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-edit-named-cut");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-edit-named-cut",
                                     "Cut into a named buffer.",
                                     "This procedure works like 'gimp-edit-cut', but additionally stores the cut buffer into a named buffer that will stay available for later pasting, regardless of any intermediate copy or cut operations.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2005",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The drawable to cut from",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("buffer-name",
                                                       "buffer name",
                                                       "The name of the buffer to create",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("real-name",
                                                           "real name",
                                                           "The real name given to the buffer, or NULL if the cut failed",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-edit-named-copy
   */
  procedure = gimp_procedure_new (edit_named_copy_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-edit-named-copy");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-edit-named-copy",
                                     "Copy into a named buffer.",
                                     "This procedure works like 'gimp-edit-copy', but additionally stores the copied buffer into a named buffer that will stay available for later pasting, regardless of any intermediate copy or cut operations.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2005",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The drawable to copy from",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("buffer-name",
                                                       "buffer name",
                                                       "The name of the buffer to create",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("real-name",
                                                           "real name",
                                                           "The real name given to the buffer, or NULL if the copy failed",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-edit-named-copy-visible
   */
  procedure = gimp_procedure_new (edit_named_copy_visible_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-edit-named-copy-visible");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-edit-named-copy-visible",
                                     "Copy from the projection into a named buffer.",
                                     "This procedure works like 'gimp-edit-copy-visible', but additionally stores the copied buffer into a named buffer that will stay available for later pasting, regardless of any intermediate copy or cut operations.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2005",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image to copy from",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("buffer-name",
                                                       "buffer name",
                                                       "The name of the buffer to create",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("real-name",
                                                           "real name",
                                                           "The real name given to the buffer, or NULL if the copy failed",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-edit-named-paste
   */
  procedure = gimp_procedure_new (edit_named_paste_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-edit-named-paste");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-edit-named-paste",
                                     "Paste named buffer to the specified drawable.",
                                     "This procedure works like 'gimp-edit-paste' but pastes a named buffer instead of the global buffer.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2005",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The drawable to paste to",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("buffer-name",
                                                       "buffer name",
                                                       "The name of the buffer to paste",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("paste-into",
                                                     "paste into",
                                                     "Clear selection, or paste behind it?",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_layer_id ("floating-sel",
                                                             "floating sel",
                                                             "The new floating selection",
                                                             pdb->gimp, FALSE,
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-edit-named-paste-as-new
   */
  procedure = gimp_procedure_new (edit_named_paste_as_new_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-edit-named-paste-as-new");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-edit-named-paste-as-new",
                                     "Paste named buffer to a new image.",
                                     "This procedure works like 'gimp-edit-paste-as-new' but pastes a named buffer instead of the global buffer.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2005",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("buffer-name",
                                                       "buffer name",
                                                       "The name of the buffer to paste",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_image_id ("image",
                                                             "image",
                                                             "The new image",
                                                             pdb->gimp, FALSE,
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-edit-clear
   */
  procedure = gimp_procedure_new (edit_clear_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-edit-clear");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-edit-clear",
                                     "Clear selected area of drawable.",
                                     "This procedure clears the specified drawable. If the drawable has an alpha channel, the cleared pixels will become transparent. If the drawable does not have an alpha channel, cleared pixels will be set to the background color. This procedure only affects regions within a selection if there is a selection active.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The drawable to clear from",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-edit-fill
   */
  procedure = gimp_procedure_new (edit_fill_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-edit-fill");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-edit-fill",
                                     "Fill selected area of drawable.",
                                     "This procedure fills the specified drawable with the fill mode. If the fill mode is foreground, the current foreground color is used. If the fill mode is background, the current background color is used. Other fill modes should not be used. This procedure only affects regions within a selection if there is a selection active. If you want to fill the whole drawable, regardless of the selection, use 'gimp-drawable-fill'.",
                                     "Spencer Kimball & Peter Mattis & Raphael Quinet",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-2000",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The drawable to fill to",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("fill-type",
                                                  "fill type",
                                                  "The type of fill",
                                                  GIMP_TYPE_FILL_TYPE,
                                                  GIMP_FOREGROUND_FILL,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-edit-bucket-fill
   */
  procedure = gimp_procedure_new (edit_bucket_fill_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-edit-bucket-fill");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-edit-bucket-fill",
                                     "Fill the area specified either by the current selection if there is one, or by a seed fill starting at the specified coordinates.",
                                     "This tool requires information on the paint application mode, and the fill mode, which can either be in the foreground color, or in the currently active pattern. If there is no selection, a seed fill is executed at the specified coordinates and extends outward in keeping with the threshold parameter. If there is a selection in the target image, the threshold, sample merged, x, and y arguments are unused. If the sample_merged parameter is TRUE, the data of the composite image will be used instead of that for the specified drawable. This is equivalent to sampling for colors after merging all visible layers. In the case of merged sampling, the x and y coordinates are relative to the image's origin; otherwise, they are relative to the drawable's origin.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("fill-mode",
                                                  "fill mode",
                                                  "The type of fill",
                                                  GIMP_TYPE_BUCKET_FILL_MODE,
                                                  GIMP_FG_BUCKET_FILL,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("paint-mode",
                                                  "paint mode",
                                                  "The paint application mode",
                                                  GIMP_TYPE_LAYER_MODE_EFFECTS,
                                                  GIMP_NORMAL_MODE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("opacity",
                                                    "opacity",
                                                    "The opacity of the final bucket fill",
                                                    0, 100, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("threshold",
                                                    "threshold",
                                                    "The threshold determines how extensive the seed fill will be. It's value is specified in terms of intensity levels. This parameter is only valid when there is no selection in the specified image.",
                                                    0, 255, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("sample-merged",
                                                     "sample merged",
                                                     "Use the composite image, not the drawable",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x",
                                                    "x",
                                                    "The x coordinate of this bucket fill's application. This parameter is only valid when there is no selection in the specified image.",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y",
                                                    "y",
                                                    "The y coordinate of this bucket fill's application. This parameter is only valid when there is no selection in the specified image.",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-edit-bucket-fill-full
   */
  procedure = gimp_procedure_new (edit_bucket_fill_full_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-edit-bucket-fill-full");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-edit-bucket-fill-full",
                                     "Fill the area specified either by the current selection if there is one, or by a seed fill starting at the specified coordinates.",
                                     "This tool requires information on the paint application mode, and the fill mode, which can either be in the foreground color, or in the currently active pattern. If there is no selection, a seed fill is executed at the specified coordinates and extends outward in keeping with the threshold parameter. If there is a selection in the target image, the threshold, sample merged, x, and y arguments are unused. If the sample_merged parameter is TRUE, the data of the composite image will be used instead of that for the specified drawable. This is equivalent to sampling for colors after merging all visible layers. In the case of merged sampling, the x and y coordinates are relative to the image's origin; otherwise, they are relative to the drawable's origin.",
                                     "David Gowers",
                                     "David Gowers",
                                     "2006",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("fill-mode",
                                                  "fill mode",
                                                  "The type of fill",
                                                  GIMP_TYPE_BUCKET_FILL_MODE,
                                                  GIMP_FG_BUCKET_FILL,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("paint-mode",
                                                  "paint mode",
                                                  "The paint application mode",
                                                  GIMP_TYPE_LAYER_MODE_EFFECTS,
                                                  GIMP_NORMAL_MODE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("opacity",
                                                    "opacity",
                                                    "The opacity of the final bucket fill",
                                                    0, 100, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("threshold",
                                                    "threshold",
                                                    "The threshold determines how extensive the seed fill will be. It's value is specified in terms of intensity levels. This parameter is only valid when there is no selection in the specified image.",
                                                    0, 255, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("sample-merged",
                                                     "sample merged",
                                                     "Use the composite image, not the drawable",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("fill-transparent",
                                                     "fill transparent",
                                                     "Whether to consider transparent pixels for filling. If TRUE, transparency is considered as a unique fillable color.",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("select-criterion",
                                                  "select criterion",
                                                  "The criterion used to determine color similarity. SELECT_CRITERION_COMPOSITE is the standard choice.",
                                                  GIMP_TYPE_SELECT_CRITERION,
                                                  GIMP_SELECT_CRITERION_COMPOSITE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x",
                                                    "x",
                                                    "The x coordinate of this bucket fill's application. This parameter is only valid when there is no selection in the specified image.",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y",
                                                    "y",
                                                    "The y coordinate of this bucket fill's application. This parameter is only valid when there is no selection in the specified image.",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-edit-blend
   */
  procedure = gimp_procedure_new (edit_blend_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-edit-blend");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-edit-blend",
                                     "Blend between the starting and ending coordinates with the specified blend mode and gradient type.",
                                     "This tool requires information on the paint application mode, the blend mode, and the gradient type. It creates the specified variety of blend using the starting and ending coordinates as defined for each gradient type.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("blend-mode",
                                                  "blend mode",
                                                  "The type of blend",
                                                  GIMP_TYPE_BLEND_MODE,
                                                  GIMP_FG_BG_RGB_MODE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("paint-mode",
                                                  "paint mode",
                                                  "The paint application mode",
                                                  GIMP_TYPE_LAYER_MODE_EFFECTS,
                                                  GIMP_NORMAL_MODE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("gradient-type",
                                                  "gradient type",
                                                  "The type of gradient",
                                                  GIMP_TYPE_GRADIENT_TYPE,
                                                  GIMP_GRADIENT_LINEAR,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("opacity",
                                                    "opacity",
                                                    "The opacity of the final blend",
                                                    0, 100, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("offset",
                                                    "offset",
                                                    "Offset relates to the starting and ending coordinates specified for the blend. This parameter is mode dependent.",
                                                    0, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("repeat",
                                                  "repeat",
                                                  "Repeat mode",
                                                  GIMP_TYPE_REPEAT_MODE,
                                                  GIMP_REPEAT_NONE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("reverse",
                                                     "reverse",
                                                     "Use the reverse gradient",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("supersample",
                                                     "supersample",
                                                     "Do adaptive supersampling",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("max-depth",
                                                      "max depth",
                                                      "Maximum recursion levels for supersampling",
                                                      1, 9, 1,
                                                      GIMP_PARAM_READWRITE | GIMP_PARAM_NO_VALIDATE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("threshold",
                                                    "threshold",
                                                    "Supersampling threshold",
                                                    0, 4, 0,
                                                    GIMP_PARAM_READWRITE | GIMP_PARAM_NO_VALIDATE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("dither",
                                                     "dither",
                                                     "Use dithering to reduce banding",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x1",
                                                    "x1",
                                                    "The x coordinate of this blend's starting point",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y1",
                                                    "y1",
                                                    "The y coordinate of this blend's starting point",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x2",
                                                    "x2",
                                                    "The x coordinate of this blend's ending point",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y2",
                                                    "y2",
                                                    "The y coordinate of this blend's ending point",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-edit-stroke
   */
  procedure = gimp_procedure_new (edit_stroke_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-edit-stroke");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-edit-stroke",
                                     "Stroke the current selection",
                                     "This procedure strokes the current selection, painting along the selection boundary with the active brush and foreground color. The paint is applied to the specified drawable regardless of the active selection.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The drawable to stroke to",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-edit-stroke-vectors
   */
  procedure = gimp_procedure_new (edit_stroke_vectors_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-edit-stroke-vectors");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-edit-stroke-vectors",
                                     "Stroke the specified vectors object",
                                     "This procedure strokes the specified vectors object, painting along the path with the active brush and foreground color.",
                                     "Simon Budig",
                                     "Simon Budig",
                                     "2006",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The drawable to stroke to",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_vectors_id ("vectors",
                                                           "vectors",
                                                           "The vectors object",
                                                           pdb->gimp, FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
