package netfu.types;

import java.awt.*;
import netfu.selectors.*;

public class GRGBColor extends Type {

	int red = 0, green = 0, blue = 0;

	public GRGBColor () { super (); }

	public void setDefaults (String[] defaults) {
		red = Integer.parseInt (defaults[0]);
		green=Integer.parseInt (defaults[1]);
		blue= Integer.parseInt (defaults[2]);
	}

	public GRGBColor (int _red, int _green, int _blue) {
		red = _red; blue = _blue; green = _green;
	}

	public Selector select () {
	    return new GRGBColorSelector (red, green, blue);
	}


	/**
	 * Return '(red_value, green_value, blue_value)
	 */

	public String toList () {
		return ( "\'(" + red + " " + green + " " + blue	+")" );
	}
}
