package netfu.selectors;


import java.awt.*;

public class GTextField extends TextField implements Selector {

    protected static final int maxDisplayLength = 18;
    protected static final int maxLength = 40;

    public GTextField ()
	{
	    super (maxDisplayLength);
	}

    public GTextField (String default_)
	{
	    super (maxDisplayLength);
	    setText (default_);
	}

    public Object selectedValue ()
	{
	    int quotePos = 0, startPos = 0;
	    String chunk, ret_val;
	    String val = this.getText ();
	    StringBuffer newVal
		= new StringBuffer ();

	    while (quotePos != -1) {
		quotePos = val.indexOf ('\"', startPos);

		if (quotePos != -1) {
		    chunk = val.substring (startPos, quotePos);
		    newVal.append (chunk);
		    if (val.charAt (quotePos-1) != '\\')
		       newVal.append ('\\');
		    newVal.append ('\"');
		    startPos = quotePos+1;
		} else
		    newVal.append (val.substring (startPos));
	    }

	    if (newVal.length () < maxLength)
	       ret_val = '\"' + newVal.toString () + '\"';
	    else
	       if (newVal.length () > maxLength &&
	       	   newVal.charAt (maxLength - 1) == '\\') {
		   newVal.setCharAt (maxLength - 1, '\"');
		   ret_val = '\"' + newVal.toString ();
	       }
	    else
		ret_val = '\"' + newVal.toString ().substring (0, maxLength) + '\"';

	    return ret_val;
	}

    public void selectValue (Object o) { this.setText ((String) o); }

    public Component component () { return this; }

    public static void main (String[] args) {
	System.out.println (test (args [0]));
    }

    public static String test (String str)
	{
	    int quotePos = 0, startPos = 0;
	    String chunk, ret_val;
	    String val = str;
	    StringBuffer newVal
		= new StringBuffer ();

	    System.out.println ("strTest = " + str);

	    while (quotePos != -1) {
		quotePos = val.indexOf ('\"', startPos);

		if (quotePos != -1) {
		    chunk = val.substring (startPos, quotePos);
		    newVal.append (chunk);
		    if (str.charAt (quotePos-1) != '\\')
		       newVal.append ('\\');
		    newVal.append ('\"');
		    startPos = quotePos+1;
		} else
		    newVal.append (val.substring (startPos));
	    }

	    if (newVal.length () < maxLength)
	       ret_val = '\"' + newVal.toString () + '\"';
	    else
	       if (newVal.length () > maxLength &&
	       	   newVal.charAt (maxLength - 1) == '\\') {
		   newVal.setCharAt (maxLength - 1, '\"');
		   ret_val = '\"' + newVal.toString ();
	       }
	    else
		ret_val = '\"' + newVal.toString ().substring (0, maxLength)
					+ '\"';

	    return ret_val;
    }
}
